/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.history;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.bean.HistoryRecord;
import com.yy.hiyo.channel.plugins.bocai.ui.view.history.HistoryAdapter;
import java.util.List;

public class HistoryDialog
implements BaseDialog {
    private List<HistoryRecord> mData;
    private IHistoryLoadListener mListener;
    private String mCursor;
    private HistoryAdapter mAdapter;

    public HistoryDialog(String cursor, List<HistoryRecord> list) {
        this.mData = list;
        this.mCursor = cursor;
    }

    public void setLoadMoreListener(IHistoryLoadListener listener) {
        this.mListener = listener;
    }

    public void init(final Dialog dialog) {
        this.mAdapter = new HistoryAdapter(dialog.getContext(), this.mData);
        View view = View.inflate((Context)dialog.getContext(), (int)R.layout.layout_wealth_history_channel, null);
        final SmartRefreshLayout rlContent = (SmartRefreshLayout)view.findViewById(R.id.srl_wealth_refresh);
        rlContent.setEnableRefresh(false);
        TextView tvHistory = (TextView)view.findViewById(R.id.tv_wealth_history_null);
        RecyclerView rvHistory = (RecyclerView)view.findViewById(R.id.rv_wealth_content);
        if (this.mData != null && this.mData.size() > 0) {
            rlContent.setVisibility(0);
            tvHistory.setVisibility(8);
            rvHistory.setVisibility(0);
        } else {
            rlContent.setVisibility(8);
            tvHistory.setVisibility(0);
            rvHistory.setVisibility(8);
        }
        rlContent.setOnLoadMoreListener(new OnLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                if (HistoryDialog.this.mListener != null) {
                    HistoryDialog.this.mListener.onLoad(HistoryDialog.this.mCursor);
                }
                rlContent.finishLoadMore();
            }
        });
        rvHistory.setAdapter((RecyclerView.Adapter)this.mAdapter);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(dialog.getContext());
        rvHistory.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        dialog.setContentView(view, new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)310.0f), ResolutionUtils.dip2Px((float)450.0f)));
        RecycleImageView rvClose = (RecycleImageView)view.findViewById(R.id.rv_wealth_history_close);
        rvClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
    }

    public int getId() {
        return 0;
    }

    public void addHistoryRecord(List<HistoryRecord> list, String cursor) {
        this.mCursor = cursor;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTWealth", (String)"addHistoryRecord, cursor:%s", (Object[])new Object[]{cursor});
        }
        if (this.mAdapter != null) {
            this.mAdapter.addData(list);
        }
    }

    public static interface IHistoryLoadListener {
        public void onLoad(String var1);
    }
}

