/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.view;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.bocai.R;

public class BocaiLoadingBtnView
extends YYFrameLayout {
    private View leftHolderView;
    private TextView textView;
    private ImageView rightLoadingView;
    private String text = "";
    private int textSize = ResolutionUtils.dip2Px((float)16.0f);
    private int textColor = -1;
    private int loadingSize = ResolutionUtils.dip2Px((float)15.0f);
    private int loadingSpace = ResolutionUtils.dip2Px((float)3.0f);
    private boolean loading = false;
    private ObjectAnimator loadingAnimator;

    public BocaiLoadingBtnView(Context context) {
        super(context);
        this.createView();
    }

    public BocaiLoadingBtnView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BocaiLoadingBtnView);
        this.initAttrs(ta);
        ta.recycle();
        this.createView();
    }

    public BocaiLoadingBtnView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BocaiLoadingBtnView);
        this.initAttrs(ta);
        ta.recycle();
        this.createView();
    }

    private void createView() {
        BocaiLoadingBtnView.inflate((Context)this.getContext(), (int)R.layout.layout_bocai_loading_btn_channel, (ViewGroup)this);
        this.leftHolderView = this.findViewById(R.id.left_holder);
        this.textView = (TextView)this.findViewById(R.id.text);
        this.rightLoadingView = (ImageView)this.findViewById(R.id.right_loading);
        this.setText(this.text);
        this.setTextSize(this.textSize);
        this.setTextColor(this.textColor);
        this.setLoadingSize(this.loadingSize);
        this.setLoadingSpace(this.loadingSpace);
    }

    private void initAttrs(TypedArray typedArray) {
        this.text = typedArray.getString(R.styleable.BocaiLoadingBtnView_btn_text);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.BocaiLoadingBtnView_btn_textSize, this.textSize);
        this.textColor = typedArray.getColor(R.styleable.BocaiLoadingBtnView_btn_textColor, this.textColor);
        this.loadingSize = typedArray.getDimensionPixelSize(R.styleable.BocaiLoadingBtnView_btn_loadingSize, this.loadingSize);
        this.loadingSpace = typedArray.getDimensionPixelSize(R.styleable.BocaiLoadingBtnView_btn_loadingSpace, this.loadingSpace);
    }

    public void setText(String text) {
        this.text = text;
        this.textView.setText((CharSequence)text);
    }

    public void setText(int textRes) {
        this.setText(ResourceUtils.getString((int)textRes));
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.textView.setTextSize(0, (float)textSize);
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.textView.setTextColor(textColor);
    }

    public void setLoadingSize(int loadingSize) {
        this.loadingSize = loadingSize;
        LinearLayout.LayoutParams holderLp = (LinearLayout.LayoutParams)this.leftHolderView.getLayoutParams();
        holderLp.width = loadingSize;
        holderLp.height = loadingSize;
        this.leftHolderView.setLayoutParams((ViewGroup.LayoutParams)holderLp);
        LinearLayout.LayoutParams loadingLp = (LinearLayout.LayoutParams)this.rightLoadingView.getLayoutParams();
        loadingLp.width = loadingSize;
        loadingLp.height = loadingSize;
        this.rightLoadingView.setLayoutParams((ViewGroup.LayoutParams)holderLp);
    }

    public void setLoadingSpace(int loadingSpace) {
        this.loadingSpace = loadingSpace;
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.textView.getLayoutParams();
        lp.leftMargin = loadingSpace;
        lp.rightMargin = loadingSpace;
    }

    public void setLoading(boolean loading) {
        if (this.loading == loading) {
            return;
        }
        this.loading = loading;
        if (loading) {
            this.startLoadingAnim();
        } else {
            this.stopLoadingAnim();
        }
    }

    private void startLoadingAnim() {
        this.rightLoadingView.setVisibility(0);
        this.loadingAnimator = ObjectAnimator.ofFloat((Object)this.rightLoadingView, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        this.loadingAnimator.setDuration(800L);
        this.loadingAnimator.setRepeatCount(-1);
        this.loadingAnimator.setRepeatMode(1);
        this.loadingAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.loadingAnimator.start();
    }

    private void stopLoadingAnim() {
        if (this.loadingAnimator != null) {
            this.loadingAnimator.cancel();
        }
        this.rightLoadingView.setVisibility(4);
    }
}

