/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.data.proto;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.HistoryRecord;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.data.proto.ProtoErrorCode;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.spinach.CancelReq;
import net.ihago.money.api.spinach.CancelRes;
import net.ihago.money.api.spinach.CloseReq;
import net.ihago.money.api.spinach.CloseRes;
import net.ihago.money.api.spinach.Conf;
import net.ihago.money.api.spinach.GetConfsReq;
import net.ihago.money.api.spinach.GetConfsRes;
import net.ihago.money.api.spinach.GetInfoReq;
import net.ihago.money.api.spinach.GetInfoRes;
import net.ihago.money.api.spinach.GetWinRecordsReq;
import net.ihago.money.api.spinach.GetWinRecordsRes;
import net.ihago.money.api.spinach.JoinReq;
import net.ihago.money.api.spinach.JoinRes;
import net.ihago.money.api.spinach.MemberResult;
import net.ihago.money.api.spinach.OpenReq;
import net.ihago.money.api.spinach.OpenRes;
import net.ihago.money.api.spinach.Record;
import net.ihago.money.api.spinach.StartReq;
import net.ihago.money.api.spinach.StartRes;

public class ProtoServiceManager {
    public void getConfig(final IGetConfigCallback callback) {
        GetConfsReq req = new GetConfsReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetConfsRes>(){

            public void onResponse(@NonNull GetConfsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"getConfig fail, message null", (Object[])new Object[0]);
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"getConfig fail, code:%s, msg:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code)});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                ArrayList<WealthConfigData> wealthConfigDataList = new ArrayList<WealthConfigData>();
                int minMember = message.min_members;
                int maxMember = message.max_members;
                if (message.confs == null) {
                    if (callback != null) {
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTWealth", (String)"getConfig success, min:%s, max:%s, data:%s", (Object[])new Object[]{minMember, maxMember, wealthConfigDataList});
                        }
                        callback.onSuccess(wealthConfigDataList, minMember, maxMember);
                    }
                    return;
                }
                for (Conf conf : message.confs) {
                    WealthConfigData data;
                    if (conf == null || (data = WealthConfigData.createFromConf(conf)) == null) continue;
                    wealthConfigDataList.add(data);
                }
                if (callback != null) {
                    FeatureLog.i((String)"FTWealth", (String)"getConfig success, min:%s, max:%s, data:%s", (Object[])new Object[]{minMember, maxMember, wealthConfigDataList});
                    callback.onSuccess(wealthConfigDataList, minMember, maxMember);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getConfig timeout", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getConfig error, code:%s, reason:%s", (Object[])new Object[]{code, reason});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void open(final String roomId, final int confId, final IOpenCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTWealth", (String)"open roomId null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
        }
        OpenReq req = new OpenReq.Builder().conf_id(Integer.valueOf(confId)).rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<OpenRes>(){
            String mRoomId;
            int mConfId;
            {
                this.mRoomId = roomId;
                this.mConfId = confId;
            }

            public void onResponse(@NonNull OpenRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    FeatureLog.i((String)"FTWealth", (String)"open fail, message null, roomId:%s, confId:%s", (Object[])new Object[]{this.mRoomId, this.mConfId});
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"open fail, code:%s, msg:%s, roomId:%s, confId:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code), this.mRoomId, this.mConfId});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"open success, roomId:%s, confId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mConfId, message.record_id});
                }
                if (callback != null) {
                    callback.onSuccess(this.mRoomId, this.mConfId, message.record_id);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"open timeout, roomId:%s, confId:%s", (Object[])new Object[]{this.mRoomId, this.mConfId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"open code:%s, reason:%s", (Object[])new Object[]{code, reason});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void close(final String roomId, final long recordId, final IWealthCommonCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTWealth", (String)"close roomId null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
        }
        CloseReq req = new CloseReq.Builder().record_id(Long.valueOf(recordId)).rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<CloseRes>(){
            String mRoomId;
            long mRecordId;
            {
                this.mRoomId = roomId;
                this.mRecordId = recordId;
            }

            public void onResponse(@NonNull CloseRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"close fail, message null", (Object[])new Object[0]);
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"close fail, code:%s, msg:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code)});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"close success, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                if (callback != null) {
                    callback.onSuccess(this.mRoomId, this.mRecordId);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"close timeout", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"close code:%s, reason:%s", (Object[])new Object[]{code, reason});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void start(final String roomId, final long recordId, final IWealthCommonCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTWealth", (String)"start roomId null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
        }
        StartReq req = new StartReq.Builder().record_id(Long.valueOf(recordId)).rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<StartRes>(){
            String mRoomId;
            long mRecordId;
            {
                this.mRoomId = roomId;
                this.mRecordId = recordId;
            }

            public void onResponse(@NonNull StartRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"start fail, message null", (Object[])new Object[0]);
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"start fail, code:%s, msg:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code)});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"start success, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                if (callback != null) {
                    callback.onSuccess(this.mRoomId, this.mRecordId);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"start timeout, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"start code:%s, reason:%s, roomId:%s, recordId:%s", (Object[])new Object[]{code, reason, this.mRoomId, this.mRecordId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void join(final String roomId, final long recordId, final IWealthCommonCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTWealth", (String)"join roomId null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
        }
        JoinReq req = new JoinReq.Builder().record_id(Long.valueOf(recordId)).rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<JoinRes>(){
            String mRoomId;
            long mRecordId;
            {
                this.mRoomId = roomId;
                this.mRecordId = recordId;
            }

            public void onResponse(@NonNull JoinRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"join fail, message null", (Object[])new Object[0]);
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"join fail, code:%s, msg:%s, roomId:%s, recordId:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code), this.mRoomId, this.mRecordId});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"join success, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                if (callback != null) {
                    callback.onSuccess(this.mRoomId, this.mRecordId);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"join timeout, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"join code:%s, reason:%s, roomId:%s, recordId:%s", (Object[])new Object[]{code, reason, this.mRoomId, this.mRecordId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void cancel(final String roomId, final long recordId, final IWealthCommonCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTWealth", (String)"cancel roomId null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
        }
        CancelReq req = new CancelReq.Builder().record_id(Long.valueOf(recordId)).rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<CancelRes>(){
            String mRoomId;
            long mRecordId;
            {
                this.mRoomId = roomId;
                this.mRecordId = recordId;
            }

            public void onResponse(@NonNull CancelRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"cancel fail, message null, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"cancel fail, code:%s, msg:%s, roomId:%s, recordId:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code), this.mRoomId, this.mRecordId});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"cancel success, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                if (callback != null) {
                    callback.onSuccess(this.mRoomId, this.mRecordId);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"cancel timeout, roomId:%s, recordId:%s", (Object[])new Object[]{this.mRoomId, this.mRecordId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"cancel code:%s, reason:%s, roomId:%s, recordId:%s", (Object[])new Object[]{code, reason, this.mRoomId, this.mRecordId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void getInfo(final String roomId, final IGetInfoCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTWealth", (String)"getInfo roomId null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
        }
        GetInfoReq req = new GetInfoReq.Builder().rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetInfoRes>(){
            String mRoomId;
            {
                this.mRoomId = roomId;
            }

            public void onResponse(@NonNull GetInfoRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"getInfo fail, message null, roomId:%s", (Object[])new Object[]{this.mRoomId});
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"getInfo fail, code:%s, msg:%s, roomId:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code), this.mRoomId});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getInfo success, roomId:%s, recordId:%s, memberList:%s, stateChangedSecs:%s, status:%s, maxDiamond:%s, diamond:%s", (Object[])new Object[]{this.mRoomId, message.record_id, message.members, message.status_changed_time, message.status, message.today_diamond, message.diamond});
                }
                ArrayList<GameResultInfo> memberInfoList = new ArrayList<GameResultInfo>();
                if (message.members != null) {
                    int size = message.members.size();
                    for (int i = 0; i < size; ++i) {
                        MemberResult memberResult = (MemberResult)message.members.get(i);
                        if (memberResult == null) continue;
                        GameResultInfo gameMemberInfo = GameResultInfo.createFromMemberResult(memberResult);
                        memberInfoList.add(gameMemberInfo);
                    }
                }
                if (callback != null) {
                    WealthConfigData wealthConfigData = WealthConfigData.createWealthConfigData(message.diamond, message.conf_id);
                    callback.onSuccess(this.mRoomId, message.record_id, message.status_changed_time, wealthConfigData, memberInfoList, message.getStatusValue(), message.day_max_diamond);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getInfo timeout, roomId:%s", (Object[])new Object[]{this.mRoomId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getInfo code:%s, reason:%s, roomId:%s", (Object[])new Object[]{code, reason, this.mRoomId});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void getHistoryRecord(long uid, String cursor, final int limit, final IGetRecordsCallback callback) {
        if (TextUtils.isEmpty((CharSequence)cursor)) {
            cursor = "";
        }
        final String recordCursor = cursor;
        GetWinRecordsReq req = new GetWinRecordsReq.Builder().uid(Long.valueOf(uid)).cursor(cursor).limit(Integer.valueOf(limit)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetWinRecordsRes>(){
            String mCursor;
            int mLimit;
            {
                this.mCursor = recordCursor;
                this.mLimit = limit;
            }

            public void onResponse(@NonNull GetWinRecordsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"getHistoryRecord fail, message null, cursor:%s, limit:%s", (Object[])new Object[]{this.mCursor, this.mLimit});
                    }
                    if (callback != null) {
                        callback.onFail(-1L, "message null");
                    }
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTWealth", (String)"getHistoryRecord fail, code:%s, msg:%s, cursor:%s, limit:%s", (Object[])new Object[]{code, ProtoErrorCode.getErrorMsg(code), this.mCursor, this.mLimit});
                    }
                    if (callback != null) {
                        callback.onFail(code, msg);
                    }
                    return;
                }
                ArrayList<HistoryRecord> historyRecordList = new ArrayList<HistoryRecord>();
                if (message.records != null) {
                    for (Record record : message.records) {
                        HistoryRecord historyRecord;
                        if (record == null || (historyRecord = HistoryRecord.createFromRecrod(record)) == null) continue;
                        historyRecordList.add(historyRecord);
                    }
                }
                if (callback != null) {
                    FeatureLog.i((String)"FTWealth", (String)"getHistoryRecord success, cursor:%s, limit:%s, list:%s", (Object[])new Object[]{this.mCursor, this.mLimit, historyRecordList});
                    callback.onSuccess(message.cursor, historyRecordList);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getHistoryRecord timeout, cursor:%s, limit:%s", (Object[])new Object[]{this.mCursor, this.mLimit});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTWealth", (String)"getHistoryRecord code:%s, reason:%s, cursor:%s, limit:%s", (Object[])new Object[]{code, reason, this.mCursor, this.mLimit});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static interface IGetRecordsCallback {
        public void onSuccess(String var1, List<HistoryRecord> var2);

        public void onFail(long var1, String var3);
    }

    public static interface IGetInfoCallback {
        public void onSuccess(String var1, long var2, long var4, WealthConfigData var6, List<GameResultInfo> var7, int var8, int var9);

        public void onFail(long var1, String var3);
    }

    public static interface IWealthCommonCallback {
        public void onSuccess(String var1, long var2);

        public void onFail(long var1, String var3);
    }

    public static interface IOpenCallback {
        public void onSuccess(String var1, int var2, long var3);

        public void onFail(long var1, String var3);
    }

    public static interface IGetConfigCallback {
        public void onSuccess(List<WealthConfigData> var1, int var2, int var3);

        public void onFail(long var1, String var3);
    }
}

