/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.bbs.bussiness.post;

import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@DontProguardClass
public class PostPublishUtil {
    public static void saveUseVideoStickerId(int stickerId) {
        MLog.info((Object)"PostPublishUtil", (String)("save: " + stickerId), (Object[])new Object[0]);
        SettingFlags.setIntValue((String)("bbs_use_sticker_video_id_" + AccountUtil.getUid()), (int)stickerId);
    }

    public static void clearUseStickerId() {
        MLog.info((Object)"PostPublishUtil", (String)"clear", (Object[])new Object[0]);
        SettingFlags.setIntValue((String)("bbs_use_sticker_video_id_" + AccountUtil.getUid()), (int)-1);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                FileStorageUtils.getInstance().saveToFile(true, "", "bbs_use_sticker_photo_id_" + AccountUtil.getUid());
            }
        });
    }

    public static void saveUsePhotoStickerId(int stickerId, String path) {
        MLog.info((Object)"PostPublishUtil", (String)("save: " + stickerId + ", path: " + path), (Object[])new Object[0]);
        if (stickerId == -1) {
            return;
        }
        String photoValue = FileStorageUtils.getInstance().getStrFromFile(true, "bbs_use_sticker_photo_id_" + AccountUtil.getUid());
        MLog.info((Object)"PostPublishUtil", (String)("save current photoValue: " + photoValue), (Object[])new Object[0]);
        try {
            final ArrayList<PhotoStickerInfo> finalList = new ArrayList<PhotoStickerInfo>(JsonParser.parseJsonList((String)photoValue, PhotoStickerInfo.class));
            PhotoStickerInfo stickerInfo = new PhotoStickerInfo();
            stickerInfo.path = path;
            stickerInfo.maskId = stickerId;
            stickerInfo.timestamp = System.currentTimeMillis();
            finalList.add(stickerInfo);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileStorageUtils.getInstance().saveToFile(true, JsonParser.toJson((Object)finalList), "bbs_use_sticker_photo_id_" + AccountUtil.getUid());
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)"PostPublishUtil", (String)("save photo sticker info error: " + e.toString()), (Object[])new Object[0]);
        }
    }

    public static int getUseStickerId() {
        int value = SettingFlags.getIntValue((String)("bbs_use_sticker_video_id_" + AccountUtil.getUid()), (int)-1);
        MLog.info((Object)"PostPublishUtil", (String)("get video : " + value), (Object[])new Object[0]);
        if (value != -1) {
            return value;
        }
        String photoValue = FileStorageUtils.getInstance().getStrFromFile(true, "bbs_use_sticker_photo_id_" + AccountUtil.getUid());
        MLog.info((Object)"PostPublishUtil", (String)("get current photoValues: " + photoValue), (Object[])new Object[0]);
        try {
            ArrayList list = new ArrayList(JsonParser.parseJsonList((String)photoValue, PhotoStickerInfo.class));
            if (FP.empty(list)) {
                return -1;
            }
            Collections.sort(list);
            PhotoStickerInfo stickerInfo = (PhotoStickerInfo)list.get(0);
            MLog.info((Object)"PostPublishUtil", (String)("get photo :" + stickerInfo.toString()), (Object[])new Object[0]);
            return stickerInfo.maskId;
        }
        catch (Exception e) {
            MLog.error((Object)"PostPublishUtil", (String)("save photo sticker info error: " + e.toString()), (Object[])new Object[0]);
            return -1;
        }
    }

    public static void deleteUsePhotoStickerId(String path) {
        MLog.info((Object)"PostPublishUtil", (String)("delete photo path: " + path), (Object[])new Object[0]);
        String photoValue = FileStorageUtils.getInstance().getStrFromFile(true, "bbs_use_sticker_photo_id_" + AccountUtil.getUid());
        MLog.info((Object)"PostPublishUtil", (String)("delete current photoValues: " + photoValue), (Object[])new Object[0]);
        try {
            List list = JsonParser.parseJsonList((String)photoValue, PhotoStickerInfo.class);
            if (FP.empty((Collection)list)) {
                return;
            }
            final ArrayList finalList = new ArrayList(list);
            Iterator iterator = finalList.iterator();
            while (iterator.hasNext()) {
                PhotoStickerInfo stickerInfo = (PhotoStickerInfo)iterator.next();
                if (!stickerInfo.path.equals(path)) continue;
                iterator.remove();
                MLog.info((Object)"PostPublishUtil", (String)("delete photo : " + stickerInfo.toString()), (Object[])new Object[0]);
            }
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileStorageUtils.getInstance().saveToFile(true, JsonParser.toJson((Object)finalList), "bbs_use_sticker_photo_id_" + AccountUtil.getUid());
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)"PostPublishUtil", (String)("delete photo sticker info error: " + e.toString()), (Object[])new Object[0]);
        }
    }

    @DontProguardClass
    public static class PhotoStickerInfo
    implements Comparable<PhotoStickerInfo> {
        public String path;
        public int maskId;
        public long timestamp;

        @Override
        public int compareTo(PhotoStickerInfo o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhotoStickerInfo that = (PhotoStickerInfo)o;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return "PhotoStickerInfo{path='" + this.path + '\'' + ", maskId=" + this.maskId + ", timestamp=" + this.timestamp + '}';
        }
    }
}

