/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.bbs.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Message;
import android.os.VibrationEffect;
import android.os.Vibrator;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.bbs.base.R;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u0016\u001a\u00020\u0014J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yy/hiyo/bbs/base/BBSUtils;", "", "()V", "defaultTagIdPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "formatPostLike", "", "likeCnt", "", "(Ljava/lang/Long;)Ljava/lang/String;", "formatPostTime", "timeStamp", "formatVideoTime", "length", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "getPostContentLength", "content", "matchDefaultTagId", "", "tagId", "showGuestWindow", "startVibrator", "", "context", "Landroid/content/Context;", "bbs-base_release"})
public final class BBSUtils {
    private static final Pattern defaultTagIdPattern;
    public static final BBSUtils INSTANCE;

    public final int getPostContentLength(@Nullable String content) {
        return StringUtils.getStringLength((String)content);
    }

    @NotNull
    public final String formatPostLike(@Nullable Long likeCnt) {
        if (likeCnt != null) {
            if (likeCnt >= (long)1000000) {
                long front = likeCnt / (long)1000000;
                long after = likeCnt % (long)1000000 / (long)100000;
                return "" + front + '.' + after + 'm';
            }
            if (likeCnt >= (long)1000) {
                long front = likeCnt / (long)1000;
                long after = likeCnt % (long)1000 / (long)100;
                return "" + front + '.' + after + 'k';
            }
            if (likeCnt >= 0L) {
                return String.valueOf(likeCnt);
            }
        }
        return "0";
    }

    @NotNull
    public final String formatPostTime(@Nullable Long timeStamp) {
        String string2;
        long currentTime = System.currentTimeMillis() / (long)1000;
        if (timeStamp == null || 0L >= timeStamp) {
            String string3 = ResourceUtils.getString((int)R.string.tips_post_time_in_1_minute);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ResourceUtils.getString(\u2026ps_post_time_in_1_minute)");
            return string3;
        }
        long diffTime = currentTime - timeStamp;
        if (diffTime < (long)60) {
            String string4 = ResourceUtils.getString((int)R.string.tips_post_time_in_1_minute);
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ResourceUtils.getString(\u2026ps_post_time_in_1_minute)");
        } else if (diffTime < (long)3600) {
            String string5 = ResourceUtils.getString((int)R.string.tips_post_time_in_1_hour, (Object[])new Object[]{diffTime / (long)60});
            string2 = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"ResourceUtils.getString(\u2026in_1_hour, diffTime / 60)");
        } else if (diffTime < (long)86400) {
            String string6 = ResourceUtils.getString((int)R.string.tips_post_time_in_1_day, (Object[])new Object[]{diffTime / (long)3600});
            string2 = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"ResourceUtils.getString(\u2026n_1_day, diffTime / 3600)");
        } else if (diffTime < (long)2592000) {
            String string7 = ResourceUtils.getString((int)R.string.tips_post_time_in_1_mounth, (Object[])new Object[]{diffTime / (long)86400});
            string2 = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"ResourceUtils.getString(\u2026mounth, diffTime / 86400)");
        } else if (diffTime < (long)31104000) {
            String string8 = ResourceUtils.getString((int)R.string.tips_post_time_in_1_year, (Object[])new Object[]{diffTime / (long)2592000});
            string2 = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"ResourceUtils.getString(\u2026year, diffTime / 2592000)");
        } else {
            String string9 = ResourceUtils.getString((int)R.string.tips_post_time_greater_than_1_year, (Object[])new Object[]{diffTime / (long)31104000});
            string2 = string9;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"ResourceUtils.getString(\u2026ear, diffTime / 31104000)");
        }
        return string2;
    }

    @NotNull
    public final String formatVideoTime(@Nullable Integer length) {
        String string2;
        if (length == null || length < 1) {
            return "";
        }
        int hours = length / 3600;
        int rem = length % 3600;
        int minutes = rem / 60;
        int seconds = rem % 60;
        if (hours <= 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%02d:%02d";
            Object[] objectArray = new Object[]{minutes, seconds};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string5 = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            boolean bl = false;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
        }
        return string2;
    }

    public final boolean showGuestWindow() {
        if (AccountUtil.isLoginByGuest()) {
            Message message = new Message();
            message.what = BaseMsgDef.MSG_BASE_LOGIN_OPEN_WINDOW;
            MsgDispatcher.getInstance().sendMessage(message);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void startVibrator(@Nullable Context context) {
        Vibrator vibrator = SystemServiceUtils.getVibrator((Context)context);
        if (vibrator != null) {
            long duration = 150L;
            if (Build.VERSION.SDK_INT >= 26) {
                vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
            } else {
                vibrator.vibrate(duration);
            }
        }
    }

    public final boolean matchDefaultTagId(@Nullable String tagId) {
        if (FP.empty((CharSequence)tagId)) {
            return false;
        }
        Matcher m = defaultTagIdPattern.matcher(tagId);
        return m.matches();
    }

    private BBSUtils() {
    }

    static {
        BBSUtils bBSUtils;
        INSTANCE = bBSUtils = new BBSUtils();
        defaultTagIdPattern = Pattern.compile("[a-zA-Z][a-zA-Z]_other");
    }
}

