/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.bbs.base;

import androidx.annotation.Nullable;
import com.yy.appbase.data.BbsNoticeDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.bbs.base.R;
import com.yy.hiyo.bbs.base.bean.FollowNoticeUser;
import com.yy.hiyo.bbs.base.bean.FollowUsersList;
import com.yy.hiyo.bbs.base.bean.sectioninfo.BaseSectionInfo;
import com.yy.hiyo.bbs.base.bean.sectioninfo.KtvSectionInfo;
import com.yy.hiyo.bbs.base.bean.sectioninfo.PostImage;
import com.yy.hiyo.bbs.base.bean.sectioninfo.TextSectionInfo;
import com.yy.hiyo.bbs.base.bean.sectioninfo.VideoSectionInfo;
import com.yy.hiyo.videorecord.base.MyVideoSectionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.bbs.srv.entity.PostSecType;
import org.json.JSONException;
import org.json.JSONObject;

public class BBSBaseUtils {
    private static final String TAG = "BBSBaseUtils";

    public static BbsNoticeDBBean from(ImMessageDBBean bean) {
        List<FollowNoticeUser> users;
        if (bean == null) {
            return null;
        }
        BbsNoticeDBBean bbsNoticeDBBean = null;
        if (bean.getContentType() == 16 && !FP.empty(users = BBSBaseUtils.parseFollowNotice(bean))) {
            FollowNoticeUser first = users.remove(0);
            if (first == null) {
                return null;
            }
            bbsNoticeDBBean = new BbsNoticeDBBean();
            bbsNoticeDBBean.setPushSource(bean.getSource());
            bbsNoticeDBBean.setType(1000);
            bbsNoticeDBBean.setAvatar(first.getAvatar());
            bbsNoticeDBBean.setUid(first.getUid());
            bbsNoticeDBBean.setNick(first.getNick());
            bbsNoticeDBBean.setContent(ResourceUtils.getString((int)R.string.title_short_follow_session));
            bbsNoticeDBBean.setSex(first.getSex());
            bbsNoticeDBBean.setAge(first.getAge());
            bbsNoticeDBBean.setCity(first.getCity());
            bbsNoticeDBBean.setTs(first.getTs());
            bbsNoticeDBBean.setPostId(bean.getMsgId() + "");
            if (!FP.empty(users)) {
                bbsNoticeDBBean.setReserveStr(JsonParser.toJson(users));
                int size = users.size();
                bbsNoticeDBBean.setContent(ResourceUtils.getString((int)R.string.title_short_follow_more_session, (Object[])new Object[]{size + 1}));
                size = size > 5 ? 5 : size;
                ArrayList<Long> uids = new ArrayList<Long>(size);
                StringBuilder likeUserUidStr = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    long uid = users.get(i).getUid();
                    uids.add(uid);
                    likeUserUidStr.append(uid).append(",");
                }
                bbsNoticeDBBean.setLikeUserUidList(uids);
                bbsNoticeDBBean.setLikeUserUidStr(likeUserUidStr.toString());
            }
            return bbsNoticeDBBean;
        }
        if (bean.getContentType() == 17) {
            if (StringUtils.isEmpty((String)bean.getContent())) {
                return null;
            }
            bbsNoticeDBBean = new BbsNoticeDBBean();
            try {
                JSONObject postObject = JsonParser.obtainJSONObject((String)bean.getContent());
                bbsNoticeDBBean.setContent(postObject.optString("content", ""));
                bbsNoticeDBBean.setNick(postObject.optString("nick", ""));
                bbsNoticeDBBean.setAvatar(postObject.optString("avatar", ""));
                bbsNoticeDBBean.setTs(System.currentTimeMillis());
                bbsNoticeDBBean.setReaded(false);
                bbsNoticeDBBean.setJumpType(2);
                bbsNoticeDBBean.setJumpUrl(postObject.optString("jump_url"));
                bbsNoticeDBBean.setTitle(postObject.optString("title", ""));
                bbsNoticeDBBean.setUrl(postObject.optString("url", ""));
                bbsNoticeDBBean.setType(postObject.optInt("type", -1));
                bbsNoticeDBBean.setInviteAvatar(postObject.optString("inviteAvatar"));
                bbsNoticeDBBean.setInviteFriendData(postObject.optString("inviteFriendData"));
            }
            catch (JSONException e) {
                MLog.info((Object)"BbsNoticeDBBean", (String)"from %s", (Object[])new Object[]{e.toString()});
            }
            return bbsNoticeDBBean;
        }
        bbsNoticeDBBean = BbsNoticeDBBean.fromJson((String)bean.getContent());
        bbsNoticeDBBean.setPushSource(bean.getSource());
        BaseSectionInfo sectionInfo = null;
        if (bbsNoticeDBBean.getPtype() == PostSecType.POST_SEC_TYPE_TEXT.getValue()) {
            sectionInfo = (BaseSectionInfo)JsonParser.parseJsonTye((String)bbsNoticeDBBean.getPcontent(), TextSectionInfo.class);
            bbsNoticeDBBean.setInfo(((TextSectionInfo)sectionInfo).getMTxt());
            bbsNoticeDBBean.setMentionedIndexList(((TextSectionInfo)sectionInfo).getMMentionedIndexList());
            bbsNoticeDBBean.setMentionedNickList(((TextSectionInfo)sectionInfo).getMMentionedList());
            bbsNoticeDBBean.setMentionedUidList(((TextSectionInfo)sectionInfo).getMMentionedUidList());
        } else if (bbsNoticeDBBean.getPtype() == PostSecType.POST_SEC_TYPE_IMAGES.getValue()) {
            List imageList = null;
            try {
                imageList = JsonParser.parseJsonList((String)bbsNoticeDBBean.getPcontent(), PostImage.class);
            }
            catch (Exception e) {
                MLog.info((Object)"BbsNoticeDBBean", (String)"from %s", (Object[])new Object[]{e});
            }
            if (!FP.empty((Collection)imageList)) {
                PostImage image = (PostImage)imageList.get(0);
                bbsNoticeDBBean.setInfo(image.getMUrl());
            }
        } else if (bbsNoticeDBBean.getPtype() == PostSecType.POST_SEC_TYPE_VEDIO.getValue()) {
            sectionInfo = (BaseSectionInfo)JsonParser.parseJsonTye((String)bbsNoticeDBBean.getPcontent(), VideoSectionInfo.class);
            bbsNoticeDBBean.setInfo(((VideoSectionInfo)sectionInfo).getMSnap());
        } else if (bbsNoticeDBBean.getPtype() == PostSecType.POST_SEC_TYPE_SHARE.getValue()) {
            sectionInfo = (BaseSectionInfo)JsonParser.parseJsonTye((String)bbsNoticeDBBean.getPcontent(), KtvSectionInfo.class);
            bbsNoticeDBBean.setInfo(((KtvSectionInfo)sectionInfo).getMCoverUrl());
        }
        if (!(bbsNoticeDBBean.getAtType() != 1 || bbsNoticeDBBean.getType() != 2 && bbsNoticeDBBean.getType() != 1 || bbsNoticeDBBean.getMentionedUidList() != null && !bbsNoticeDBBean.getMentionedUidList().isEmpty())) {
            bbsNoticeDBBean.setAtType(0);
        }
        return bbsNoticeDBBean;
    }

    @Nullable
    private static List<FollowNoticeUser> parseFollowNotice(ImMessageDBBean bean) {
        if (bean == null || bean.getContentType() != 16) {
            return null;
        }
        String content = bean.getContent();
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        List<FollowNoticeUser> userList = null;
        try {
            FollowUsersList list = (FollowUsersList)JsonParser.parseJsonObject((String)content, FollowUsersList.class);
            if (list != null) {
                userList = list.getUsers();
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return userList;
    }

    public static MyVideoSectionInfo obtain(VideoSectionInfo videoSectionInfo) {
        if (videoSectionInfo == null) {
            return null;
        }
        MyVideoSectionInfo videoInfo = new MyVideoSectionInfo();
        if (videoSectionInfo.getMHeight() != null) {
            videoInfo.mHeight = videoSectionInfo.getMHeight();
        }
        if (videoSectionInfo.getMWidth() != null) {
            videoInfo.mWidth = videoSectionInfo.getMWidth();
        }
        if (videoSectionInfo.getMLength() != null) {
            videoInfo.mLength = videoSectionInfo.getMLength();
        }
        MLog.debug((Object)"MyVideoSectionInfo", (String)("obtain: snapThumbnail:" + videoSectionInfo.getMSnapThumbnail()), (Object[])new Object[0]);
        videoInfo.mSnap = videoSectionInfo.getMSnap();
        videoInfo.mSnapThumbnail = videoSectionInfo.getMSnapThumbnail();
        videoInfo.mUrl = videoSectionInfo.getMUrl();
        videoInfo.setBlurSnap(videoSectionInfo.getMBlurSnap());
        videoInfo.setBlurSnapUrl(videoSectionInfo.getMBlurSnapUrl());
        return videoInfo;
    }
}

