/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.bbs;

import android.content.Context;
import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J \u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/yy/hiyo/bbs/MetricReporter;", "", "tag", "", "key", "(Ljava/lang/String;Ljava/lang/String;)V", "startTime", "", "report", "", "success", "", "errorCode", "statMetric", "useTime", "bbs-base_release"})
public final class MetricReporter {
    private final long startTime;
    private final String tag;
    private final String key;

    public final void report(boolean success, long errorCode) {
        long useTime = SystemClock.uptimeMillis() - this.startTime;
        this.statMetric(useTime, success, errorCode);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void statMetric(long useTime, boolean success, long errorCode) {
        boolean networkAvailable = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        if (!success) {
            if (errorCode >= (long)252) {
                MLog.error((Object)this.tag, (String)"request:%s,server error:%s!", (Object[])new Object[]{this.key, String.valueOf(errorCode)});
            } else if (networkAvailable) {
                MLog.error((Object)this.tag, (String)"request:%s,client error:%s!", (Object[])new Object[]{this.key, String.valueOf(errorCode)});
            } else {
                MLog.error((Object)this.tag, (String)"request:%s,no net error!", (Object[])new Object[]{this.key});
            }
        }
        if (!SettingFlagBaseKeys.isNormalMetricSwitchOn()) return;
        if (!success) {
            ProtoManager protoManager = ProtoManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)protoManager, (String)"ProtoManager.getInstance()");
            if (!protoManager.isWSConnected() || !networkAvailable) {
                HiidoStatis.reportAppMonitorReturnCode((String)this.key, (long)useTime, (String)String.valueOf(250));
                return;
            }
        }
        HiidoStatis.reportAppMonitorReturnCode((String)this.key, (long)useTime, (String)String.valueOf(success ? 0L : errorCode));
    }

    public MetricReporter(@NotNull String tag, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.tag = tag;
        this.key = key;
        this.startTime = SystemClock.uptimeMillis();
    }
}

