/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.audiopk.pk.timer;

import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import biz.UserInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.eventobserver.EventObserver;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.AbsAudioPkPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.AudioPkReportTrack;
import com.yy.hiyo.channel.plugins.audiopk.pk.timer.PkTimerPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.timer.PkTimerView;
import com.yy.hiyo.channel.plugins.audiopk.room.AudioPkContext;
import com.yy.hiyo.channel.plugins.audiopk.widget.theme.AudioPkThemeConfig;
import com.yy.hiyo.pk.base.audio.AudioPkExtData;
import com.yy.hiyo.pk.base.audio.AudioPkModel;
import com.yy.hiyo.pk.base.audio.bean.PkHeartBean;
import com.yy.hiyo.pk.base.audio.bean.PkSeatAlert;
import com.yy.hiyo.pk.base.audio.bean.PkTeam;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.roompk.TeamTheme;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0014J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0007H\u0002J\b\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020\u0007H\u0002J\u0012\u00101\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u000102H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Lcom/yy/hiyo/channel/plugins/audiopk/pk/timer/PkTimerPresenter;", "Lcom/yy/hiyo/channel/plugins/audiopk/pk/AbsAudioPkPresenter;", "Lcom/yy/hiyo/channel/cbase/context/IHolderPresenter;", "()V", "mCheckStateRunnable", "Ljava/lang/Runnable;", "mPkEndTime", "", "mTimerRunnable", "mView", "Lcom/yy/hiyo/channel/plugins/audiopk/pk/timer/PkTimerView;", "mViewEnable", "Landroidx/lifecycle/MutableLiveData;", "", "getMViewEnable", "()Landroidx/lifecycle/MutableLiveData;", "mViewEnable$delegate", "Lkotlin/Lazy;", "cancelCheckStateTask", "", "checkReportMatchResult", "handleHeartBean", "it", "Lcom/yy/hiyo/pk/base/audio/bean/PkHeartBean;", "onDestroy", "onPkShowResult", "pkId", "", "onPkStart", "onPking", "onStateChanged", "oldState", "", "currentState", "registerDataObserve", "reportMatchState", "matchState", "otherUid", "setContainer", "container", "Landroid/view/View;", "setTimerRealVisible", "visible", "setTimerVisible", "startCheckStateTask", "delay", "startPkTimer", "stopPkTimer", "updateTimerView", "updateViewAlpha", "Lcom/yy/hiyo/pk/base/audio/bean/PkSeatAlert;", "audiopk_release"})
public class PkTimerPresenter
extends AbsAudioPkPresenter
implements IHolderPresenter {
    private final Lazy mViewEnable$delegate = LazyKt.lazy((Function0)mViewEnable.2.INSTANCE);
    private PkTimerView mView;
    private Runnable mTimerRunnable;
    private Runnable mCheckStateRunnable;
    private long mPkEndTime;

    private final MutableLiveData<Boolean> getMViewEnable() {
        Lazy lazy = this.mViewEnable$delegate;
        PkTimerPresenter pkTimerPresenter = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MutableLiveData)lazy.getValue();
    }

    public void setContainer(@NotNull View container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        if (!(container instanceof YYPlaceHolderView)) {
            return;
        }
        FragmentActivity fragmentActivity = ((AudioPkContext)this.getMvpContext()).getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"mvpContext.context");
        this.mView = new PkTimerView((Context)fragmentActivity, null, 0, 6, null);
        YYPlaceHolderView yYPlaceHolderView = (YYPlaceHolderView)container;
        PkTimerView pkTimerView = this.mView;
        if (pkTimerView == null) {
            Intrinsics.throwNpe();
        }
        yYPlaceHolderView.inflate((View)pkTimerView);
        this.setTimerVisible(false);
        PkTimerView pkTimerView2 = this.mView;
        if (pkTimerView2 == null) {
            Intrinsics.throwNpe();
        }
        PkTeam pkTeam = ((AudioPkContext)this.getMvpContext()).getPkData().getOwnTeam();
        pkTimerView2.setPkTheme(AudioPkThemeConfig.INSTANCE.getOwnerTurnOverResThemeBuilder(AudioPkThemeConfig.INSTANCE.getKEY_TIMER_BG(), pkTeam != null ? pkTeam.getTheme() : TeamTheme.TEAM_THEME_NONE.getValue()));
        this.getMViewEnable().observe((LifecycleOwner)this.getMvpContext(), (Observer)new Observer<Boolean>(this){
            final /* synthetic */ PkTimerPresenter this$0;

            public final void onChanged(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                if (bl.booleanValue()) {
                    PkTimerPresenter.access$updateViewAlpha(this.this$0, this.this$0.getPkData().getPkSeatAlert());
                    if (this.this$0.getPkData().getPkState() == 100) {
                        PkTimerPresenter.access$setTimerRealVisible(this.this$0, true);
                    } else {
                        PkTimerPresenter.access$setTimerRealVisible(this.this$0, false);
                    }
                }
            }
            {
                this.this$0 = pkTimerPresenter;
            }
        });
        this.registerDataObserve();
    }

    protected void registerDataObserve() {
        block1: {
            AudioPkExtData audioPkExtData;
            AudioPkExtData audioPkExtData2 = this.getPkExtData();
            if (audioPkExtData2 != null && (audioPkExtData2 = audioPkExtData2.getStateLeftSecondsData()) != null) {
                audioPkExtData2.observe((LifecycleOwner)this.getMvpContext(), (Observer)new EventObserver((Function1)new Function1<PkHeartBean, Unit>(this){
                    final /* synthetic */ PkTimerPresenter this$0;

                    public final void invoke(@NotNull PkHeartBean it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.this$0.handleHeartBean(it);
                    }
                    {
                        this.this$0 = pkTimerPresenter;
                        super(1);
                    }
                }));
            }
            if ((audioPkExtData = this.getPkExtData()) == null || (audioPkExtData = audioPkExtData.getPkSeatAlertData()) == null) break block1;
            audioPkExtData.observe((LifecycleOwner)this.getMvpContext(), (Observer)new Observer<PkSeatAlert>(this){
                final /* synthetic */ PkTimerPresenter this$0;

                public final void onChanged(PkSeatAlert it) {
                    if (this.this$0.isDestroyed()) {
                        return;
                    }
                    PkTimerPresenter.access$updateViewAlpha(this.this$0, it);
                }
                {
                    this.this$0 = pkTimerPresenter;
                }
            });
        }
    }

    protected void handleHeartBean(@NotNull PkHeartBean it) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        MLog.debug((Object)"FTAPk_PkTimerPresenter", (String)("state:" + it.getState() + ",surplusTime: " + it.getStateSeconds()), (Object[])new Object[0]);
        if (it.getState() == 100) {
            this.mPkEndTime = SystemClock.elapsedRealtime() + it.getStateSeconds() * (long)1000;
        }
        if (it.getState() == 99 || it.getState() == 100 || it.getState() == 300 || it.getState() == 301) {
            this.startCheckStateTask((it.getStateSeconds() + (long)2) * (long)1000);
        }
    }

    private final void updateViewAlpha(PkSeatAlert it) {
        block1: {
            block0: {
                PkSeatAlert pkSeatAlert = it;
                if (CommonExtensionsKt.orZero((Long)(pkSeatAlert != null ? Long.valueOf(pkSeatAlert.getPercent()) : null)) <= 0L) break block0;
                PkSeatAlert pkSeatAlert2 = it;
                if (CommonExtensionsKt.orZero((Long)(pkSeatAlert2 != null ? Long.valueOf(pkSeatAlert2.getSeconds()) : null)) <= 0L) break block0;
                PkTimerView pkTimerView = this.mView;
                if (pkTimerView == null) break block1;
                pkTimerView.setAlpha(0.5f);
                break block1;
            }
            PkTimerView pkTimerView = this.mView;
            if (pkTimerView == null) break block1;
            pkTimerView.setAlpha(1.0f);
        }
    }

    @Override
    public void onStateChanged(@NotNull String pkId, int oldState, int currentState) {
        Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
        if (currentState == 100) {
            this.setTimerVisible(true);
        } else {
            this.setTimerVisible(false);
        }
    }

    @Override
    public void onPkStart(@NotNull String pkId) {
        Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
        this.setTimerVisible(false);
        this.checkReportMatchResult();
    }

    @Override
    public void onPking(@NotNull String pkId) {
        Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
        this.setTimerVisible(true);
    }

    @Override
    public void onPkShowResult(@NotNull String pkId) {
        Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
        MLog.info((Object)"FTAPk_PkTimerPresenter", (String)("Timer dismiss: onPkShowResult:" + this.mPkEndTime), (Object[])new Object[0]);
        this.setTimerVisible(false);
    }

    private final void setTimerVisible(boolean visible) {
        if (this.mView != null) {
            this.setTimerRealVisible(visible);
        } else {
            this.getMViewEnable().setValue((Object)true);
        }
    }

    private final void setTimerRealVisible(boolean visible) {
        if (this.isDestroyed()) {
            return;
        }
        if (visible) {
            PkTimerView pkTimerView = this.mView;
            if (pkTimerView != null) {
                pkTimerView.setVisibility(0);
            }
            long surplusTimeLength = this.getPkData().getStateLeftSeconds();
            this.mPkEndTime = SystemClock.elapsedRealtime() + surplusTimeLength * (long)1000;
            if (surplusTimeLength > 0L) {
                this.startPkTimer();
            }
        } else {
            PkTimerView pkTimerView = this.mView;
            if (pkTimerView != null) {
                pkTimerView.setVisibility(8);
            }
            this.stopPkTimer();
        }
    }

    private final long updateTimerView() {
        long surplus = (this.mPkEndTime - SystemClock.elapsedRealtime()) / (long)1000;
        if (surplus > 0L) {
            PkTimerView pkTimerView = this.mView;
            if (pkTimerView != null) {
                PkTimerView pkTimerView2 = pkTimerView;
                boolean bl = false;
                boolean bl2 = false;
                PkTimerView it = pkTimerView2;
                boolean bl3 = false;
                it.updateTimeText(surplus);
                if (it.getVisibility() != 0) {
                    it.setVisibility(0);
                }
            }
        } else {
            PkTimerView pkTimerView = this.mView;
            if (pkTimerView != null) {
                pkTimerView.setVisibility(8);
            }
            MLog.info((Object)"FTAPk_PkTimerPresenter", (String)"timer end!", (Object[])new Object[0]);
        }
        return surplus;
    }

    private final void startPkTimer() {
        if (this.isDestroyed()) {
            return;
        }
        if (this.mTimerRunnable == null) {
            this.mTimerRunnable = new Runnable(this){
                final /* synthetic */ PkTimerPresenter this$0;

                public final void run() {
                    if (this.this$0.isDestroyed()) {
                        return;
                    }
                    long surplus = PkTimerPresenter.access$updateTimerView(this.this$0);
                    if (surplus > 0L) {
                        YYTaskExecutor.postToMainThread((Runnable)PkTimerPresenter.access$getMTimerRunnable$p(this.this$0), (long)999L);
                    }
                }
                {
                    this.this$0 = pkTimerPresenter;
                }
            };
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mTimerRunnable);
        }
        this.updateTimerView();
        YYTaskExecutor.postToMainThread((Runnable)this.mTimerRunnable, (long)999L);
    }

    private final void stopPkTimer() {
        Runnable runnable = this.mTimerRunnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            YYTaskExecutor.removeTask((Runnable)it);
        }
        this.mTimerRunnable = null;
    }

    private final void startCheckStateTask(long delay) {
        if (this.isDestroyed()) {
            return;
        }
        this.cancelCheckStateTask();
        if (this.mCheckStateRunnable == null) {
            this.mCheckStateRunnable = new Runnable(this){
                final /* synthetic */ PkTimerPresenter this$0;

                public final void run() {
                    if (this.this$0.isDestroyed() || this.this$0.getPkData().getPkState() == 500) {
                        MLog.info((Object)"FTAPk_PkTimerPresenter", (String)("change state time out, isDestroyed:" + this.this$0.isDestroyed()), (Object[])new Object[0]);
                        return;
                    }
                    MLog.info((Object)"FTAPk_PkTimerPresenter", (String)("change state time out, state:" + this.this$0.getPkData().getPkState() + ", req"), (Object[])new Object[0]);
                    AudioPkModel.DefaultImpls.reqPkStatus$default((AudioPkModel)((AudioPkContext)this.this$0.getMvpContext()).getPkDataModel(), (String)this.this$0.getChannelId(), null, (int)2, null);
                }
                {
                    this.this$0 = pkTimerPresenter;
                }
            };
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mCheckStateRunnable, (long)delay);
    }

    private final void cancelCheckStateTask() {
        block0: {
            Runnable runnable = this.mCheckStateRunnable;
            if (runnable == null) break block0;
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            MLog.debug((Object)"FTAPk_PkTimerPresenter", (String)"cancel req state", (Object[])new Object[0]);
            YYTaskExecutor.removeTask((Runnable)it);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopPkTimer();
        this.cancelCheckStateTask();
        this.mCheckStateRunnable = null;
    }

    private final void checkReportMatchResult() {
        if (AudioPkReportTrack.INSTANCE.getSCacheMatchStartTime() > 0L && Intrinsics.areEqual((Object)this.getChannelId(), (Object)AudioPkReportTrack.INSTANCE.getSCacheMatchCid())) {
            Object object = this.getPkData().getOtherTeam();
            this.reportMatchState("1", object != null && (object = object.getOwner()) != null && (object = ((UserInfo)object).uid) != null ? ((Long)object).longValue() : this.getChannel().getOwnerUid());
        }
        AudioPkReportTrack.INSTANCE.setSCacheMatchStartTime(0L);
        AudioPkReportTrack.INSTANCE.setSCacheMatchCid("");
    }

    private final void reportMatchState(String matchState, long otherUid) {
        long matchTime = (SystemClock.elapsedRealtime() - AudioPkReportTrack.INSTANCE.getSCacheMatchStartTime()) / (long)1000;
        if (matchTime > 0L) {
            AudioPkReportTrack.INSTANCE.waitingPkMatch(this.getChannelId(), matchTime, matchState, AccountUtil.getUid(), otherUid);
        }
    }

    public static final /* synthetic */ void access$updateViewAlpha(PkTimerPresenter $this, PkSeatAlert it) {
        $this.updateViewAlpha(it);
    }

    public static final /* synthetic */ void access$setTimerRealVisible(PkTimerPresenter $this, boolean visible) {
        $this.setTimerRealVisible(visible);
    }

    public static final /* synthetic */ long access$updateTimerView(PkTimerPresenter $this) {
        return $this.updateTimerView();
    }

    public static final /* synthetic */ Runnable access$getMTimerRunnable$p(PkTimerPresenter $this) {
        return $this.mTimerRunnable;
    }

    public static final /* synthetic */ void access$setMTimerRunnable$p(PkTimerPresenter $this, Runnable runnable) {
        $this.mTimerRunnable = runnable;
    }
}

