/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.apm;

import android.content.Context;
import android.view.ViewGroup;
import com.duowan.sword.Sword;
import com.duowan.sword.plugin.Consumer;
import com.duowan.sword.plugin.Issue;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.sword.SwordHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.VersionUtil;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;

@DontProguardClass
public class SwordBridge {
    private static final String TAG = "SwordBridge";
    private static final ArrayList<String> NON_SINGLE_PAGE_WINDOW_LST = new ArrayList();

    public static void install() {
        try {
            SwordHelper.install();
            Sword.INSTANCE.subscribeIssue((Consumer)new Consumer<Issue>(){

                public void accept(Issue issue) {
                    if (!RuntimeContext.sPackageName.equals("com.yy.hiyo")) {
                        return;
                    }
                    HiidoStatis.reportContent((StatisContent)Sword.INSTANCE.getStat(issue));
                }
            });
            Sword.INSTANCE.setFileUploader((file, uploadCallback) -> ServiceManagerProxy.getService(IOOSService.class).uploadFile(file.getName(), file.getAbsolutePath(), new IUploadObjectCallBack(){

                @Override
                public void onSuccess(UploadObjectRequest request) {
                    MLog.debug((Object)SwordBridge.TAG, (String)"upload success, key = %s, url = %s", (Object[])new Object[]{request.getObjectKey(), request.mUrl});
                    uploadCallback.onSuccess(request.mUrl);
                }

                @Override
                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    uploadCallback.onFail("upload failed, code: " + errorCode);
                }
            }));
            if (RuntimeContext.isLocalBuild()) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext);
                            if (ver != null) {
                                ServiceManagerProxy.getServiceManager().observeService(IAppService.class, service2 -> Sword.INSTANCE.setDevInfo(service2.getBranchName(), ver.toString()));
                            }
                        }
                        catch (Throwable e) {
                            MLog.error((Object)SwordBridge.TAG, (String)"sword get ver error", (Throwable)e, (Object[])new Object[0]);
                        }
                    }
                }, (long)5000L);
            }
            SwordBridge.startViewCanary();
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)"sword init error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static void startViewCanary() {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)new DefaultWindow.IGlobalWindowMonitor(){

            public void onWindowCreate(DefaultWindow window) {
                MLog.debug((Object)SwordBridge.TAG, (String)"[%s]onWindowCreate", (Object[])new Object[]{window.getWindowName()});
            }

            public void onDetach(DefaultWindow window) {
                MLog.debug((Object)SwordBridge.TAG, (String)"[%s]onDetach", (Object[])new Object[]{window.getWindowName()});
                SwordHelper.detachViewLevelAndOverDraw((ViewGroup)window);
            }

            public void onShown(DefaultWindow window) {
                MLog.debug((Object)SwordBridge.TAG, (String)"[%s] onShown ", (Object[])new Object[]{window.getWindowName()});
                if (NON_SINGLE_PAGE_WINDOW_LST.contains(window.getWindowName())) {
                    return;
                }
                SwordHelper.checkViewLevelAndOverDraw((ViewGroup)window, (String)window.getWindowName());
            }

            public void onHidden(DefaultWindow window) {
                MLog.debug((Object)SwordBridge.TAG, (String)"[%s] onHidden", (Object[])new Object[]{window.getWindowName()});
            }
        });
    }

    static {
        NON_SINGLE_PAGE_WINDOW_LST.add("Splash");
        NON_SINGLE_PAGE_WINDOW_LST.add("HomePageNew");
    }
}

