/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.widget.barrage;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.widget.barrage.Barrage;
import com.yy.appbase.widget.barrage.BarrageItem;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;

public class BarrageShowView
extends YYFrameLayout {
    protected List<BarrageItem> barrageRunningList = new ArrayList<BarrageItem>();
    protected List<BarrageItem> barrageWaittingList = new ArrayList<BarrageItem>();
    protected List<BarrageItem> barragePausingList = new ArrayList<BarrageItem>();
    protected float speed = 0.3f;
    protected int barragePathSpacing = ResolutionUtils.dip2Px((float)10.0f);
    protected int barrageItemHeight = ResolutionUtils.dip2Px((float)25.0f);
    private Queue<BarrageItem> itemCachePool = new LinkedList<BarrageItem>();
    private int barragePathCount = 2;
    private List<BarragePath> barragePathList = new ArrayList<BarragePath>();
    private BarrageHandler barrageHandler = new BarrageHandler();
    private boolean isPausing = false;
    private Random random;

    public BarrageShowView(Context context) {
        this(context, null);
        this.initParams();
    }

    public BarrageShowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.initParams();
    }

    public BarrageShowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initParams();
    }

    public void initBarrageView(int pathCount) {
        if (pathCount > 0) {
            this.barragePathCount = pathCount;
        }
        long currentMillis = System.currentTimeMillis();
        this.barragePathList.clear();
        for (int i = 0; i < this.barragePathCount; ++i) {
            BarragePath barragePath = new BarragePath();
            barragePath.freeTimeMillis = currentMillis;
            barragePath.locationTop = (this.barrageItemHeight + this.barragePathSpacing) * i;
            this.barragePathList.add(barragePath);
        }
        this.setMinimumHeight(this.barrageItemHeight * this.barragePathCount + this.barragePathSpacing * (this.barragePathCount - 1));
    }

    protected void initParams() {
    }

    public void clear() {
        this.barrageHandler.removeCallbacksAndMessages(null);
    }

    public void start() {
        for (BarrageItem barrageItem : this.barragePausingList) {
            BarragePath barragePath;
            if (barrageItem.barragePath == null) continue;
            barrageItem.barragePath = barragePath = this.findPath();
            this.ensureShowDelay(barrageItem);
            this.barrageWaittingList.add(barrageItem);
        }
        this.barragePausingList.clear();
        this.isPausing = false;
    }

    public void pause() {
        this.barrageHandler.removeCallbacksAndMessages(null);
        this.barragePausingList.clear();
        for (BarrageItem barrageItem : this.barrageWaittingList) {
            if (barrageItem.barragePath != null) {
                barrageItem.barragePath.freeTimeMillis -= barrageItem.duration;
            }
            this.barragePausingList.add(barrageItem);
        }
        this.barrageWaittingList.clear();
        this.isPausing = true;
    }

    public void addBarrage(Barrage barrage) {
        if (barrage == null) {
            return;
        }
        BarrageItem item = this.obtainBarrageItem(barrage);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        item.view.setLayoutParams((ViewGroup.LayoutParams)lp);
        int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        item.view.measure(measureSpec, measureSpec);
        item.width = item.view.getMeasuredWidth();
        item.height = item.view.getMeasuredHeight();
        if (this.isPausing) {
            this.barragePausingList.add(item);
        } else {
            BarragePath barragePath;
            item.barragePath = barragePath = this.findPath();
            this.ensureShowDelay(item);
            this.barrageWaittingList.add(item);
        }
    }

    protected BarragePath findPath() {
        BarragePath barragePath = this.barragePathList.get(this.randomBarragePath());
        return barragePath;
    }

    protected BarragePath getBarragePath(int index) {
        if (index < 0) {
            index = 0;
        } else if (index >= this.barragePathCount) {
            index = this.barragePathCount - 1;
        }
        return this.barragePathList.get(index);
    }

    private void ensureShowDelay(BarrageItem item) {
        if (item == null) {
            return;
        }
        BarragePath barragePath = item.barragePath;
        long currentMillis = System.currentTimeMillis();
        long waittingTime = 0L;
        if (currentMillis < barragePath.freeTimeMillis) {
            waittingTime = item.barragePath.freeTimeMillis - currentMillis;
        }
        long fullDisplayDuration = (long)((float)item.width / this.speed) + 150L;
        barragePath.freeTimeMillis = currentMillis + waittingTime + fullDisplayDuration;
        item.duration = fullDisplayDuration;
        Message message = Message.obtain();
        message.obj = item;
        this.barrageHandler.sendMessageDelayed(message, waittingTime);
    }

    private BarrageItem obtainBarrageItem(Barrage barrage) {
        BarrageItem barrageItem = this.itemCachePool.poll();
        if (barrageItem == null) {
            barrageItem = this.createBarrageItem();
        }
        this.bindBarrageItem(barrageItem, barrage);
        return barrageItem;
    }

    protected BarrageItem createBarrageItem() {
        YYRelativeLayout container = new YYRelativeLayout(this.getContext());
        YYTextView tvMsg = new YYTextView(this.getContext());
        GradientDrawable msgBg = new GradientDrawable();
        msgBg.setShape(0);
        msgBg.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        if (Build.VERSION.SDK_INT >= 16) {
            tvMsg.setBackground((Drawable)msgBg);
        } else {
            tvMsg.setBackgroundDrawable((Drawable)msgBg);
        }
        tvMsg.setGravity(16);
        tvMsg.setTextSize(12.0f);
        tvMsg.setTextColor(-1);
        tvMsg.getPaint().setFakeBoldText(true);
        int startPadding = ResolutionUtils.dip2Px((float)17.0f);
        int endPadding = ResolutionUtils.dip2Px((float)10.0f);
        if (LanguageUtils.isLtr()) {
            tvMsg.setPadding(startPadding, 0, endPadding, 0);
        } else {
            tvMsg.setPadding(endPadding, 0, startPadding, 0);
        }
        RelativeLayout.LayoutParams msgLp = new RelativeLayout.LayoutParams(-2, this.barrageItemHeight);
        int startMargin = ResolutionUtils.dip2Px((float)13.0f);
        if (LanguageUtils.isLtr()) {
            msgLp.setMargins(startMargin, 0, 0, 0);
        } else {
            msgLp.setMargins(0, 0, startMargin, 0);
        }
        container.addView((View)tvMsg, (ViewGroup.LayoutParams)msgLp);
        CircleImageView ivAvatar = new CircleImageView(this.getContext());
        ivAvatar.setBorderColor(-1);
        ivAvatar.setBorderWidth(ResolutionUtils.dip2Px((float)1.5f));
        container.addView((View)ivAvatar, this.barrageItemHeight, this.barrageItemHeight);
        BarrageItem barrageItem = new BarrageItem();
        barrageItem.view = container;
        barrageItem.ivAvatar = ivAvatar;
        barrageItem.tvMsg = tvMsg;
        return barrageItem;
    }

    protected void bindBarrageItem(BarrageItem barrageItem, Barrage barrage) {
        if (!TextUtils.isEmpty((CharSequence)barrage.getAvatar())) {
            String thumbUrl = barrage.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75);
            ImageLoader.loadImage((ImageView)barrageItem.ivAvatar, (String)thumbUrl);
        }
        barrageItem.tvMsg.setText((CharSequence)barrage.getMsg());
        Drawable drawable2 = barrageItem.tvMsg.getBackground();
        if (drawable2 instanceof GradientDrawable) {
            GradientDrawable gd = (GradientDrawable)drawable2;
            gd.setColor(barrage.getBgColor());
        }
    }

    private void removeBarrageItem(BarrageItem item) {
        if (item == null) {
            return;
        }
        if (item.anim != null) {
            item.anim.cancel();
            item.anim = null;
        }
        item.view.setVisibility(4);
        this.removeView(item.view);
        this.barrageRunningList.remove(item);
        this.itemCachePool.offer(item);
    }

    private Animation createAnim(BarrageItem barrageItem) {
        int distance = this.getWidth() + barrageItem.width;
        BarrageAnimation anim2 = LanguageUtils.isLtr() ? new BarrageAnimation(barrageItem, 0.0f, -distance) : new BarrageAnimation(barrageItem, 0.0f, distance);
        int duration = (int)((float)distance / this.speed);
        anim2.setDuration(duration);
        anim2.setInterpolator((Interpolator)new LinearInterpolator());
        anim2.setFillAfter(false);
        return anim2;
    }

    private int randomBarragePath() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random.nextInt(this.barragePathCount);
    }

    public class BarrageHandler
    extends Handler {
        BarrageHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            Animation barrageAnim;
            if (!(msg.obj instanceof BarrageItem)) {
                return;
            }
            BarrageItem barrageItem = (BarrageItem)msg.obj;
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
            if (LanguageUtils.isLtr()) {
                lp.gravity = 53;
                lp.rightMargin = -barrageItem.width;
            } else {
                lp.gravity = 51;
                lp.leftMargin = -barrageItem.width;
            }
            lp.topMargin = barrageItem.barragePath.locationTop;
            barrageItem.view.setVisibility(0);
            BarrageShowView.this.addView(barrageItem.view, (ViewGroup.LayoutParams)lp);
            barrageItem.anim = barrageAnim = BarrageShowView.this.createAnim(barrageItem);
            barrageItem.view.startAnimation(barrageAnim);
            BarrageShowView.this.barrageWaittingList.remove(barrageItem);
            BarrageShowView.this.barrageRunningList.add(barrageItem);
        }
    }

    public class BarragePath {
        public long freeTimeMillis;
        public int locationTop;
    }

    public class BarrageAnimation
    extends TranslateAnimation {
        private BarrageItem barrageItem;

        BarrageAnimation(BarrageItem item, float fromXDelta, float toXDelta) {
            super(fromXDelta, toXDelta, 0.0f, 0.0f);
            this.barrageItem = item;
            this.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BarrageShowView.this.removeBarrageItem(BarrageAnimation.this.barrageItem);
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
    }
}

