/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.widget.TextView;
import androidx.annotation.RequiresApi;

public class TextViewUtil {
    public static StaticLayout getSameStaticLayout(TextView textView, int textViewWidth, String text) {
        int width = textViewWidth - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight();
        StaticLayout staticLayout = Build.VERSION.SDK_INT >= 23 ? TextViewUtil.getStaticLayout23(textView, text, width) : TextViewUtil.getStaticLayout(textView, text, width);
        return staticLayout;
    }

    @RequiresApi(api=23)
    private static StaticLayout getStaticLayout23(TextView textView, String text, int width) {
        StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textView.getPaint(), (int)width).setAlignment(Layout.Alignment.ALIGN_NORMAL).setTextDirection(TextDirectionHeuristics.FIRSTSTRONG_LTR).setLineSpacing(textView.getLineSpacingExtra(), textView.getLineSpacingMultiplier()).setIncludePad(textView.getIncludeFontPadding()).setBreakStrategy(textView.getBreakStrategy()).setHyphenationFrequency(textView.getHyphenationFrequency()).setMaxLines(textView.getMaxLines() == -1 ? Integer.MAX_VALUE : textView.getMaxLines());
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setJustificationMode(textView.getJustificationMode());
        }
        if (textView.getEllipsize() != null && textView.getKeyListener() == null) {
            builder.setEllipsize(textView.getEllipsize()).setEllipsizedWidth(width);
        }
        return builder.build();
    }

    private static StaticLayout getStaticLayout(TextView textView, String text, int width) {
        return new StaticLayout((CharSequence)text, 0, text.length(), textView.getPaint(), width, Layout.Alignment.ALIGN_NORMAL, textView.getLineSpacingMultiplier(), textView.getLineSpacingExtra(), textView.getIncludeFontPadding(), textView.getEllipsize(), width);
    }

    public static int getCollapseTextLength(String data2, TextView textView, int width, int collapseLine, String extra) {
        String workingText = data2;
        StaticLayout layout2 = TextViewUtil.getSameStaticLayout(textView, width, data2);
        if (layout2.getLineCount() >= collapseLine) {
            int lineEnd = layout2.getLineEnd(collapseLine - 1);
            if (lineEnd > data2.length()) {
                lineEnd = data2.length() - 1;
            }
            if (lineEnd <= 0) {
                return 0;
            }
            workingText = data2.substring(0, lineEnd);
            while (TextViewUtil.getSameStaticLayout(textView, width, workingText + extra).getLineCount() > collapseLine) {
                int endIndex = workingText.length() - 1;
                if (endIndex <= 0) {
                    return 0;
                }
                workingText = workingText.substring(0, endIndex);
            }
        }
        return workingText.length();
    }
}

