/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.VoiceRoomTagConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class VoiceRoomTagConfig
extends AConfigData {
    private static final String TAG = "VoiceRoomTagConfig";
    private LinkedHashMap<String, VoiceRoomTagConfigData> mTagsMap = new LinkedHashMap();
    public static final String LOCAL_SING_TAG_ID = "1005";
    private String mSingTagId = "1005";
    private String locatConfig = "{\"tags\":[{\"tagname\":\"Chat\",\"tagId\":\"1001\",\"tagcolor\":\"#2889e3\",\"tagicon\":\"https://o-id.ihago.net/ikxd/eee988faef25d710e8a31b36f3487a5f/chatroomIcon.png\",\"roomnamelist\":[\"Chat at night\",\"Talk about your first love\",\"Emotional hollow\",\"Tell your secret\",\"Travel experience\",\"Chat movie\",\"Ghost story\",\"Chat in the same city\"]},{\"tagname\":\"Games\",\"tagId\":\"1002\",\"tagcolor\":\"#f3ab2d\",\"tagicon\":\"https://o-id.ihago.net/ikxd/534bafaf4fb1333d9e627a69a97e17f6/gameIcon.png\",\"roomnamelist\":[\"Talk while playing\",\"The game is coming\",\"Who dares to challenge me?\"]},{\"tagname\":\"Make Friends\",\"tagId\":\"1003\",\"tagcolor\":\"#a955ff\",\"tagicon\":\"https://o-id.ihago.net/ikxd/1e824dd1a2eda62757d2672c9d4822d2/makeFriendIcon.png\",\"roomnamelist\":[\"Friends themed Party\",\"Let's introduce ourselves\",\"Nice to meet you\"]},{\"tagname\":\"Date\",\"tagId\":\"1004\",\"tagcolor\":\"#ff6196\",\"tagicon\":\"https://o-id.ihago.net/ikxd/08dc7485df6ba42659e78f9b13703e5d/dateIcon.png\",\"roomnamelist\":[\"Discover soul mate\",\"Let's date together\",\"Lonely soul gathering\"]}]}";

    @Override
    public BssCode getBssCode() {
        return BssCode.VOICE_ROOM_TAGS;
    }

    @Override
    public void parseConfig(String configs) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"configs %s", (Object[])new Object[]{configs});
        }
        if (StringUtils.isEmpty((String)configs)) {
            configs = this.locatConfig;
        }
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)configs);
            this.mTagsMap.clear();
            if (jo.has("tags")) {
                JSONArray tagList = jo.getJSONArray("tags");
                JSONObject tagItem = null;
                for (int i = 0; i < tagList.length(); ++i) {
                    tagItem = tagList.optJSONObject(i);
                    if (null == tagItem) continue;
                    this.parseItem(tagItem);
                }
            }
            if (jo.has("singtagid")) {
                this.mSingTagId = jo.getString("singtagid");
            }
        }
        catch (Throwable e) {
            MLog.info((Object)"VoiceRoomTagConfigData", (String)"parseConfig %s", (Object[])new Object[]{configs});
        }
    }

    private void parseItem(JSONObject data2) {
        if (null == data2) {
            return;
        }
        try {
            VoiceRoomTagConfigData item = (VoiceRoomTagConfigData)JsonParser.parseJsonObject((String)data2.toString(), VoiceRoomTagConfigData.class);
            this.mTagsMap.put(item.getTagId(), item);
        }
        catch (Throwable e) {
            MLog.error((Object)"VoiceRoomTagConfigData", (Throwable)e);
            MLog.info((Object)"VoiceRoomTagConfigData", (String)"parseItem value %s", (Object[])new Object[]{data2});
        }
    }

    public LinkedHashMap<String, VoiceRoomTagConfigData> getmTagsMap() {
        return this.mTagsMap;
    }

    @Nullable
    public VoiceRoomTagConfigData getTagConfig(String tagId) {
        if (TextUtils.isEmpty((CharSequence)tagId)) {
            return null;
        }
        return this.mTagsMap.get(tagId);
    }

    public LinkedHashMap<String, VoiceRoomTagConfigData> getLocalTagsMap() {
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)this.locatConfig);
            this.mTagsMap.clear();
            JSONArray tagList = jo.getJSONArray("tags");
            JSONObject tagItem = null;
            for (int i = 0; i < tagList.length(); ++i) {
                tagItem = tagList.optJSONObject(i);
                if (null == tagItem) continue;
                this.parseItem(tagItem);
            }
        }
        catch (Throwable e) {
            MLog.info((Object)"VoiceRoomTagConfigData", (String)"parseLocalConfig %s", (Object[])new Object[]{this.locatConfig});
        }
        return this.mTagsMap;
    }

    public void getLocalTagsMap(final TagCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jo = JsonParser.obtainJSONObject((String)VoiceRoomTagConfig.this.locatConfig);
                    VoiceRoomTagConfig.this.mTagsMap.clear();
                    JSONArray tagList = jo.getJSONArray("tags");
                    JSONObject tagItem = null;
                    for (int i = 0; i < tagList.length(); ++i) {
                        tagItem = tagList.optJSONObject(i);
                        if (null == tagItem) continue;
                        VoiceRoomTagConfig.this.parseItem(tagItem);
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onResult(VoiceRoomTagConfig.this.mTagsMap);
                        }
                    });
                }
                catch (Throwable e) {
                    MLog.info((Object)"VoiceRoomTagConfigData", (String)"parseLocalConfig %s", (Object[])new Object[]{VoiceRoomTagConfig.this.locatConfig});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callBack != null) {
                                callBack.onResult(VoiceRoomTagConfig.this.mTagsMap);
                            }
                        }
                    });
                }
            }
        });
    }

    public String getSingTagId() {
        return this.mSingTagId;
    }

    public static interface TagCallBack {
        public void onResult(LinkedHashMap<String, VoiceRoomTagConfigData> var1);
    }
}

