/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import java.util.List;

public class UidBelongServiceConfig
extends AConfigData {
    private Config config;

    @Override
    public BssCode getBssCode() {
        return BssCode.UID_BELONG_SERVICE;
    }

    @Override
    public void parseConfig(String configs) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"UidBelongServiceConfig", (String)configs, (Object[])new Object[0]);
        }
        this.config = (Config)JsonParser.parseJsonObject((String)configs, Config.class);
        this.parseNum();
    }

    @Override
    public boolean parseDefault() {
        String config = this.defaultConfig();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"UidBelongServiceConfig", (String)"parseDefault config: %s", (Object[])new Object[]{config});
        }
        this.parseConfig(config);
        return true;
    }

    private synchronized void parseNum() {
        this.config.uidMaskNum = this.parseLong(this.config.uidMaskStr, -16777216L);
        for (ServiceInfoConfig s : this.config.services) {
            s.caseNum = this.parseLong(s.caseStr, 0L);
        }
    }

    public synchronized String countryCode(long uid) {
        ServiceInfoConfig info = this.getServiceInfo(uid);
        if (info == null) {
            return "";
        }
        return info.country == null ? "" : info.country;
    }

    public synchronized String idc(long uid) {
        ServiceInfoConfig info = this.getServiceInfo(uid);
        if (info == null) {
            return "";
        }
        return info.idc == null ? "" : info.idc;
    }

    @Nullable
    public synchronized ServiceInfoConfig getServiceInfo(long uid) {
        long v = uid & this.config.uidMaskNum;
        for (ServiceInfoConfig s : this.config.services) {
            if (v != s.caseNum) continue;
            return s;
        }
        return null;
    }

    private long parseLong(String str, long def) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return def;
        }
        if (str.startsWith("0x")) {
            str = str.substring(2);
            try {
                return Long.valueOf(str, 16);
            }
            catch (Exception e) {
                MLog.error((Object)"UidBelongServiceConfig", (Throwable)e);
                return def;
            }
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            MLog.error((Object)"UidBelongServiceConfig", (Throwable)e);
            return def;
        }
    }

    private String defaultConfig() {
        return "{\"uid_mask\":\"0xFF00000000\",\"services\":[{\"case\":\"0x00000000\",\"idc\":\"863\",\"country_code\":\"id\"},{\"case\":\"0x100000000\",\"idc\":\"875\",\"country_code\":\"in\"},{\"case\":\"0x200000000\",\"idc\":\"894\",\"country_code\":\"ae\"},{\"case\":\"0x300000000\",\"idc\":\"972\",\"country_code\":\"us\"},{\"case\":\"0x400000000\",\"idc\":\"889\",\"country_code\":\"br\"},{\"case\":\"0x500000000\",\"idc\":\"892\",\"country_code\":\"ru\"},{\"case\":\"0x600000000\",\"idc\":\"881\",\"country_code\":\"sg\"}]}";
    }

    private static class ServiceInfoConfig {
        @SerializedName(value="case")
        private String caseStr = "";
        @SerializedName(value="idc")
        private String idc = "";
        @SerializedName(value="country_code")
        private String country = "";
        private long caseNum = 0L;

        private ServiceInfoConfig() {
        }
    }

    private static class Config {
        @SerializedName(value="uid_mask")
        public String uidMaskStr;
        @SerializedName(value="services")
        public List<ServiceInfoConfig> services;
        public long uidMaskNum = 0L;

        private Config() {
        }
    }
}

