/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.Base64Utils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.List;

@DontProguardClass
public class LoginTypeConfigData
extends AConfigData {
    private static final String TAG = "LoginTypeConfigData";
    @SerializedName(value="password_rule")
    public String passwordRule;
    @SerializedName(value="password_rule_desc")
    public String passwrodRuleDesc;
    @SerializedName(value="main_type")
    public String mainType;
    @SerializedName(value="type")
    public List<String> typeList;
    @SerializedName(value="exception_type")
    public List<String> exceptionTypeList;
    @SerializedName(value="login_exception_des")
    public String loginExceptionDes = null;
    @SerializedName(value="logout_exception_des")
    public String logoutExceptionDes = null;
    @SerializedName(value="clear_exception_des")
    public String clearExceptionDes = null;
    @SerializedName(value="phone_pwd_entrance")
    public int phonePwdEntranceSwitch = 1;
    @SerializedName(value="channel_list")
    public List<LoginTypeChannelData> channelList;
    private List<LoginTypeData> loginTypeDataList = new ArrayList<LoginTypeData>(0);
    private LoginTypeData loginMainType;
    private List<Integer> loginExceptionList = new ArrayList<Integer>(0);

    public List<LoginTypeData> getLoginTypeDataList() {
        return this.loginTypeDataList;
    }

    public LoginTypeData getLoginMainType() {
        return this.loginMainType;
    }

    public List<Integer> getLoginExceptionList() {
        return this.loginExceptionList;
    }

    public String getLoginExceptionDes() {
        return this.loginExceptionDes;
    }

    @Override
    public BssCode getBssCode() {
        return BssCode.LOGIN_TYPE_CONFIG;
    }

    @Override
    public boolean parseDefault() {
        return true;
    }

    @Override
    public void parseConfig(String configs) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)("parseConfig: " + configs), (Object[])new Object[0]);
        }
        if (!TextUtils.isEmpty((CharSequence)configs)) {
            try {
                LoginTypeConfigData config = (LoginTypeConfigData)JsonParser.parseJsonObject((String)configs, LoginTypeConfigData.class);
                if (config != null) {
                    LoginTypeData lt;
                    List<String> list = config.typeList;
                    this.loginTypeDataList.clear();
                    if (!FP.empty(list)) {
                        for (String item : list) {
                            lt = LoginTypeData.of(item);
                            if (!lt.checkValid()) continue;
                            this.loginTypeDataList.add(lt);
                        }
                    }
                    this.mainType = config.mainType;
                    this.typeList = config.typeList;
                    this.exceptionTypeList = config.exceptionTypeList;
                    this.channelList = config.channelList;
                    this.loginMainType = LoginTypeData.of(config.mainType);
                    if (!this.loginMainType.checkValid()) {
                        this.loginMainType = null;
                    }
                    this.loginExceptionList.clear();
                    list = config.exceptionTypeList;
                    if (!FP.empty(list)) {
                        for (String item : list) {
                            lt = LoginTypeData.of(item);
                            if (!lt.checkValid()) continue;
                            this.loginExceptionList.add(lt.getType());
                        }
                    }
                    this.loginExceptionDes = config.loginExceptionDes;
                    this.logoutExceptionDes = config.logoutExceptionDes;
                    this.clearExceptionDes = config.clearExceptionDes;
                    String passwordRuleBase64 = config.passwordRule;
                    this.passwrodRuleDesc = config.passwrodRuleDesc;
                    this.passwordRule = Base64Utils.getFromBase64((String)passwordRuleBase64);
                    this.phonePwdEntranceSwitch = config.phonePwdEntranceSwitch;
                }
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"parseConfig error", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    public String toString() {
        return "LoginTypeDataConfigData{mainType='" + this.mainType + '\'' + ", typeList=" + this.typeList + ", exceptionTypeList=" + this.exceptionTypeList + ", loginExceptionDes='" + this.loginExceptionDes + '\'' + ", logoutExceptionDes='" + this.logoutExceptionDes + '\'' + ", clearExceptionDes='" + this.clearExceptionDes + '\'' + '}';
    }

    public boolean hasException(int loginType) {
        return this.loginExceptionList.contains(loginType);
    }

    public boolean hasException() {
        return !this.loginExceptionList.isEmpty();
    }

    public boolean isPhonePwdEntranceOpen() {
        return this.phonePwdEntranceSwitch == 1;
    }

    @DontProguardClass
    public static class LoginTypeChannelData {
        @SerializedName(value="channel_id")
        @Nullable
        public String channelId;
        @SerializedName(value="main_type")
        @Nullable
        public String mainType;
        @SerializedName(value="type")
        @Nullable
        public List<String> typeList;
    }
}

