/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.HostPreConnectConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.grace.NetworkConverter;
import com.yy.grace.networkinterceptor.BizScenc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class HostPreConnectConfig
extends AConfigData {
    private static final ArrayList<NetworkConverter.Factory.PreHost> sLoginHostNetWorkMapArrayList = new ArrayList();
    private static final ArrayList<NetworkConverter.Factory.PreHost> sChannelHostNetWorkMapArrayList = new ArrayList();
    private static final ArrayList<NetworkConverter.Factory.PreHost> sRechargeHostNetWorkMapArrayList = new ArrayList();

    @Override
    public BssCode getBssCode() {
        return BssCode.PRE_CONNECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseConfig(String configs) {
        MLog.debug((Object)"HostPreConnectConfig", (String)("config = " + configs), (Object[])new Object[0]);
        HostPreConnectConfig hostPreConnectConfig = this;
        synchronized (hostPreConnectConfig) {
            sLoginHostNetWorkMapArrayList.clear();
            sChannelHostNetWorkMapArrayList.clear();
            sRechargeHostNetWorkMapArrayList.clear();
            HostPreConnectConfigData hostPreConnectConfigData = (HostPreConnectConfigData)JsonParser.parseJsonObject((String)configs, HostPreConnectConfigData.class);
            if (hostPreConnectConfigData != null) {
                this.parseHostPreConnectList(hostPreConnectConfigData.loginHostPreConnectConfig, sLoginHostNetWorkMapArrayList);
                this.parseHostPreConnectList(hostPreConnectConfigData.channelHostPreConnectConfig, sChannelHostNetWorkMapArrayList);
                this.parseHostPreConnectList(hostPreConnectConfigData.rechargeHostPreConnectConfig, sRechargeHostNetWorkMapArrayList);
            }
        }
    }

    private void parseHostPreConnectList(HostPreConnectConfigData.HostPreConnectConfig hostPreConnectConfig, ArrayList<NetworkConverter.Factory.PreHost> list) {
        if (hostPreConnectConfig != null && hostPreConnectConfig.hosts != null && hostPreConnectConfig.hosts.size() > 0) {
            for (HostPreConnectConfigData.HostPreConnectConfigItem item : hostPreConnectConfig.hosts) {
                NetworkConverter.Factory.PreHost preHost = new NetworkConverter.Factory.PreHost(item.host, StringUtils.isEmpty((String)item.group) ? null : BizScenc.getGroup((String)item.group), item.network);
                list.add(preHost);
            }
        }
    }

    public static List<NetworkConverter.Factory.PreHost> getLoginHostNetWorkMapArrayList() {
        return new CopyOnWriteArrayList<NetworkConverter.Factory.PreHost>(sLoginHostNetWorkMapArrayList);
    }

    public static List<NetworkConverter.Factory.PreHost> getChannelHostNetWorkMapArrayList() {
        return new CopyOnWriteArrayList<NetworkConverter.Factory.PreHost>(sChannelHostNetWorkMapArrayList);
    }

    public static List<NetworkConverter.Factory.PreHost> getRechargeHostNetWorkMapArrayList() {
        return new CopyOnWriteArrayList<NetworkConverter.Factory.PreHost>(sRechargeHostNetWorkMapArrayList);
    }
}

