/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AudioRecordConfig
extends AConfigData {
    private static final String TAG = "AudioRecordConfig";
    private boolean mSwitch = true;
    private final CopyOnWriteArrayList<Long> mUids = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> mDevices = new CopyOnWriteArrayList();

    @Override
    public BssCode getBssCode() {
        return BssCode.AUDIO_RECORD_CONFIG;
    }

    @Override
    public void parseConfig(final String configs) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"parseConfig configs: %s", (Object[])new Object[]{configs});
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioRecordConfig.this.parseConfigAsync(configs);
                }
            });
        } else {
            this.parseConfigAsync(configs);
        }
    }

    public boolean getSwitch() {
        return this.mSwitch;
    }

    public boolean isInBlackList(long uid) {
        return this.mUids.contains(uid);
    }

    public boolean isInBlackList(String device) {
        return this.mDevices.contains(device);
    }

    private void parseConfigAsync(String configs) {
        if (TextUtils.isEmpty((CharSequence)configs)) {
            return;
        }
        try {
            JSONObject obj = JsonParser.obtainJSONObject((String)configs);
            this.mSwitch = obj.optInt("switch", 0) == 1;
            JSONObject black = obj.optJSONObject("blackList");
            JSONArray uids = black.optJSONArray("uid");
            this.parseUids(uids);
            JSONArray devices = black.optJSONArray("device");
            this.parseDevices(devices);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"parseConfigAsync", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void parseUids(JSONArray uids) {
        this.mUids.clear();
        if (uids == null) {
            return;
        }
        int len = uids.length();
        for (int i = 0; i < len; ++i) {
            this.mUids.add(uids.optLong(i));
        }
    }

    private void parseDevices(JSONArray devices) {
        this.mDevices.clear();
        if (devices == null) {
            return;
        }
        int len = devices.length();
        for (int i = 0; i < len; ++i) {
            this.mDevices.add(devices.optString(i));
        }
    }
}

