/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.os.Build;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class AIDenoiseConfig
extends AConfigData {
    private static final String KEY_CPU_COUNT_MIN = "cpu_count";
    private static final String KEY_API_LEVEL_MIN = "api_level";
    private static final int DEFAULT_CPU_COUNT_MIN = 6;
    private static final int DEFAULT_API_LEVEL_MIN = 23;
    private boolean mIsAIDenoiseEnable;

    @Override
    public BssCode getBssCode() {
        return BssCode.AI_DENOISE;
    }

    @Override
    public void parseConfig(String config) {
        if (StringUtils.isEmpty((String)config)) {
            return;
        }
        this.mConfigContent = config;
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"AIDenoiseConfig", (String)"config:%s", (Object[])new Object[]{config});
        }
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)config);
            this.parseIntValueToKeysAndValues(jo, KEY_CPU_COUNT_MIN);
            this.parseIntValueToKeysAndValues(jo, KEY_API_LEVEL_MIN);
            this.mIsAIDenoiseEnable = this.checkAIDenoiseEnable();
            MLog.info((Object)"AIDenoiseConfig", (String)("ai denoise enable " + this.mIsAIDenoiseEnable), (Object[])new Object[0]);
        }
        catch (JSONException e) {
            MLog.error((Object)"AIDenoiseConfigData", (Throwable)e);
        }
    }

    public boolean isAIDenoiseEnable() {
        return this.mIsAIDenoiseEnable;
    }

    private boolean checkAIDenoiseEnable() {
        return HardwareUtils.getCpuCoreCount() >= this.getIntValue(KEY_CPU_COUNT_MIN, 6) && Build.VERSION.SDK_INT >= this.getIntValue(KEY_API_LEVEL_MIN, 23);
    }
}

