/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig;

import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.IUnifyHandler;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum UnifyConfig {
    INSTANCE;

    private IUnifyHandler mConfigController;

    public List<BssCode> getRequestBssCode() {
        if (AccountUtil.getUid() <= 0L) {
            ArrayList<BssCode> configList = new ArrayList<BssCode>(18);
            configList.add(BssCode.LOGIN_TYPE_CONFIG);
            configList.add(BssCode.HIIDO_EVENT_FILTER);
            configList.add(BssCode.HIIDO_ACT_FILTER);
            configList.add(BssCode.DEFAULT_IP_CONFIG);
            configList.add(BssCode.CAMPAIGN_DP);
            configList.add(BssCode.PACKAGE_CHANNEL_DEEP_LINK);
            configList.add(BssCode.AF_FIREBASE_STAT_CONFIG);
            configList.add(BssCode.BBS_CONFIG);
            configList.add(BssCode.HOME_CONFIG);
            configList.add(BssCode.PRE_CONNECT);
            configList.add(BssCode.NETWORK);
            configList.add(BssCode.PERFORMANCE_CONFIG);
            configList.add(BssCode.GROWTH);
            configList.add(BssCode.GROWTH_BUSINESS);
            configList.add(BssCode.WEB_PRELOAD_CONFIG);
            configList.add(BssCode.DP_JUMP_OPT_CONFIG);
            return configList;
        }
        return null;
    }

    public List<BssCode> bssCodesNewCountryStrictMatch() {
        ArrayList<BssCode> configList = new ArrayList<BssCode>(5);
        configList.add(BssCode.HOME_CONFIG);
        return configList;
    }

    public void initController(IUnifyHandler controller) {
        this.mConfigController = controller;
    }

    @Nullable
    public Collection<BssCode> getRegisterCodeList() {
        if (this.mConfigController != null) {
            return this.mConfigController.getRegisterCodeList();
        }
        return null;
    }

    @Nullable
    public AConfigData getConfigData(BssCode bssCode) {
        if (this.mConfigController != null) {
            return this.mConfigController.getConfigData(bssCode);
        }
        return null;
    }

    public <T> T getConfigDataBySpecifiedType(BssCode bssCode) {
        if (this.mConfigController != null) {
            return (T)this.mConfigController.getConfigData(bssCode);
        }
        return null;
    }

    @Nullable
    public <D extends AConfigData> AConfigData getConfigData(BssCode bssCode, IConfigListener<D> listener2) {
        this.registerListener(bssCode, listener2);
        return this.getConfigData(bssCode);
    }

    public void onLoginSuccess() {
        if (this.mConfigController != null) {
            this.mConfigController.onLoginSuccess();
        }
    }

    @Nullable
    public <D extends AConfigData> AConfigData fetchConfigData(BssCode bssCode, IConfigListener<D> listener2) {
        this.registerListener(bssCode, listener2);
        AConfigData data2 = this.getConfigData(bssCode);
        MLog.info((Object)"UnifyConfig", (String)"fetchConfigData bssCode: %s, data == null: %b", (Object[])new Object[]{bssCode, data2 == null});
        if (data2 == null && this.mConfigController != null) {
            this.mConfigController.requestConfigData(bssCode);
        }
        return data2;
    }

    public <D extends AConfigData> boolean registerListener(BssCode bssCode, IConfigListener<D> listener2) {
        if (this.mConfigController != null) {
            return this.mConfigController.registerListener(bssCode, listener2);
        }
        return false;
    }

    public <D extends AConfigData> void unregisterListener(BssCode bssCode, IConfigListener<D> listener2) {
        if (this.mConfigController != null) {
            this.mConfigController.unregisterListener(bssCode, listener2);
        }
    }

    public String getLocalDefaultConfigJson(BssCode bssCode) {
        return this.mConfigController != null ? this.mConfigController.getLocalDefaultConfigJson(bssCode) : null;
    }
}

