/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.recycler;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class GridSpacingDecoration
extends RecyclerView.ItemDecoration {
    private static final int VERTICAL = 1;
    private int orientation = -1;
    private int spanCount = -1;
    private int spacing;
    private int halfSpacing;

    public GridSpacingDecoration(int spacingPx) {
        this.spacing = spacingPx;
        this.halfSpacing = this.spacing / 2;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.orientation == -1) {
            this.orientation = this.getOrientation(parent);
        }
        if (this.spanCount == -1) {
            this.spanCount = this.getTotalSpan(parent);
        }
        int childCount = parent.getLayoutManager().getItemCount();
        int childIndex = parent.getChildAdapterPosition(view);
        int itemSpanSize = this.getItemSpanSize(parent, childIndex);
        int spanIndex = this.getItemSpanIndex(parent, childIndex);
        if (this.spanCount < 1) {
            return;
        }
        if (itemSpanSize == this.spanCount) {
            return;
        }
        this.setSpacings(outRect, parent, childCount, childIndex, itemSpanSize, spanIndex);
    }

    protected void setSpacings(Rect outRect, RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        outRect.top = this.halfSpacing;
        outRect.bottom = this.halfSpacing;
        outRect.left = this.halfSpacing;
        outRect.right = this.halfSpacing;
        if (this.isTopEdge(parent, childCount, childIndex, itemSpanSize, spanIndex)) {
            outRect.top = this.halfSpacing;
        }
        if (this.isLeftEdge(parent, childCount, childIndex, itemSpanSize, spanIndex)) {
            outRect.left = this.spacing;
        }
        if (this.isRightEdge(parent, childCount, childIndex, itemSpanSize, spanIndex)) {
            outRect.right = this.halfSpacing;
        }
        if (this.isBottomEdge(parent, childCount, childIndex, itemSpanSize, spanIndex)) {
            outRect.bottom = this.spacing;
        }
    }

    protected int getTotalSpan(RecyclerView parent) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getSpanCount();
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)mgr).getSpanCount();
        }
        if (mgr instanceof LinearLayoutManager) {
            return 1;
        }
        return -1;
    }

    protected int getItemSpanSize(RecyclerView parent, int childIndex) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getSpanSizeLookup().getSpanSize(childIndex);
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return 1;
        }
        if (mgr instanceof LinearLayoutManager) {
            return 1;
        }
        return -1;
    }

    protected int getItemSpanIndex(RecyclerView parent, int childIndex) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getSpanSizeLookup().getSpanIndex(childIndex, this.spanCount);
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return childIndex % this.spanCount;
        }
        if (mgr instanceof LinearLayoutManager) {
            return 0;
        }
        return -1;
    }

    protected int getOrientation(RecyclerView parent) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)mgr).getOrientation();
        }
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getOrientation();
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)mgr).getOrientation();
        }
        return 1;
    }

    protected boolean isLeftEdge(RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        if (this.orientation == 1) {
            return spanIndex == 0;
        }
        return childIndex == 0 || this.isFirstItemEdgeValid(childIndex < this.spanCount, parent, childIndex);
    }

    protected boolean isRightEdge(RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        if (this.orientation == 1) {
            return spanIndex + itemSpanSize == this.spanCount;
        }
        return this.isLastItemEdgeValid(childIndex >= childCount - this.spanCount, parent, childCount, childIndex, spanIndex);
    }

    protected boolean isTopEdge(RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        if (this.orientation == 1) {
            return childIndex == 0 || this.isFirstItemEdgeValid(childIndex < this.spanCount, parent, childIndex);
        }
        return spanIndex == 0;
    }

    protected boolean isBottomEdge(RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        if (this.orientation == 1) {
            return this.isLastItemEdgeValid(childIndex >= childCount - this.spanCount, parent, childCount, childIndex, spanIndex);
        }
        return spanIndex + itemSpanSize == this.spanCount;
    }

    protected boolean isFirstItemEdgeValid(boolean isOneOfFirstItems, RecyclerView parent, int childIndex) {
        int totalSpanArea = 0;
        if (isOneOfFirstItems) {
            for (int i = childIndex; i >= 0; --i) {
                totalSpanArea += this.getItemSpanSize(parent, i);
            }
        }
        return isOneOfFirstItems && totalSpanArea <= this.spanCount;
    }

    protected boolean isLastItemEdgeValid(boolean isOneOfLastItems, RecyclerView parent, int childCount, int childIndex, int spanIndex) {
        int totalSpanRemaining = 0;
        if (isOneOfLastItems) {
            for (int i = childIndex; i < childCount; ++i) {
                totalSpanRemaining += this.getItemSpanSize(parent, i);
            }
        }
        return isOneOfLastItems && totalSpanRemaining <= this.spanCount - spanIndex;
    }
}

