/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.image;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.yy.appbase.R;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;

public class RoundScaleImageView
extends RecycleImageView {
    private static final String TAG = "RoundScaleImageView";
    public static final int TYPE_CIRCLE = 0;
    public static final int TYPE_ROUND = 1;
    public static final int CORNER_TOP_LEFT = 1;
    public static final int CORNER_TOP_RIGHT = 2;
    public static final int CORNER_BOTTOM_LEFT = 4;
    public static final int CORNER_BOTTOM_RIGHT = 8;
    public static final int CORNER_ALL = 15;
    private int type = 1;
    private static final int BODER_RADIUS_DEFAULT = 4;
    private int mBorderRadius;
    private int mCornerModel = 15;
    private Paint mBitmapPaint;
    private Paint mColorPaint;
    private int mRadius;
    private BitmapShader mBitmapShader;
    private int mWidth;
    private RectF mRoundRect;
    private int mLoadingColor = 0;
    private boolean mHadUseLoadingColor = false;
    private Paint mPaint;
    private static final String STATE_INSTANCE = "state_instance";
    private static final String STATE_TYPE = "state_type";
    private static final String STATE_BORDER_RADIUS = "state_border_radius";

    public RoundScaleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public RoundScaleImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundScaleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mBitmapPaint = new Paint();
        this.mColorPaint = new Paint();
        this.mColorPaint.setAntiAlias(true);
        this.mBitmapPaint.setAntiAlias(true);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundImageView);
            this.mBorderRadius = a.getDimensionPixelSize(R.styleable.RoundImageView_borderRadius, ResolutionUtils.dip2Px((float)4.0f));
            this.type = a.getInt(R.styleable.RoundImageView_type, 1);
            boolean topLeft = a.getBoolean(R.styleable.RoundImageView_cornerTopLeft, true);
            boolean topRight = a.getBoolean(R.styleable.RoundImageView_cornerTopRight, true);
            boolean bottomLeft = a.getBoolean(R.styleable.RoundImageView_cornerBottomLeft, true);
            boolean bottomRight = a.getBoolean(R.styleable.RoundImageView_cornerBottomRight, true);
            this.setCornerModel(topLeft, topRight, bottomLeft, bottomRight);
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.type == 0) {
            this.mWidth = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
            this.mRadius = this.mWidth / 2;
            this.setMeasuredDimension(this.mWidth, this.mWidth);
        }
    }

    private void setUpShader() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        Bitmap bmp = this.drawableToBitmap(drawable2);
        if (bmp == null || bmp.isRecycled()) {
            MLog.error((Object)TAG, (String)"setUpShader bmp == null: %b", (Object[])new Object[]{bmp == null});
            return;
        }
        this.mBitmapShader = new BitmapShader(bmp, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (!(drawable2 instanceof NinePatchDrawable)) {
            this.mBitmapShader.setLocalMatrix(this.getImageMatrix());
        }
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
    }

    private Bitmap drawableToBitmap(Drawable drawable2) {
        BitmapDrawable bd;
        if (drawable2 instanceof BitmapDrawable && (bd = (BitmapDrawable)drawable2).getBitmap() != null && !bd.getBitmap().isRecycled()) {
            return bd.getBitmap();
        }
        int w = 0;
        w = drawable2 instanceof NinePatchDrawable ? this.getWidth() : drawable2.getIntrinsicWidth();
        int h = 0;
        h = drawable2 instanceof NinePatchDrawable ? this.getHeight() : drawable2.getIntrinsicHeight();
        if (w <= 0) {
            w = this.getMeasuredWidth();
        }
        if (h <= 0) {
            h = this.getMeasuredHeight();
        }
        if (w <= 0 || h <= 0) {
            return null;
        }
        Bitmap bitmap = BitmapUtils.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, w, h);
        drawable2.draw(canvas);
        return bitmap;
    }

    public void setLoadingColor(int color) {
        this.mHadUseLoadingColor = true;
        this.mLoadingColor = color;
        this.invalidate();
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mHadUseLoadingColor = false;
        super.setImageDrawable(drawable2);
        if (drawable2 == null && this.isImageShaderOptSwitchOn()) {
            this.mBitmapShader = null;
        }
    }

    public void setImageBitmap(Bitmap bm) {
        this.mHadUseLoadingColor = false;
        super.setImageBitmap(bm);
    }

    public void setImageResource(int resId) {
        this.mHadUseLoadingColor = false;
        super.setImageResource(resId);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mHadUseLoadingColor || this.getDrawable() == null) {
            this.mColorPaint.setColor(this.mLoadingColor);
            this.mPaint = this.mColorPaint;
        } else if (this.getDrawable() instanceof ColorDrawable) {
            int color = ((ColorDrawable)this.getDrawable()).getColor();
            this.mColorPaint.setColor(color);
            this.mPaint = this.mColorPaint;
        } else {
            this.setUpShader();
            this.mPaint = this.mBitmapPaint;
        }
        if (this.type == 1 && this.mRoundRect != null) {
            canvas.drawRoundRect(this.mRoundRect, (float)this.mBorderRadius, (float)this.mBorderRadius, this.mPaint);
            this.drawerCorner(canvas, this.mRoundRect, this.mCornerModel, this.mBorderRadius, this.mPaint);
        } else {
            canvas.drawCircle((float)this.mRadius, (float)this.mRadius, (float)this.mRadius, this.mPaint);
        }
    }

    private void drawerCorner(Canvas canvas, RectF rect, int corners, int cornerRadius, Paint paint) {
        int notRoundedCorners = corners ^ 0xF;
        if ((notRoundedCorners & 1) != 0) {
            canvas.drawRect(0.0f, 0.0f, (float)cornerRadius, (float)cornerRadius, paint);
        }
        if ((notRoundedCorners & 2) != 0) {
            canvas.drawRect(rect.right - (float)cornerRadius, 0.0f, rect.right, (float)cornerRadius, paint);
        }
        if ((notRoundedCorners & 4) != 0) {
            canvas.drawRect(0.0f, rect.bottom - (float)cornerRadius, (float)cornerRadius, rect.bottom, paint);
        }
        if ((notRoundedCorners & 8) != 0) {
            canvas.drawRect(rect.right - (float)cornerRadius, rect.bottom - (float)cornerRadius, rect.right, rect.bottom, paint);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.type == 1) {
            this.mRoundRect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(STATE_INSTANCE, super.onSaveInstanceState());
        bundle.putInt(STATE_TYPE, this.type);
        bundle.putInt(STATE_BORDER_RADIUS, this.mBorderRadius);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            super.onRestoreInstanceState(((Bundle)state).getParcelable(STATE_INSTANCE));
            this.type = bundle.getInt(STATE_TYPE);
            this.mBorderRadius = bundle.getInt(STATE_BORDER_RADIUS);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void setBorderRadius(int borderRadius) {
        int pxVal = ResolutionUtils.dip2Px((float)borderRadius);
        if (this.mBorderRadius != pxVal) {
            this.mBorderRadius = pxVal;
            this.invalidate();
        }
    }

    public void setBorderPxRadius(int borderRadius) {
        int pxVal = borderRadius;
        if (this.mBorderRadius != pxVal) {
            this.mBorderRadius = pxVal;
            this.invalidate();
        }
    }

    public void setType(int type2) {
        if (this.type != type2) {
            this.type = type2;
            if (this.type != 1 && this.type != 0) {
                this.type = 0;
            }
            this.requestLayout();
        }
    }

    public void setCornerModel(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        int corner;
        if (LanguageUtils.isRtl()) {
            boolean temp = topLeft;
            topLeft = topRight;
            topRight = temp;
            temp = bottomLeft;
            bottomLeft = bottomRight;
            bottomRight = temp;
        }
        if (this.mCornerModel != (corner = this.convert(topLeft) | this.convert(topRight) << 1 | this.convert(bottomLeft) << 2 | this.convert(bottomRight) << 3)) {
            this.mCornerModel = corner;
            this.requestLayout();
        }
    }

    private int convert(boolean b) {
        return b ? 1 : 0;
    }
}

