/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.image;

import android.widget.AbsListView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;

public class PauseOnScrollListener
implements AbsListView.OnScrollListener {
    private final boolean mPauseOnScroll;
    private final boolean mPauseOnFling;
    private final AbsListView.OnScrollListener mExternalListener;
    private AbsListView.OnScrollListener mHiddoPoseListener;

    public PauseOnScrollListener(boolean pauseOnScroll, boolean pauseOnFling) {
        this(pauseOnScroll, pauseOnFling, null);
    }

    public PauseOnScrollListener(boolean pauseOnScroll, boolean pauseOnFling, AbsListView.OnScrollListener externalListener) {
        this.mPauseOnScroll = pauseOnScroll;
        this.mPauseOnFling = pauseOnFling;
        this.mExternalListener = externalListener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        switch (scrollState) {
            case 0: {
                ImageLoader.resumeRequests();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.mPauseOnFling || !RuntimeContext.isPhoneSuperLow()) break;
                ImageLoader.pauseRequests();
                break;
            }
        }
        if (this.mExternalListener != null) {
            this.mExternalListener.onScrollStateChanged(view, scrollState);
        }
        if (this.mHiddoPoseListener != null) {
            this.mHiddoPoseListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        if (this.mHiddoPoseListener != null) {
            this.mHiddoPoseListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void setmHiddoPoseListener(AbsListView.OnScrollListener mHiddoPoseListener) {
        this.mHiddoPoseListener = mHiddoPoseListener;
    }
}

