/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.image;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.image.NiceImageView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CropImageView
extends NiceImageView {
    public static final int DEFAULT_CROP_TYPE = -1;
    private int mCropType = -1;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
        this.mCropType = ta.getInt(R.styleable.CropImageView_crop_type, -1);
        if (this.mCropType != -1) {
            this.setScaleType(ImageView.ScaleType.MATRIX);
        }
        ta.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mCropType != -1) {
            this.changeImageMatrix();
        }
    }

    private void changeImageMatrix() {
        int drawableHeight;
        if (this.getDrawable() == null) {
            return;
        }
        Matrix matrix = this.getImageMatrix();
        int viewWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int drawableWidth = this.getDrawable().getIntrinsicWidth();
        float scale = drawableWidth * viewHeight > (drawableHeight = this.getDrawable().getIntrinsicHeight()) * viewWidth ? (float)viewHeight / (float)drawableHeight : (float)viewWidth / (float)drawableWidth;
        RectF drawableRect = null;
        if (this.mCropType == 0) {
            drawableRect = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)viewHeight / scale);
        } else if (this.mCropType == 1) {
            drawableRect = new RectF(0.0f, (float)drawableHeight - (float)viewHeight / scale, (float)drawableWidth, (float)drawableHeight);
        }
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        matrix.setRectToRect(drawableRect, viewRect, Matrix.ScaleToFit.FILL);
        this.setImageMatrix(matrix);
    }

    public void setCropType(int cropType) {
        if (this.mCropType != cropType) {
            this.mCropType = cropType;
            this.requestLayout();
            this.invalidate();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CropType {
    }
}

