/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.horizontallist;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.OverScroller;
import androidx.collection.LongSparseArray;
import androidx.collection.SparseArrayCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.EdgeEffectCompat;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.horizontallist.AdapterView;
import com.yy.base.logger.MLog;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public abstract class AbsHListView
extends AdapterView<ListAdapter>
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnTouchModeChangeListener {
    private static final String TAG = "AbsListView";
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    public static final int TOUCH_MODE_REST = -1;
    public static final int TOUCH_MODE_DOWN = 0;
    public static final int TOUCH_MODE_TAP = 1;
    public static final int TOUCH_MODE_DONE_WAITING = 2;
    public static final int TOUCH_MODE_SCROLL = 3;
    public static final int TOUCH_MODE_FLING = 4;
    public static final int TOUCH_MODE_OVERSCROLL = 5;
    public static final int TOUCH_MODE_OVERFLING = 6;
    public static final int LAYOUT_NORMAL = 0;
    public static final int LAYOUT_FORCE_LEFT = 1;
    public static final int LAYOUT_SET_SELECTION = 2;
    public static final int LAYOUT_FORCE_RIGHT = 3;
    public static final int LAYOUT_SPECIFIC = 4;
    public static final int LAYOUT_SYNC = 5;
    public static final int LAYOUT_MOVE_SELECTION = 6;
    protected int mChoiceMode = 0;
    public Object mChoiceActionMode;
    int mCheckedItemCount;
    protected SparseArrayCompat<Boolean> mCheckStates;
    LongSparseArray<Integer> mCheckedIdStates;
    protected int mLayoutMode = 0;
    protected AdapterDataSetObserver mDataSetObserver;
    protected ListAdapter mAdapter;
    boolean mAdapterHasStableIds;
    boolean mDrawSelectorOnTop = false;
    Drawable mSelector;
    int mSelectorPosition = -1;
    protected Rect mSelectorRect = new Rect();
    protected final RecycleBin mRecycler = new RecycleBin();
    int mSelectionLeftPadding = 0;
    int mSelectionTopPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionBottomPadding = 0;
    protected Rect mListPadding = new Rect();
    protected int mHeightMeasureSpec = 0;
    View mScrollLeft;
    View mScrollRight;
    protected boolean mCachingStarted;
    protected boolean mCachingActive;
    protected int mMotionPosition;
    int mMotionViewOriginalLeft;
    int mMotionViewNewLeft;
    int mMotionX;
    int mMotionY;
    protected int mTouchMode = -1;
    int mLastX;
    int mMotionCorrection;
    private VelocityTracker mVelocityTracker;
    private FlingRunnable mFlingRunnable;
    protected PositionScroller mPositionScroller;
    protected int mSelectedLeft = 0;
    protected boolean mStackFromRight;
    boolean mScrollingCacheEnabled;
    boolean mFastScrollEnabled;
    private OnScrollListener mOnScrollListener;
    private boolean mSmoothScrollbarEnabled = true;
    private Rect mTouchFrame;
    protected int mResurrectToPosition = -1;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    protected int mOverscrollMax;
    protected static final int OVERSCROLL_LIMIT_DIVISOR = 3;
    private static final int CHECK_POSITION_SEARCH_DISTANCE = 20;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    private static final int TOUCH_MODE_ON = 0;
    private static final int TOUCH_MODE_OFF = 1;
    private int mLastTouchMode = -1;
    private CheckForLongPress mPendingCheckForLongPress;
    private Runnable mPendingCheckForTap;
    private CheckForKeyLongPress mPendingCheckForKeyLongPress;
    private PerformClick mPerformClick;
    private Runnable mTouchModeReset;
    private int mTranscriptMode;
    private int mCacheColorHint;
    private boolean mIsChildViewEnabled;
    private int mLastScrollState = 0;
    private int mTouchSlop;
    private Runnable mClearScrollingCache;
    protected Runnable mPositionScrollAfterLayout;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private float mVelocityScale = 1.0f;
    protected final boolean[] mIsScrap = new boolean[1];
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    int mOverscrollDistance;
    int mOverflingDistance;
    private EdgeEffectCompat mEdgeGlowTop;
    private EdgeEffectCompat mEdgeGlowBottom;
    private int mFirstPositionDistanceGuess;
    private int mLastPositionDistanceGuess;
    private int mDirection = 0;
    private boolean mForceTranscriptScroll;
    private int mGlowPaddingTop;
    private int mGlowPaddingBottom;
    private ListItemAccessibilityDelegate mAccessibilityDelegate;
    private int mLastAccessibilityScrollEventFromIndex;
    private int mLastAccessibilityScrollEventToIndex;
    protected boolean mIsAttached;
    private int mLastHandledItemCount;
    static final Interpolator sLinearInterpolator = new LinearInterpolator();
    private SavedState mPendingSync;
    public static final int[] STATESET_NOTHING = new int[]{0};
    private float mHorizontalScrollFactor;

    public AbsHListView(Context context) {
        super(context);
        this.initAbsListView();
    }

    public AbsHListView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.hlv_absHListViewStyle);
    }

    public AbsHListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAbsListView();
        Resources.Theme theme = context.getTheme();
        TypedArray array = theme.obtainStyledAttributes(attrs, R.styleable.AbsHListView, defStyle, 0);
        Drawable listSelector = null;
        boolean drawSelectorOnTop = false;
        boolean stackFromRight = false;
        boolean scrollingCacheEnabled = true;
        int transcriptMode = 0;
        int color2 = 0;
        boolean smoothScrollbar = true;
        int choiceMode = 0;
        if (null != array) {
            listSelector = array.getDrawable(R.styleable.AbsHListView_android_listSelector);
            drawSelectorOnTop = array.getBoolean(R.styleable.AbsHListView_android_drawSelectorOnTop, false);
            stackFromRight = array.getBoolean(R.styleable.AbsHListView_hlv_stackFromRight, false);
            scrollingCacheEnabled = array.getBoolean(R.styleable.AbsHListView_android_scrollingCache, true);
            transcriptMode = array.getInt(R.styleable.AbsHListView_hlv_transcriptMode, 0);
            color2 = array.getColor(R.styleable.AbsHListView_android_cacheColorHint, 0);
            smoothScrollbar = array.getBoolean(R.styleable.AbsHListView_android_smoothScrollbar, true);
            choiceMode = array.getInt(R.styleable.AbsHListView_android_choiceMode, 0);
            array.recycle();
        }
        if (listSelector != null) {
            this.setSelector(listSelector);
        }
        this.mDrawSelectorOnTop = drawSelectorOnTop;
        this.setStackFromRight(stackFromRight);
        this.setScrollingCacheEnabled(scrollingCacheEnabled);
        this.setTranscriptMode(transcriptMode);
        this.setCacheColorHint(color2);
        this.setSmoothScrollbarEnabled(smoothScrollbar);
        this.setChoiceMode(choiceMode);
    }

    private void initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
    }

    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffectCompat(context);
                this.mEdgeGlowBottom = new EdgeEffectCompat(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(mode);
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (adapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public boolean isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return (Boolean)this.mCheckStates.get(position, (Object)false);
        }
        return false;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseArrayCompat<Boolean> getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> idStates = this.mCheckedIdStates;
        int count = idStates.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = idStates.keyAt(i);
        }
        return ids;
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    public void setItemChecked(int position, boolean value) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (this.mChoiceMode == 2 || Build.VERSION.SDK_INT >= 11 && this.mChoiceMode == 3) {
            boolean oldValue = (Boolean)this.mCheckStates.get(position, (Object)false);
            this.mCheckStates.put(position, (Object)value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                }
            }
            if (oldValue != value) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
        } else {
            boolean updateIds;
            boolean bl = updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, (Object)true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !((Boolean)this.mCheckStates.valueAt(0)).booleanValue()) {
                this.mCheckedItemCount = 0;
            }
        }
        if (!this.mInLayout && !this.mBlockLayoutRequests) {
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
    }

    @Override
    public boolean performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || Build.VERSION.SDK_INT >= 11 && this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean checked = (Boolean)this.mCheckStates.get(position, (Object)false) == false;
                this.mCheckStates.put(position, (Object)checked);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (checked) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = checked ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean checked;
                boolean bl = checked = (Boolean)this.mCheckStates.get(position, (Object)false) == false;
                if (checked) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, (Object)true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !((Boolean)this.mCheckStates.valueAt(0)).booleanValue()) {
                    this.mCheckedItemCount = 0;
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    private void updateOnScreenCheckedViews() {
        int firstPos = this.mFirstPosition;
        int count = this.getChildCount();
        boolean useActivated = Build.VERSION.SDK_INT >= 11;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            if (child instanceof Checkable) {
                ((Checkable)child).setChecked(((Boolean)this.mCheckStates.get(position, (Object)false)).booleanValue());
                continue;
            }
            if (!useActivated) continue;
            child.setActivated(((Boolean)this.mCheckStates.get(position, (Object)false)).booleanValue());
        }
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    @TargetApi(value=11)
    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (Build.VERSION.SDK_INT >= 11 && this.mChoiceActionMode != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                ((ActionMode)this.mChoiceActionMode).finish();
            }
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseArrayCompat();
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray();
            }
            if (Build.VERSION.SDK_INT >= 11 && this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    private boolean contentFits() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        if (childCount != this.mItemCount) {
            return false;
        }
        return this.getChildAt(0).getLeft() >= this.mListPadding.left && this.getChildAt(childCount - 1).getRight() <= this.getWidth() - this.mListPadding.right;
    }

    protected int getHorizontalScrollbarHeight() {
        return super.getHorizontalScrollbarHeight();
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void setOnScrollListener(OnScrollListener l) {
        this.mOnScrollListener = l;
        this.invokeOnItemScrollListener();
    }

    protected void invokeOnItemScrollListener() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    public void sendAccessibilityEvent(int eventType) {
        if (eventType == 4096) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int lastVisiblePosition = this.getLastVisiblePosition();
            if (this.mLastAccessibilityScrollEventFromIndex == firstVisiblePosition && this.mLastAccessibilityScrollEventToIndex == lastVisiblePosition) {
                return;
            }
            this.mLastAccessibilityScrollEventFromIndex = firstVisiblePosition;
            this.mLastAccessibilityScrollEventToIndex = lastVisiblePosition;
        }
        super.sendAccessibilityEvent(eventType);
    }

    @Override
    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)AbsHListView.class.getName());
    }

    @Override
    @TargetApi(value=14)
    @SuppressLint(value={"Override"})
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)AbsHListView.class.getName());
        if (this.isEnabled()) {
            if (this.getFirstVisiblePosition() > 0) {
                info.addAction(8192);
            }
            if (this.getLastVisiblePosition() < this.getCount() - 1) {
                info.addAction(4096);
            }
        }
    }

    @TargetApi(value=16)
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        switch (action) {
            case 4096: {
                if (this.isEnabled() && this.getLastVisiblePosition() < this.getCount() - 1) {
                    int viewportWidth = this.getWidth() - this.mListPadding.left - this.mListPadding.right;
                    this.smoothScrollBy(viewportWidth, 200);
                    return true;
                }
                return false;
            }
            case 8192: {
                if (!this.isEnabled() || this.mFirstPosition <= 0) break;
                int viewportWidth = this.getWidth() - this.mListPadding.left - this.mListPadding.right;
                this.smoothScrollBy(-viewportWidth, 200);
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    public void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled && !enabled) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = enabled;
    }

    public void getFocusedRect(Rect r) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(r);
            this.offsetDescendantRectToMyCoords(view, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    private void useDefaultSelector() {
        this.setSelector(this.getResources().getDrawable(17301602));
    }

    public boolean isStackFromRight() {
        return this.mStackFromRight;
    }

    public void setStackFromRight(boolean stackFromRight) {
        if (this.mStackFromRight != stackFromRight) {
            this.mStackFromRight = stackFromRight;
            this.requestLayoutIfNecessary();
        }
    }

    void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    public Parcelable onSaveInstanceState() {
        long selectedId;
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.mPendingSync != null) {
            ss.selectedId = this.mPendingSync.selectedId;
            ss.firstId = this.mPendingSync.firstId;
            ss.viewLeft = this.mPendingSync.viewLeft;
            ss.position = this.mPendingSync.position;
            ss.width = this.mPendingSync.width;
            ss.filter = this.mPendingSync.filter;
            ss.inActionMode = this.mPendingSync.inActionMode;
            ss.checkedItemCount = this.mPendingSync.checkedItemCount;
            ss.checkState = this.mPendingSync.checkState;
            ss.checkIdState = this.mPendingSync.checkIdState;
            return ss;
        }
        boolean haveChildren = this.getChildCount() > 0 && this.mItemCount > 0;
        ss.selectedId = selectedId = this.getSelectedItemId();
        ss.width = this.getWidth();
        if (selectedId >= 0L) {
            ss.viewLeft = this.mSelectedLeft;
            ss.position = this.getSelectedItemPosition();
            ss.firstId = -1L;
        } else if (haveChildren && this.mFirstPosition > 0) {
            View v = this.getChildAt(0);
            ss.viewLeft = v.getLeft();
            int firstPos = this.mFirstPosition;
            if (firstPos >= this.mItemCount) {
                firstPos = this.mItemCount - 1;
            }
            ss.position = firstPos;
            ss.firstId = this.mAdapter.getItemId(firstPos);
        } else {
            ss.viewLeft = 0;
            ss.firstId = -1L;
            ss.position = 0;
        }
        ss.filter = null;
        boolean bl = ss.inActionMode = Build.VERSION.SDK_INT >= 11 && this.mChoiceMode == 3 && this.mChoiceActionMode != null;
        if (this.mCheckStates != null) {
            try {
                ss.checkState = this.mCheckStates.clone();
            }
            catch (NoSuchMethodError e) {
                Log.e((String)"AbsHListView", (String)"printStackTrace", (Throwable)e);
                ss.checkState = new SparseArrayCompat();
            }
        }
        if (this.mCheckedIdStates != null) {
            LongSparseArray idState = new LongSparseArray();
            int count = this.mCheckedIdStates.size();
            for (int i = 0; i < count; ++i) {
                idState.put(this.mCheckedIdStates.keyAt(i), this.mCheckedIdStates.valueAt(i));
            }
            ss.checkIdState = idState;
        }
        ss.checkedItemCount = this.mCheckedItemCount;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDataChanged = true;
        this.mSyncWidth = ss.width;
        if (ss.selectedId >= 0L) {
            this.mNeedSync = true;
            this.mPendingSync = ss;
            this.mSyncColId = ss.selectedId;
            this.mSyncPosition = ss.position;
            this.mSpecificLeft = ss.viewLeft;
            this.mSyncMode = 0;
        } else if (ss.firstId >= 0L) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectorPosition = -1;
            this.mNeedSync = true;
            this.mPendingSync = ss;
            this.mSyncColId = ss.firstId;
            this.mSyncPosition = ss.position;
            this.mSpecificLeft = ss.viewLeft;
            this.mSyncMode = 1;
        }
        if (ss.checkState != null) {
            this.mCheckStates = ss.checkState;
        }
        if (ss.checkIdState != null) {
            this.mCheckedIdStates = ss.checkIdState;
        }
        this.mCheckedItemCount = ss.checkedItemCount;
        this.requestLayout();
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            if (!this.mIsAttached && this.mAdapter != null) {
                this.mDataChanged = true;
                this.mOldItemCount = this.mItemCount;
                this.mItemCount = this.mAdapter.getCount();
            }
            this.resurrectSelection();
        }
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    protected void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mPositionScrollAfterLayout = null;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedColId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectedLeft = 0;
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    protected int computeHorizontalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int extent = count * 100;
                View view = this.getChildAt(0);
                int left = view.getLeft();
                int width = view.getWidth();
                if (width > 0) {
                    extent += left * 100 / width;
                }
                view = this.getChildAt(count - 1);
                int right = view.getRight();
                width = view.getWidth();
                if (width > 0) {
                    extent -= (right - this.getWidth()) * 100 / width;
                }
                return extent;
            }
            return 1;
        }
        return 0;
    }

    protected int computeHorizontalScrollOffset() {
        int firstPosition = this.mFirstPosition;
        int childCount = this.getChildCount();
        if (firstPosition >= 0 && childCount > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int left = view.getLeft();
                int width = view.getWidth();
                if (width > 0) {
                    return Math.max(firstPosition * 100 - left * 100 / width + (int)((float)this.getScrollX() / (float)this.getWidth() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int count = this.mItemCount;
                int index = firstPosition == 0 ? 0 : (firstPosition + childCount == count ? count : firstPosition + childCount / 2);
                return (int)((float)firstPosition + (float)childCount * ((float)index / (float)count));
            }
        }
        return 0;
    }

    protected int computeHorizontalScrollRange() {
        int result;
        if (this.mSmoothScrollbarEnabled) {
            result = Math.max(this.mItemCount * 100, 0);
            if (this.getScrollX() != 0) {
                result += Math.abs((int)((float)this.getScrollX() / (float)this.getWidth() * (float)this.mItemCount * 100.0f));
            }
        } else {
            result = this.mItemCount;
        }
        return result;
    }

    protected float getLeftFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getLeftFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition > 0) {
            return 1.0f;
        }
        int left = this.getChildAt(0).getLeft();
        float fadeLength = this.getHorizontalFadingEdgeLength();
        return left < this.getPaddingLeft() ? (float)(-(left - this.getPaddingLeft())) / fadeLength : fadeEdge;
    }

    protected float getRightFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getRightFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition + count - 1 < this.mItemCount - 1) {
            return 1.0f;
        }
        int right = this.getChildAt(count - 1).getRight();
        int width = this.getWidth();
        float fadeLength = this.getHorizontalFadingEdgeLength();
        return right > width - this.getPaddingRight() ? (float)(right - width + this.getPaddingRight()) / fadeLength : fadeEdge;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect listPadding = this.mListPadding;
        listPadding.left = this.mSelectionLeftPadding + this.getPaddingLeft();
        listPadding.top = this.mSelectionTopPadding + this.getPaddingTop();
        listPadding.right = this.mSelectionRightPadding + this.getPaddingRight();
        listPadding.bottom = this.mSelectionBottomPadding + this.getPaddingBottom();
        if (this.mTranscriptMode == 1) {
            int childCount = this.getChildCount();
            int listRight = this.getWidth() - this.getPaddingRight();
            View lastChild = this.getChildAt(childCount - 1);
            int lastRight = lastChild != null ? lastChild.getRight() : listRight;
            this.mForceTranscriptScroll = this.mFirstPosition + childCount >= this.mLastHandledItemCount && lastRight <= listRight;
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        if (changed) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mInLayout = false;
        this.mOverscrollMax = (r - l) / 3;
    }

    protected void layoutChildren() {
    }

    protected void updateScrollIndicators() {
        if (this.mScrollLeft != null) {
            boolean canScrollLeft;
            boolean bl = canScrollLeft = this.mFirstPosition > 0;
            if (!canScrollLeft && this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                canScrollLeft = child.getLeft() < this.mListPadding.left;
            }
            this.mScrollLeft.setVisibility(canScrollLeft ? 0 : 4);
        }
        if (this.mScrollRight != null) {
            boolean canScrollRight;
            int count = this.getChildCount();
            boolean bl = canScrollRight = this.mFirstPosition + count < this.mItemCount;
            if (!canScrollRight && count > 0) {
                View child = this.getChildAt(count - 1);
                canScrollRight = child.getRight() > this.getRight() - this.mListPadding.right;
            }
            this.mScrollRight.setVisibility(canScrollRight ? 0 : 4);
        }
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    @SuppressLint(value={"NewApi"})
    protected View obtainView(int position, boolean[] isScrap) {
        View child;
        isScrap[0] = false;
        View scrapView = this.mRecycler.getTransientStateView(position);
        if (scrapView != null) {
            return scrapView;
        }
        scrapView = this.mRecycler.getScrapView(position);
        if (scrapView != null) {
            child = this.mAdapter.getView(position, scrapView, (ViewGroup)this);
            if (Build.VERSION.SDK_INT >= 16 && child.getImportantForAccessibility() == 0) {
                child.setImportantForAccessibility(1);
            }
            if (child != scrapView) {
                this.mRecycler.addScrapView(scrapView, position);
                if (this.mCacheColorHint != 0) {
                    child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
                }
            } else {
                isScrap[0] = true;
                child.onFinishTemporaryDetach();
            }
        } else {
            child = this.mAdapter.getView(position, null, (ViewGroup)this);
            if (Build.VERSION.SDK_INT >= 16 && child.getImportantForAccessibility() == 0) {
                child.setImportantForAccessibility(1);
            }
            if (this.mCacheColorHint != 0) {
                child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
            }
        }
        if (this.mAdapterHasStableIds) {
            ViewGroup.LayoutParams vlp = child.getLayoutParams();
            LayoutParams lp = vlp == null ? (LayoutParams)this.generateDefaultLayoutParams() : (!this.checkLayoutParams(vlp) ? (LayoutParams)this.generateLayoutParams(vlp) : (LayoutParams)vlp);
            lp.itemId = this.mAdapter.getItemId(position);
            child.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (this.mAccessibilityManager.isEnabled() && this.mAccessibilityDelegate == null) {
            this.mAccessibilityDelegate = new ListItemAccessibilityDelegate();
        }
        return child;
    }

    protected void positionSelector(int position, View sel) {
        if (position != -1) {
            this.mSelectorPosition = position;
        }
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        if (sel instanceof SelectionBoundsAdjuster) {
            ((SelectionBoundsAdjuster)sel).adjustListItemSelectionBounds(selectorRect);
        }
        this.positionSelector(selectorRect.left, selectorRect.top, selectorRect.right, selectorRect.bottom);
        boolean isChildViewEnabled = this.mIsChildViewEnabled;
        if (sel.isEnabled() != isChildViewEnabled) {
            boolean bl = this.mIsChildViewEnabled = !isChildViewEnabled;
            if (this.getSelectedItemPosition() != -1) {
                this.refreshDrawableState();
            }
        }
    }

    private void positionSelector(int l, int t, int r, int b) {
        this.mSelectorRect.set(l - this.mSelectionLeftPadding, t - this.mSelectionTopPadding, r + this.mSelectionRightPadding, b + this.mSelectionBottomPadding);
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop = this.mDrawSelectorOnTop;
        if (!drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.getChildCount() > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
        }
    }

    boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected boolean shouldShowSelector() {
        return this.hasFocus() && !this.isInTouchMode() || this.touchModeDrawsInPressedState();
    }

    private void drawSelector(Canvas canvas) {
        if (!this.mSelectorRect.isEmpty()) {
            Drawable selector = this.mSelector;
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    public void setDrawSelectorOnTop(boolean onTop) {
        this.mDrawSelectorOnTop = onTop;
    }

    public void setSelector(int resID) {
        this.setSelector(this.getResources().getDrawable(resID));
    }

    public void setSelector(Drawable sel) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        Rect padding = new Rect();
        sel.getPadding(padding);
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
        sel.setCallback((Drawable.Callback)this);
        this.updateSelectorState();
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    protected void keyPressed() {
        if (!this.isEnabled() || !this.isClickable()) {
            return;
        }
        Drawable selector = this.mSelector;
        Rect selectorRect = this.mSelectorRect;
        if (selector != null && (this.isFocused() || this.touchModeDrawsInPressedState()) && !selectorRect.isEmpty()) {
            View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            if (v != null) {
                if (v.hasFocusable()) {
                    return;
                }
                v.setPressed(true);
            }
            this.setPressed(true);
            boolean longClickable = this.isLongClickable();
            Drawable d = selector.getCurrent();
            if (d != null && d instanceof TransitionDrawable) {
                if (longClickable) {
                    ((TransitionDrawable)d).startTransition(ViewConfiguration.getLongPressTimeout());
                } else {
                    ((TransitionDrawable)d).resetTransition();
                }
            }
            if (longClickable && !this.mDataChanged) {
                if (this.mPendingCheckForKeyLongPress == null) {
                    this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress();
                }
                this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
                this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
            }
        }
    }

    public void setScrollIndicators(View left, View right) {
        this.mScrollLeft = left;
        this.mScrollRight = right;
    }

    void updateSelectorState() {
        if (this.mSelector != null) {
            if (this.shouldShowSelector()) {
                this.mSelector.setState(this.getDrawableState());
            } else {
                this.mSelector.setState(STATESET_NOTHING);
            }
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    @SuppressLint(value={"Override"})
    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(extraSpace);
        }
        int enabledState = View.ENABLED_STATE_SET[0];
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        int enabledPos = -1;
        for (int i = state.length - 1; i >= 0; --i) {
            if (state[i] != enabledState) continue;
            enabledPos = i;
            break;
        }
        if (enabledPos >= 0) {
            System.arraycopy(state, enabledPos + 1, state, enabledPos, state.length - enabledPos - 1);
        }
        return state;
    }

    public boolean verifyDrawable(Drawable dr) {
        return this.mSelector == dr || super.verifyDrawable(dr);
    }

    @TargetApi(value=11)
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mSelector != null) {
            this.mSelector.jumpToCurrentState();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.addOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
        this.mIsAttached = true;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRecycler.clear();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.removeOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mFlingRunnable != null) {
            this.removeCallbacks(this.mFlingRunnable);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mClearScrollingCache != null) {
            this.removeCallbacks(this.mClearScrollingCache);
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset = null;
        }
        this.mIsAttached = false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        int touchMode;
        super.onWindowFocusChanged(hasWindowFocus);
        int n = touchMode = this.isInTouchMode() ? 0 : 1;
        if (!hasWindowFocus) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.endFling();
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.getScrollX() != 0) {
                    this.setScrollX(0);
                    this.finishGlows();
                    this.invalidate();
                }
            }
            if (touchMode == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else if (touchMode != this.mLastTouchMode && this.mLastTouchMode != -1) {
            if (touchMode == 1) {
                this.resurrectSelection();
            } else {
                this.hideSelector();
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
        }
        this.mLastTouchMode = touchMode;
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    boolean performLongPress(View child, int longPressPosition, long longPressId) {
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = super.showContextMenuForChild((View)this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenu(float x, float y, int metaState) {
        int position = this.pointToPosition((int)x, (int)y);
        if (position != -1) {
            long id2 = this.mAdapter.getItemId(position);
            View child = this.getChildAt(position - this.mFirstPosition);
            if (child != null) {
                this.mContextMenuInfo = this.createContextMenuInfo(child, position, id2);
                return super.showContextMenuForChild((View)this);
            }
        }
        return this.showContextMenu(x, y, metaState);
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.mAdapter.getItemId(longPressPosition);
            boolean handled = false;
            if (this.mOnItemLongClickListener != null) {
                handled = this.mOnItemLongClickListener.onItemLongClick(this, originalView, longPressPosition, longPressId);
            }
            if (!handled) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(longPressPosition - this.mFirstPosition), longPressPosition, longPressId);
                handled = super.showContextMenuForChild(originalView);
            }
            return handled;
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.isEnabled()) {
                    return true;
                }
                if (!this.isClickable() || !this.isPressed() || this.mSelectedPosition < 0 || this.mAdapter == null || this.mSelectedPosition >= this.mAdapter.getCount()) break;
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                if (view != null) {
                    this.performItemClick(view, this.mSelectedPosition, this.mSelectedColId);
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    public int pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public long pointToColId(int x, int y) {
        int position = this.pointToPosition(x, y);
        if (position >= 0) {
            return this.mAdapter.getItemId(position);
        }
        return Long.MIN_VALUE;
    }

    private boolean startScrollIfNeeded(int x) {
        boolean overscroll;
        int deltaX = x - this.mMotionX;
        int distance = Math.abs(deltaX);
        boolean bl = overscroll = this.getScrollX() != 0;
        if (overscroll || distance > this.mTouchSlop) {
            this.createScrollingCache();
            if (overscroll) {
                this.mTouchMode = 5;
                this.mMotionCorrection = 0;
            } else {
                this.mTouchMode = 3;
                this.mMotionCorrection = deltaX > 0 ? this.mTouchSlop : -this.mTouchSlop;
            }
            Handler handler = this.getHandler();
            if (handler != null) {
                handler.removeCallbacks((Runnable)this.mPendingCheckForLongPress);
            }
            this.setPressed(false);
            View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (motionView != null) {
                motionView.setPressed(false);
            }
            this.reportScrollStateChange(1);
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            this.scrollIfNeeded(x);
            return true;
        }
        return false;
    }

    private void scrollIfNeeded(int x) {
        int incrementalDeltaX;
        int rawDeltaX = x - this.mMotionX;
        int deltaX = rawDeltaX - this.mMotionCorrection;
        int n = incrementalDeltaX = this.mLastX != Integer.MIN_VALUE ? x - this.mLastX : deltaX;
        if (this.mTouchMode == 3) {
            if (x != this.mLastX) {
                ViewParent parent;
                if (Math.abs(rawDeltaX) > this.mTouchSlop && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                int motionIndex = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
                int motionViewPrevLeft = 0;
                View motionView = this.getChildAt(motionIndex);
                if (motionView != null) {
                    motionViewPrevLeft = motionView.getLeft();
                }
                boolean atEdge = false;
                if (incrementalDeltaX != 0) {
                    atEdge = this.trackMotionScroll(deltaX, incrementalDeltaX);
                }
                if ((motionView = this.getChildAt(motionIndex)) != null) {
                    int motionViewRealLeft = motionView.getLeft();
                    if (atEdge) {
                        int overscrollMode;
                        int overscroll = -incrementalDeltaX - (motionViewRealLeft - motionViewPrevLeft);
                        this.overScrollBy(overscroll, 0, this.getScrollX(), 0, 0, 0, this.mOverscrollDistance, 0, true);
                        if (Math.abs(this.mOverscrollDistance) == Math.abs(this.getScrollX()) && this.mVelocityTracker != null) {
                            this.mVelocityTracker.clear();
                        }
                        if ((overscrollMode = this.getOverScrollMode()) == 0 || overscrollMode == 1 && !this.contentFits()) {
                            this.mDirection = 0;
                            this.mTouchMode = 5;
                            if (rawDeltaX > 0) {
                                this.mEdgeGlowTop.onPull((float)overscroll / (float)this.getWidth());
                                if (!this.mEdgeGlowBottom.isFinished()) {
                                    this.mEdgeGlowBottom.onRelease();
                                }
                                this.invalidate();
                            } else if (rawDeltaX < 0) {
                                this.mEdgeGlowBottom.onPull((float)overscroll / (float)this.getWidth());
                                if (!this.mEdgeGlowTop.isFinished()) {
                                    this.mEdgeGlowTop.onRelease();
                                }
                                this.invalidate();
                            }
                        }
                    }
                    this.mMotionX = x;
                }
                this.mLastX = x;
            }
        } else if (this.mTouchMode == 5 && x != this.mLastX) {
            int newDirection;
            int oldScroll = this.getScrollX();
            int newScroll = oldScroll - incrementalDeltaX;
            int n2 = newDirection = x > this.mLastX ? 1 : -1;
            if (this.mDirection == 0) {
                this.mDirection = newDirection;
            }
            int overScrollDistance = -incrementalDeltaX;
            if (newScroll < 0 && oldScroll >= 0 || newScroll > 0 && oldScroll <= 0) {
                overScrollDistance = -oldScroll;
                incrementalDeltaX += overScrollDistance;
            } else {
                incrementalDeltaX = 0;
            }
            if (overScrollDistance != 0) {
                this.overScrollBy(overScrollDistance, 0, this.getScrollX(), 0, 0, 0, this.mOverscrollDistance, 0, true);
                int overscrollMode = this.getOverScrollMode();
                if (overscrollMode == 0 || overscrollMode == 1 && !this.contentFits()) {
                    if (rawDeltaX > 0) {
                        this.mEdgeGlowTop.onPull((float)overScrollDistance / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                        this.invalidate();
                    } else if (rawDeltaX < 0) {
                        this.mEdgeGlowBottom.onPull((float)overScrollDistance / (float)this.getWidth());
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                        this.invalidate();
                    }
                }
            }
            if (incrementalDeltaX != 0) {
                if (this.getScrollX() != 0) {
                    this.setScrollX(0);
                    this.invalidateParentIfNeeded();
                }
                this.trackMotionScroll(incrementalDeltaX, incrementalDeltaX);
                this.mTouchMode = 3;
                int motionPosition = this.findClosestMotionCol(x);
                this.mMotionCorrection = 0;
                View motionView = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalLeft = motionView != null ? motionView.getLeft() : 0;
                this.mMotionX = x;
                this.mMotionPosition = motionPosition;
            }
            this.mLastX = x;
            this.mDirection = newDirection;
        }
    }

    @TargetApi(value=11)
    protected void invalidateParentIfNeeded() {
        if (this.isHardwareAccelerated() && this.getParent() instanceof View) {
            ((View)this.getParent()).invalidate();
        }
    }

    public void onTouchModeChanged(boolean isInTouchMode) {
        if (isInTouchMode) {
            this.hideSelector();
            if (this.getWidth() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
            this.updateSelectorState();
        } else {
            int touchMode = this.mTouchMode;
            if (touchMode == 5 || touchMode == 6) {
                if (this.mFlingRunnable != null) {
                    this.mFlingRunnable.endFling();
                }
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.getScrollX() != 0) {
                    this.setScrollX(0);
                    this.finishGlows();
                    this.invalidate();
                }
            }
        }
    }

    @TargetApi(value=14)
    protected boolean performButtonActionOnTouchDown(MotionEvent event) {
        return Build.VERSION.SDK_INT >= 14 && (event.getButtonState() & 2) != 0 && this.showContextMenu(event.getX(), event.getY(), event.getMetaState());
    }

    @SuppressLint(value={"Override"})
    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (!this.mIsAttached) {
            return false;
        }
        int action = ev.getAction();
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(ev);
        block0 : switch (action & 0xFF) {
            case 0: {
                switch (this.mTouchMode) {
                    case 6: {
                        this.mFlingRunnable.endFling();
                        if (this.mPositionScroller != null) {
                            this.mPositionScroller.stop();
                        }
                        this.mTouchMode = 5;
                        this.mMotionY = (int)ev.getY();
                        this.mMotionX = this.mLastX = (int)ev.getX();
                        this.mMotionCorrection = 0;
                        this.mActivePointerId = ev.getPointerId(0);
                        this.mDirection = 0;
                        break;
                    }
                    default: {
                        this.mActivePointerId = ev.getPointerId(0);
                        int x = (int)ev.getX();
                        int y = (int)ev.getY();
                        int motionPosition = this.pointToPosition(x, y);
                        if (!this.mDataChanged) {
                            if (this.mTouchMode != 4 && motionPosition >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(motionPosition)) {
                                this.mTouchMode = 0;
                                if (this.mPendingCheckForTap == null) {
                                    this.mPendingCheckForTap = new CheckForTap();
                                }
                                this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                            } else if (this.mTouchMode == 4) {
                                this.createScrollingCache();
                                this.mTouchMode = 3;
                                this.mMotionCorrection = 0;
                                motionPosition = this.findMotionCol(x);
                                this.mFlingRunnable.flywheelTouch();
                            }
                        }
                        if (motionPosition >= 0) {
                            View v = this.getChildAt(motionPosition - this.mFirstPosition);
                            this.mMotionViewOriginalLeft = v.getLeft();
                        }
                        this.mMotionX = x;
                        this.mMotionY = y;
                        this.mMotionPosition = motionPosition;
                        this.mLastX = Integer.MIN_VALUE;
                        break;
                    }
                }
                if (!this.performButtonActionOnTouchDown(ev) || this.mTouchMode != 0) break;
                this.removeCallbacks(this.mPendingCheckForTap);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    pointerIndex = 0;
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                }
                int x = (int)ev.getX(pointerIndex);
                if (this.mDataChanged) {
                    this.layoutChildren();
                }
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.startScrollIfNeeded(x);
                        break block0;
                    }
                    case 3: 
                    case 5: {
                        this.scrollIfNeeded(x);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        boolean inList;
                        int motionPosition = this.mMotionPosition;
                        final View child = this.getChildAt(motionPosition - this.mFirstPosition);
                        float x = ev.getX();
                        boolean bl = inList = x > (float)this.mListPadding.left && x < (float)(this.getWidth() - this.mListPadding.right);
                        if (child != null && !child.hasFocusable() && inList) {
                            if (this.mTouchMode != 0) {
                                child.setPressed(false);
                            }
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            final PerformClick performClick = this.mPerformClick;
                            performClick.mClickMotionPosition = motionPosition;
                            performClick.rememberWindowAttachCount();
                            this.mResurrectToPosition = motionPosition;
                            if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                                Handler handler = this.getHandler();
                                if (handler != null) {
                                    handler.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                                }
                                this.mLayoutMode = 0;
                                if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                    Drawable d;
                                    this.mTouchMode = 1;
                                    this.setSelectedPositionInt(this.mMotionPosition);
                                    this.layoutChildren();
                                    child.setPressed(true);
                                    this.positionSelector(this.mMotionPosition, child);
                                    this.setPressed(true);
                                    if (this.mSelector != null && (d = this.mSelector.getCurrent()) != null && d instanceof TransitionDrawable) {
                                        ((TransitionDrawable)d).resetTransition();
                                    }
                                    if (this.mTouchModeReset != null) {
                                        this.removeCallbacks(this.mTouchModeReset);
                                    }
                                    this.mTouchModeReset = new Runnable(){

                                        @Override
                                        public void run() {
                                            AbsHListView.this.mTouchMode = -1;
                                            child.setPressed(false);
                                            AbsHListView.this.setPressed(false);
                                            if (!AbsHListView.this.mDataChanged) {
                                                performClick.run();
                                            }
                                        }
                                    };
                                    this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                                } else {
                                    this.mTouchMode = -1;
                                    this.updateSelectorState();
                                }
                                return true;
                            }
                            if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                performClick.run();
                            }
                        }
                        this.mTouchMode = -1;
                        this.updateSelectorState();
                        break;
                    }
                    case 3: {
                        int childCount = this.getChildCount();
                        if (childCount > 0) {
                            int firstChildLeft = this.getChildAt(0).getLeft();
                            int lastChildRight = this.getChildAt(childCount - 1).getRight();
                            int contentLeft = this.mListPadding.left;
                            int contentRight = this.getWidth() - this.mListPadding.right;
                            if (this.mFirstPosition == 0 && firstChildLeft >= contentLeft && this.mFirstPosition + childCount < this.mItemCount && lastChildRight <= this.getWidth() - contentRight) {
                                this.mTouchMode = -1;
                                this.reportScrollStateChange(0);
                                break;
                            }
                            VelocityTracker velocityTracker = this.mVelocityTracker;
                            velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                            int initialVelocity = (int)(velocityTracker.getXVelocity(this.mActivePointerId) * this.mVelocityScale);
                            if (!(Math.abs(initialVelocity) <= this.mMinimumVelocity || this.mFirstPosition == 0 && firstChildLeft == contentLeft - this.mOverscrollDistance || this.mFirstPosition + childCount == this.mItemCount && lastChildRight == contentRight + this.mOverscrollDistance)) {
                                if (this.mFlingRunnable == null) {
                                    this.mFlingRunnable = new FlingRunnable();
                                }
                                this.reportScrollStateChange(2);
                                this.mFlingRunnable.start(-initialVelocity);
                                break;
                            }
                            this.mTouchMode = -1;
                            this.reportScrollStateChange(0);
                            if (this.mFlingRunnable != null) {
                                this.mFlingRunnable.endFling();
                            }
                            if (this.mPositionScroller == null) break;
                            this.mPositionScroller.stop();
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    case 5: {
                        if (this.mFlingRunnable == null) {
                            this.mFlingRunnable = new FlingRunnable();
                        }
                        VelocityTracker velocityTracker = this.mVelocityTracker;
                        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        int initialVelocity = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                        this.reportScrollStateChange(2);
                        if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                            this.mFlingRunnable.startOverfling(-initialVelocity);
                            break;
                        }
                        this.mFlingRunnable.startSpringback();
                        break;
                    }
                }
                this.setPressed(false);
                if (this.mEdgeGlowTop != null) {
                    this.mEdgeGlowTop.onRelease();
                    this.mEdgeGlowBottom.onRelease();
                }
                this.invalidate();
                Handler handler = this.getHandler();
                if (handler != null) {
                    handler.removeCallbacks((Runnable)this.mPendingCheckForLongPress);
                }
                this.recycleVelocityTracker();
                this.mActivePointerId = -1;
                break;
            }
            case 3: {
                switch (this.mTouchMode) {
                    case 5: {
                        if (this.mFlingRunnable == null) {
                            this.mFlingRunnable = new FlingRunnable();
                        }
                        this.mFlingRunnable.startSpringback();
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        this.mTouchMode = -1;
                        this.setPressed(false);
                        View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                        if (motionView != null) {
                            motionView.setPressed(false);
                        }
                        this.clearScrollingCache();
                        Handler handler = this.getHandler();
                        if (handler != null) {
                            handler.removeCallbacks((Runnable)this.mPendingCheckForLongPress);
                        }
                        this.recycleVelocityTracker();
                    }
                }
                if (this.mEdgeGlowTop != null) {
                    this.mEdgeGlowTop.onRelease();
                    this.mEdgeGlowBottom.onRelease();
                }
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int x = this.mMotionX;
                int y = this.mMotionY;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalLeft = v.getLeft();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastX = x;
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                int id2 = ev.getPointerId(index);
                int x = (int)ev.getX(index);
                int y = (int)ev.getY(index);
                this.mMotionCorrection = 0;
                this.mActivePointerId = id2;
                this.mMotionX = x;
                this.mMotionY = y;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalLeft = v.getLeft();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastX = x;
                break;
            }
        }
        return true;
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (this.getScrollX() != scrollX) {
            this.onScrollChanged(scrollX, this.getScrollY(), this.getScrollX(), this.getScrollY());
            this.setScrollX(scrollX);
            this.invalidateParentIfNeeded();
            this.awakenScrollBars();
        }
    }

    @TargetApi(value=12)
    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    int delta;
                    float hscroll;
                    if (this.mTouchMode != -1 || (hscroll = event.getAxisValue(10)) == 0.0f || this.trackMotionScroll(delta = (int)(hscroll * this.getHorizontalScrollFactor()), delta)) break;
                    return true;
                }
            }
        }
        return super.onGenericMotionEvent(event);
    }

    protected float getHorizontalScrollFactor() {
        if (this.mHorizontalScrollFactor == 0.0f) {
            TypedValue outValue = new TypedValue();
            boolean success = this.getContext().getTheme().resolveAttribute(R.attr.hlv_listPreferredItemWidth, outValue, true);
            if (success) {
                this.mHorizontalScrollFactor = outValue.getDimension(this.getContext().getResources().getDisplayMetrics());
            } else {
                throw new IllegalStateException("Expected theme to define hlv_listPreferredItemWidth.");
            }
        }
        return this.mHorizontalScrollFactor;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int height;
            int bottomPadding;
            int topPadding;
            int restoreCount;
            int scrollX = this.getScrollX();
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                topPadding = this.mListPadding.top + this.mGlowPaddingTop;
                bottomPadding = this.mListPadding.bottom + this.mGlowPaddingBottom;
                height = this.getHeight() - topPadding - bottomPadding;
                int edgeX = Math.min(0, scrollX + this.mFirstPositionDistanceGuess);
                canvas.rotate(-90.0f);
                canvas.translate((float)(-this.getHeight() + topPadding), (float)edgeX);
                this.mEdgeGlowTop.setSize(height, height);
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.invalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                topPadding = this.mListPadding.left + this.mGlowPaddingTop;
                bottomPadding = this.mListPadding.right + this.mGlowPaddingBottom;
                height = this.getHeight() - topPadding - bottomPadding;
                int width = this.getWidth();
                int edgeX = Math.max(width, scrollX + this.mLastPositionDistanceGuess);
                canvas.rotate(90.0f);
                canvas.translate((float)(-topPadding), (float)(-edgeX));
                this.mEdgeGlowBottom.setSize(height, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.invalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    public void setOverScrollEffectPadding(int topPadding, int bottomPadding) {
        this.mGlowPaddingTop = topPadding;
        this.mGlowPaddingBottom = bottomPadding;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (!this.mIsAttached) {
            return false;
        }
        block0 : switch (action & 0xFF) {
            case 0: {
                int touchMode = this.mTouchMode;
                if (touchMode == 6 || touchMode == 5) {
                    this.mMotionCorrection = 0;
                    return true;
                }
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                int motionPosition = this.findMotionCol(x);
                if (touchMode != 4 && motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalLeft = v.getLeft();
                    this.mMotionX = x;
                    this.mMotionY = y;
                    this.mMotionPosition = motionPosition;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastX = Integer.MIN_VALUE;
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                if (touchMode != 4) break;
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                        if (pointerIndex == -1) {
                            pointerIndex = 0;
                            this.mActivePointerId = ev.getPointerId(pointerIndex);
                        }
                        int x = (int)ev.getX(pointerIndex);
                        this.initVelocityTrackerIfNotExists();
                        this.mVelocityTracker.addMovement(ev);
                        if (!this.startScrollIfNeeded(x)) break block0;
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                this.reportScrollStateChange(0);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
        }
        return false;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mMotionX = (int)ev.getX(newPointerIndex);
            this.mMotionY = (int)ev.getY(newPointerIndex);
            this.mMotionCorrection = 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    public void addTouchables(ArrayList<View> views) {
        int count = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (adapter.isEnabled(firstPosition + i)) {
                views.add(child);
            }
            child.addTouchables(views);
        }
    }

    void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged(this, newState);
        }
    }

    public void setFriction(float friction) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.mFlingRunnable.mScroller.setFriction(friction);
    }

    public void setVelocityScale(float scale) {
        this.mVelocityScale = scale;
    }

    public void smoothScrollToPosition(int position) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(position);
    }

    public void smoothScrollToPositionFromLeft(int position, int offset, int duration) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset, duration);
    }

    public void smoothScrollToPositionFromLeft(int position, int offset) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset);
    }

    public void smoothScrollToPosition(int position, int boundPosition) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(position, boundPosition);
    }

    public void smoothScrollBy(int distance, int duration) {
        this.smoothScrollBy(distance, duration, false);
    }

    public void smoothScrollBy(int distance, int duration, boolean linear) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        int firstPos = this.mFirstPosition;
        int childCount = this.getChildCount();
        int lastPos = firstPos + childCount;
        int leftLimit = this.getPaddingLeft();
        int rightLimit = this.getWidth() - this.getPaddingRight();
        if (distance == 0 || this.mItemCount == 0 || childCount == 0 || firstPos == 0 && this.getChildAt(0).getLeft() == leftLimit && distance < 0 || lastPos == this.mItemCount && this.getChildAt(childCount - 1).getRight() == rightLimit && distance > 0) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
        } else {
            this.reportScrollStateChange(2);
            this.mFlingRunnable.startScroll(distance, duration, linear);
        }
    }

    protected void smoothScrollByOffset(int position) {
        View child;
        int index = -1;
        if (position < 0) {
            index = this.getFirstVisiblePosition();
        } else if (position > 0) {
            index = this.getLastVisiblePosition();
        }
        if (index > -1 && (child = this.getChildAt(index - this.getFirstVisiblePosition())) != null) {
            Rect visibleRect = new Rect();
            if (child.getGlobalVisibleRect(visibleRect)) {
                int childRectArea = child.getWidth() * child.getHeight();
                int visibleRectArea = visibleRect.width() * visibleRect.height();
                float visibleArea = (float)visibleRectArea / (float)childRectArea;
                float visibleThreshold = 0.75f;
                if (position < 0 && visibleArea < 0.75f) {
                    ++index;
                } else if (position > 0 && visibleArea < 0.75f) {
                    --index;
                }
            }
            this.smoothScrollToPosition(Math.max(0, Math.min(this.getCount(), index + position)));
        }
    }

    private void createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted && !this.isHardwareAccelerated()) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingActive = true;
            this.mCachingStarted = true;
        }
    }

    private void clearScrollingCache() {
        if (!this.isHardwareAccelerated()) {
            if (this.mClearScrollingCache == null) {
                this.mClearScrollingCache = new Runnable(){

                    @Override
                    public void run() {
                        if (AbsHListView.this.mCachingStarted) {
                            AbsHListView.this.mCachingActive = false;
                            AbsHListView.this.mCachingStarted = false;
                            AbsHListView.this.setChildrenDrawnWithCacheEnabled(false);
                            if ((AbsHListView.this.getPersistentDrawingCache() & 2) == 0) {
                                AbsHListView.this.setChildrenDrawingCacheEnabled(false);
                            }
                            if (!AbsHListView.this.isAlwaysDrawnWithCacheEnabled()) {
                                AbsHListView.this.invalidate();
                            }
                        }
                    }
                };
            }
            this.post(this.mClearScrollingCache);
        }
    }

    boolean trackMotionScroll(int deltaX, int incrementalDeltaX) {
        int childIndex;
        int absIncrementalDeltaX;
        int i;
        boolean cannotScrollLeft;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        int firstLeft = this.getChildAt(0).getLeft();
        int lastRight = this.getChildAt(childCount - 1).getRight();
        Rect listPadding = this.mListPadding;
        int effectivePaddingLeft = 0;
        int effectivePaddingRight = 0;
        int spaceBefore = effectivePaddingLeft - firstLeft;
        int end = this.getWidth() - effectivePaddingRight;
        int spaceAfter = lastRight - end;
        int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        deltaX = deltaX < 0 ? Math.max(-(width - 1), deltaX) : Math.min(width - 1, deltaX);
        incrementalDeltaX = incrementalDeltaX < 0 ? Math.max(-(width - 1), incrementalDeltaX) : Math.min(width - 1, incrementalDeltaX);
        int firstPosition = this.mFirstPosition;
        this.mFirstPositionDistanceGuess = firstPosition == 0 ? firstLeft - listPadding.left : (this.mFirstPositionDistanceGuess += incrementalDeltaX);
        this.mLastPositionDistanceGuess = firstPosition + childCount == this.mItemCount ? lastRight + listPadding.right : (this.mLastPositionDistanceGuess += incrementalDeltaX);
        boolean cannotScrollRight = firstPosition == 0 && firstLeft >= listPadding.left && incrementalDeltaX >= 0;
        boolean bl = cannotScrollLeft = firstPosition + childCount == this.mItemCount && lastRight <= this.getWidth() - listPadding.right && incrementalDeltaX <= 0;
        if (cannotScrollRight || cannotScrollLeft) {
            return incrementalDeltaX != 0;
        }
        boolean down = incrementalDeltaX < 0;
        boolean inTouchMode = this.isInTouchMode();
        if (inTouchMode) {
            this.hideSelector();
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        int start = 0;
        int count = 0;
        if (down) {
            View child;
            int top = -incrementalDeltaX;
            for (i = 0; i < childCount && (child = this.getChildAt(i)).getRight() < top; ++i) {
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                this.mRecycler.addScrapView(child, position);
            }
        } else {
            View child;
            int bottom = this.getWidth() - incrementalDeltaX;
            for (i = childCount - 1; i >= 0 && (child = this.getChildAt(i)).getLeft() > bottom; --i) {
                start = i;
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                this.mRecycler.addScrapView(child, position);
            }
        }
        this.mMotionViewNewLeft = this.mMotionViewOriginalLeft + deltaX;
        this.mBlockLayoutRequests = true;
        if (count > 0) {
            this.detachViewsFromParent(start, count);
            this.mRecycler.removeSkippedScrap();
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        this.offsetChildrenLeftAndRight(incrementalDeltaX);
        if (down) {
            this.mFirstPosition += count;
        }
        if (spaceBefore < (absIncrementalDeltaX = Math.abs(incrementalDeltaX)) || spaceAfter < absIncrementalDeltaX) {
            this.fillGap(down);
        }
        if (!inTouchMode && this.mSelectedPosition != -1) {
            childIndex = this.mSelectedPosition - this.mFirstPosition;
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                this.positionSelector(this.mSelectedPosition, this.getChildAt(childIndex));
            }
        } else if (this.mSelectorPosition != -1) {
            childIndex = this.mSelectorPosition - this.mFirstPosition;
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                this.positionSelector(-1, this.getChildAt(childIndex));
            }
        } else {
            this.mSelectorRect.setEmpty();
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        return false;
    }

    public void offsetChildrenLeftAndRight(int offset) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = this.getChildAt(i);
            v.offsetLeftAndRight(offset);
        }
    }

    protected int getHeaderViewsCount() {
        return 0;
    }

    protected int getFooterViewsCount() {
        return 0;
    }

    protected abstract void fillGap(boolean var1);

    protected void hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedLeft = 0;
        }
    }

    protected int reconcileSelectedPosition() {
        int position = this.mSelectedPosition;
        if (position < 0) {
            position = this.mResurrectToPosition;
        }
        position = Math.max(0, position);
        position = Math.min(position, this.mItemCount - 1);
        return position;
    }

    protected abstract int findMotionCol(int var1);

    protected int findClosestMotionCol(int x) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int motionCol = this.findMotionCol(x);
        return motionCol != -1 ? motionCol : this.mFirstPosition + childCount - 1;
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    protected boolean resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0 && this.resurrectSelection()) {
            this.updateSelectorState();
            return true;
        }
        return false;
    }

    public abstract void setSelectionInt(int var1);

    boolean resurrectSelection() {
        int selectedPos;
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return false;
        }
        int selectedLeft = 0;
        int childrenLeft = this.mListPadding.left;
        int childrenRight = this.getRight() - this.getLeft() - this.mListPadding.right;
        int firstPosition = this.mFirstPosition;
        int toPosition = this.mResurrectToPosition;
        boolean down = true;
        if (toPosition >= firstPosition && toPosition < firstPosition + childCount) {
            selectedPos = toPosition;
            View selected = this.getChildAt(selectedPos - this.mFirstPosition);
            selectedLeft = selected.getLeft();
            int selectedRight = selected.getRight();
            if (selectedLeft < childrenLeft) {
                selectedLeft = childrenLeft + this.getHorizontalFadingEdgeLength();
            } else if (selectedRight > childrenRight) {
                selectedLeft = childrenRight - selected.getMeasuredWidth() - this.getHorizontalFadingEdgeLength();
            }
        } else if (toPosition < firstPosition) {
            selectedPos = firstPosition;
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                int left = v.getLeft();
                if (i == 0) {
                    selectedLeft = left;
                    if (firstPosition > 0 || left < childrenLeft) {
                        childrenLeft += this.getHorizontalFadingEdgeLength();
                    }
                }
                if (left < childrenLeft) continue;
                selectedPos = firstPosition + i;
                selectedLeft = left;
                break;
            }
        } else {
            int itemCount = this.mItemCount;
            down = false;
            selectedPos = firstPosition + childCount - 1;
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                int left = v.getLeft();
                int right = v.getRight();
                if (i == childCount - 1) {
                    selectedLeft = left;
                    if (firstPosition + childCount < itemCount || right > childrenRight) {
                        childrenRight -= this.getHorizontalFadingEdgeLength();
                    }
                }
                if (right > childrenRight) continue;
                selectedPos = firstPosition + i;
                selectedLeft = left;
                break;
            }
        }
        this.mResurrectToPosition = -1;
        this.removeCallbacks(this.mFlingRunnable);
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.mTouchMode = -1;
        this.clearScrollingCache();
        this.mSpecificLeft = selectedLeft;
        selectedPos = this.lookForSelectablePosition(selectedPos, down);
        if (selectedPos >= firstPosition && selectedPos <= this.getLastVisiblePosition()) {
            this.mLayoutMode = 4;
            this.updateSelectorState();
            this.setSelectionInt(selectedPos);
            this.invokeOnItemScrollListener();
        } else {
            selectedPos = -1;
        }
        this.reportScrollStateChange(0);
        return selectedPos >= 0;
    }

    void confirmCheckedPositionsById() {
        this.mCheckStates.clear();
        boolean checkedCountChanged = false;
        for (int checkedIndex = 0; checkedIndex < this.mCheckedIdStates.size(); ++checkedIndex) {
            int lastPos;
            long lastPosId;
            long id2 = this.mCheckedIdStates.keyAt(checkedIndex);
            if (id2 != (lastPosId = this.mAdapter.getItemId(lastPos = ((Integer)this.mCheckedIdStates.valueAt(checkedIndex)).intValue()))) {
                int start = Math.max(0, lastPos - 20);
                int end = Math.min(lastPos + 20, this.mItemCount);
                boolean found = false;
                for (int searchPos = start; searchPos < end; ++searchPos) {
                    long searchId = this.mAdapter.getItemId(searchPos);
                    if (id2 != searchId) continue;
                    found = true;
                    this.mCheckStates.put(searchPos, (Object)true);
                    this.mCheckedIdStates.setValueAt(checkedIndex, (Object)searchPos);
                    break;
                }
                if (found) continue;
                this.mCheckedIdStates.delete(id2);
                --checkedIndex;
                --this.mCheckedItemCount;
                checkedCountChanged = true;
                continue;
            }
            this.mCheckStates.put(lastPos, (Object)true);
        }
        if (checkedCountChanged && this.mChoiceActionMode != null && Build.VERSION.SDK_INT > 11) {
            ((ActionMode)this.mChoiceActionMode).invalidate();
        }
    }

    @Override
    protected void handleDataChanged() {
        int count = this.mItemCount;
        int lastHandledItemCount = this.mLastHandledItemCount;
        this.mLastHandledItemCount = this.mItemCount;
        if (this.mChoiceMode != 0 && this.mAdapter != null && this.mAdapter.hasStableIds()) {
            this.confirmCheckedPositionsById();
        }
        this.mRecycler.clearTransientStateViews();
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                this.mPendingSync = null;
                if (this.mTranscriptMode == 2) {
                    this.mLayoutMode = 3;
                    return;
                }
                if (this.mTranscriptMode == 1) {
                    int lastRight;
                    if (this.mForceTranscriptScroll) {
                        this.mForceTranscriptScroll = false;
                        this.mLayoutMode = 3;
                        return;
                    }
                    int childCount = this.getChildCount();
                    int listRight = this.getWidth() - this.getPaddingRight();
                    View lastChild = this.getChildAt(childCount - 1);
                    int n = lastRight = lastChild != null ? lastChild.getBottom() : listRight;
                    if (this.mFirstPosition + childCount >= lastHandledItemCount && lastRight <= listRight) {
                        this.mLayoutMode = 3;
                        return;
                    }
                    this.awakenScrollBars();
                }
                switch (this.mSyncMode) {
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                            return;
                        }
                        newPos = this.findSyncPosition();
                        if (newPos < 0 || (selectablePos = this.lookForSelectablePosition(newPos, true)) != newPos) break;
                        this.mSyncPosition = newPos;
                        this.mLayoutMode = this.mSyncWidth == (long)this.getWidth() ? 5 : 2;
                        this.setNextSelectedPositionInt(newPos);
                        return;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
                selectablePos = this.lookForSelectablePosition(newPos, false);
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromRight ? 3 : 1;
        this.mSelectedPosition = -1;
        this.mSelectedColId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedColId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mSelectorPosition = -1;
        this.checkSelectionChanged();
    }

    public static int getDistance(Rect source, Rect dest, int direction) {
        int dY;
        int dX;
        int sY;
        int sX;
        switch (direction) {
            case 66: {
                sX = source.right;
                sY = source.top + source.height() / 2;
                dX = dest.left;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 130: {
                sX = source.left + source.width() / 2;
                sY = source.bottom;
                dX = dest.left + dest.width() / 2;
                dY = dest.top;
                break;
            }
            case 17: {
                sX = source.left;
                sY = source.top + source.height() / 2;
                dX = dest.right;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 33: {
                sX = source.left + source.width() / 2;
                sY = source.top;
                dX = dest.left + dest.width() / 2;
                dY = dest.bottom;
                break;
            }
            case 1: 
            case 2: {
                sX = source.right + source.width() / 2;
                sY = source.top + source.height() / 2;
                dX = dest.left + dest.width() / 2;
                dY = dest.top + dest.height() / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
        }
        int deltaX = dX - sX;
        int deltaY = dY - sY;
        return deltaY * deltaY + deltaX * deltaX;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return null;
    }

    public boolean checkInputConnectionProxy(View view) {
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -1, 0);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setTranscriptMode(int mode) {
        this.mTranscriptMode = mode;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public void setCacheColorHint(int color2) {
        if (color2 != this.mCacheColorHint) {
            this.mCacheColorHint = color2;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(color2);
            }
            this.mRecycler.setCacheColorHint(color2);
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    @SuppressLint(value={"NewApi"})
    public void reclaimViews(List<View> views) {
        int childCount = this.getChildCount();
        RecyclerListener listener2 = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp == null || !this.mRecycler.shouldRecycleViewType(lp.viewType)) continue;
            views.add(child);
            if (Build.VERSION.SDK_INT >= 14) {
                child.setAccessibilityDelegate(null);
            }
            if (listener2 == null) continue;
            listener2.onMovedToScrapHeap(child);
        }
        this.mRecycler.reclaimScrapViews(views);
        this.removeAllViewsInLayout();
    }

    private void finishGlows() {
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.finish();
            this.mEdgeGlowBottom.finish();
        }
    }

    protected void setVisibleRangeHint(int start, int end) {
    }

    public void setRecyclerListener(RecyclerListener listener2) {
        this.mRecycler.mRecyclerListener = listener2;
    }

    static View retrieveFromScrap(ArrayList<View> scrapViews, int position) {
        int size = scrapViews.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                View view = scrapViews.get(i);
                if (((LayoutParams)view.getLayoutParams()).scrappedFromPosition != position) continue;
                scrapViews.remove(i);
                return view;
            }
            return scrapViews.remove(size - 1);
        }
        return null;
    }

    public void postOnAnimation(Runnable action) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.postOnAnimation(action);
        } else {
            this.post(action);
        }
    }

    public class RecycleBin {
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews = new View[0];
        private ArrayList<View>[] mScrapViews;
        private int mViewTypeCount;
        private ArrayList<View> mCurrentScrap;
        private ArrayList<View> mSkippedScrap;
        private SparseArrayCompat<View> mTransientStateViews;

        public void setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] scrapViews = new ArrayList[viewTypeCount];
            for (int i = 0; i < viewTypeCount; ++i) {
                scrapViews[i] = new ArrayList();
            }
            this.mViewTypeCount = viewTypeCount;
            this.mCurrentScrap = scrapViews[0];
            this.mScrapViews = scrapViews;
        }

        public void markChildrenDirty() {
            int i;
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i2 = 0; i2 < scrapCount; ++i2) {
                    scrap.get(i2).forceLayout();
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).forceLayout();
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                int count = this.mTransientStateViews.size();
                for (i = 0; i < count; ++i) {
                    ((View)this.mTransientStateViews.valueAt(i)).forceLayout();
                }
            }
        }

        public boolean shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        public void clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    AbsHListView.this.removeDetachedView(scrap.remove(scrapCount - 1 - i), false);
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        AbsHListView.this.removeDetachedView(scrap.remove(scrapCount - 1 - j), false);
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                this.mTransientStateViews.clear();
            }
        }

        public void fillActiveViews(int childCount, int firstActivePosition) {
            if (this.mActiveViews.length < childCount) {
                this.mActiveViews = new View[childCount];
            }
            this.mFirstActivePosition = firstActivePosition;
            View[] activeViews = this.mActiveViews;
            for (int i = 0; i < childCount; ++i) {
                View child = AbsHListView.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp == null || lp.viewType == -2) continue;
                activeViews[i] = child;
            }
        }

        public View getActiveView(int position) {
            int index = position - this.mFirstActivePosition;
            View[] activeViews = this.mActiveViews;
            if (index >= 0 && index < activeViews.length) {
                View match = activeViews[index];
                activeViews[index] = null;
                return match;
            }
            return null;
        }

        View getTransientStateView(int position) {
            if (this.mTransientStateViews == null) {
                return null;
            }
            int index = this.mTransientStateViews.indexOfKey(position);
            if (index < 0) {
                return null;
            }
            View result = (View)this.mTransientStateViews.valueAt(index);
            this.mTransientStateViews.removeAt(index);
            return result;
        }

        void clearTransientStateViews() {
            if (this.mTransientStateViews != null) {
                this.mTransientStateViews.clear();
            }
        }

        View getScrapView(int position) {
            if (this.mViewTypeCount == 1) {
                return AbsHListView.retrieveFromScrap(this.mCurrentScrap, position);
            }
            int whichScrap = AbsHListView.this.mAdapter.getItemViewType(position);
            if (whichScrap >= 0 && whichScrap < this.mScrapViews.length) {
                return AbsHListView.retrieveFromScrap(this.mScrapViews[whichScrap], position);
            }
            return null;
        }

        @SuppressLint(value={"NewApi"})
        public void addScrapView(View scrap, int position) {
            boolean scrapHasTransientState;
            LayoutParams lp = (LayoutParams)scrap.getLayoutParams();
            if (lp == null) {
                return;
            }
            lp.scrappedFromPosition = position;
            int viewType = lp.viewType;
            boolean bl = scrapHasTransientState = Build.VERSION.SDK_INT >= 16 ? scrap.hasTransientState() : false;
            if (!this.shouldRecycleViewType(viewType) || scrapHasTransientState) {
                if (viewType != -2 || scrapHasTransientState) {
                    if (this.mSkippedScrap == null) {
                        this.mSkippedScrap = new ArrayList();
                    }
                    this.mSkippedScrap.add(scrap);
                }
                if (scrapHasTransientState) {
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArrayCompat();
                    }
                    scrap.onStartTemporaryDetach();
                    this.mTransientStateViews.put(position, (Object)scrap);
                }
                return;
            }
            scrap.onStartTemporaryDetach();
            if (this.mViewTypeCount == 1) {
                this.mCurrentScrap.add(scrap);
            } else {
                this.mScrapViews[viewType].add(scrap);
            }
            if (Build.VERSION.SDK_INT >= 14) {
                scrap.setAccessibilityDelegate(null);
            }
            if (this.mRecyclerListener != null) {
                this.mRecyclerListener.onMovedToScrapHeap(scrap);
            }
        }

        public void removeSkippedScrap() {
            if (this.mSkippedScrap == null) {
                return;
            }
            int count = this.mSkippedScrap.size();
            for (int i = 0; i < count; ++i) {
                AbsHListView.this.removeDetachedView(this.mSkippedScrap.get(i), false);
            }
            this.mSkippedScrap.clear();
        }

        @SuppressLint(value={"NewApi"})
        public void scrapActiveViews() {
            View[] activeViews = this.mActiveViews;
            boolean hasListener = this.mRecyclerListener != null;
            boolean multipleScraps = this.mViewTypeCount > 1;
            ArrayList<View> scrapViews = this.mCurrentScrap;
            int count = activeViews.length;
            for (int i = count - 1; i >= 0; --i) {
                boolean scrapHasTransientState;
                View victim = activeViews[i];
                if (victim == null) continue;
                LayoutParams lp = (LayoutParams)victim.getLayoutParams();
                int whichScrap = lp.viewType;
                activeViews[i] = null;
                boolean bl = scrapHasTransientState = Build.VERSION.SDK_INT >= 16 ? victim.hasTransientState() : false;
                if (!this.shouldRecycleViewType(whichScrap) || scrapHasTransientState) {
                    if (whichScrap != -2 || scrapHasTransientState) {
                        AbsHListView.this.removeDetachedView(victim, false);
                    }
                    if (!scrapHasTransientState) continue;
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArrayCompat();
                    }
                    this.mTransientStateViews.put(this.mFirstActivePosition + i, (Object)victim);
                    continue;
                }
                if (multipleScraps) {
                    scrapViews = this.mScrapViews[whichScrap];
                }
                victim.onStartTemporaryDetach();
                lp.scrappedFromPosition = this.mFirstActivePosition + i;
                scrapViews.add(victim);
                if (Build.VERSION.SDK_INT >= 14) {
                    victim.setAccessibilityDelegate(null);
                }
                if (!hasListener) continue;
                this.mRecyclerListener.onMovedToScrapHeap(victim);
            }
            this.pruneScrapViews();
        }

        @SuppressLint(value={"NewApi"})
        private void pruneScrapViews() {
            int i;
            int maxViews = this.mActiveViews.length;
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                int extras = size - maxViews;
                --size;
                for (int j = 0; j < extras; ++j) {
                    AbsHListView.this.removeDetachedView(scrapPile.remove(size--), false);
                }
            }
            if (this.mTransientStateViews != null) {
                for (i = 0; i < this.mTransientStateViews.size(); ++i) {
                    View v = (View)this.mTransientStateViews.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.mTransientStateViews.removeAt(i);
                    --i;
                }
            }
        }

        void reclaimScrapViews(List<View> views) {
            if (this.mViewTypeCount == 1) {
                views.addAll(this.mCurrentScrap);
            } else {
                int viewTypeCount = this.mViewTypeCount;
                ArrayList<View>[] scrapViews = this.mScrapViews;
                for (int i = 0; i < viewTypeCount; ++i) {
                    ArrayList<View> scrapPile = scrapViews[i];
                    views.addAll(scrapPile);
                }
            }
        }

        void setCacheColorHint(int color2) {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    scrap.get(i).setDrawingCacheBackgroundColor(color2);
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).setDrawingCacheBackgroundColor(color2);
                    }
                }
            }
            for (View victim : this.mActiveViews) {
                if (victim == null) continue;
                victim.setDrawingCacheBackgroundColor(color2);
            }
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int viewType;
        public boolean recycledHeaderFooter;
        public boolean forceAdd;
        public int scrappedFromPosition;
        public long itemId = -1L;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, int viewType) {
            super(w, h);
            this.viewType = viewType;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public class AdapterDataSetObserver
    extends AdapterView.AdapterDataSetObserver {
        public AdapterDataSetObserver() {
            super(AbsHListView.this);
        }

        @Override
        public void onChanged() {
            super.onChanged();
        }

        @Override
        public void onInvalidated() {
            super.onInvalidated();
        }
    }

    public class PositionScroller
    implements Runnable {
        private static final int SCROLL_DURATION = 200;
        private static final int MOVE_DOWN_POS = 1;
        private static final int MOVE_UP_POS = 2;
        private static final int MOVE_DOWN_BOUND = 3;
        private static final int MOVE_UP_BOUND = 4;
        private static final int MOVE_OFFSET = 5;
        private int mMode;
        private int mTargetPos;
        private int mBoundPos;
        private int mLastSeenPos;
        private int mScrollDuration;
        private final int mExtraScroll;
        private int mOffsetFromLeft;

        PositionScroller() {
            this.mExtraScroll = ViewConfiguration.get((Context)AbsHListView.this.getContext()).getScaledFadingEdgeLength();
        }

        void start(final int position) {
            int viewTravelCount;
            this.stop();
            if (AbsHListView.this.mDataChanged) {
                AbsHListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.start(position);
                    }
                };
                return;
            }
            int childCount = AbsHListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = AbsHListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(AbsHListView.this.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                viewTravelCount = firstPos - clampedPosition + 1;
                this.mMode = 2;
            } else if (clampedPosition > lastPos) {
                viewTravelCount = clampedPosition - lastPos + 1;
                this.mMode = 1;
            } else {
                this.scrollToVisible(clampedPosition, -1, 200);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            AbsHListView.this.postOnAnimation(this);
        }

        void start(final int position, final int boundPosition) {
            int viewTravelCount;
            this.stop();
            if (boundPosition == -1) {
                this.start(position);
                return;
            }
            if (AbsHListView.this.mDataChanged) {
                AbsHListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.start(position, boundPosition);
                    }
                };
                return;
            }
            int childCount = AbsHListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = AbsHListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(AbsHListView.this.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                int boundPosFromLast = lastPos - boundPosition;
                if (boundPosFromLast < 1) {
                    return;
                }
                int boundTravel = boundPosFromLast - 1;
                int posTravel = firstPos - clampedPosition + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 4;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 2;
                }
            } else if (clampedPosition > lastPos) {
                int boundPosFromFirst = boundPosition - firstPos;
                if (boundPosFromFirst < 1) {
                    return;
                }
                int boundTravel = boundPosFromFirst - 1;
                int posTravel = clampedPosition - lastPos + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 3;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 1;
                }
            } else {
                this.scrollToVisible(clampedPosition, boundPosition, 200);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = boundPosition;
            this.mLastSeenPos = -1;
            AbsHListView.this.postOnAnimation(this);
        }

        void startWithOffset(int position, int offset) {
            this.startWithOffset(position, offset, 200);
        }

        void startWithOffset(final int position, int offset, final int duration) {
            int viewTravelCount;
            this.stop();
            if (AbsHListView.this.mDataChanged) {
                final int postOffset = offset;
                AbsHListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.startWithOffset(position, postOffset, duration);
                    }
                };
                return;
            }
            int childCount = AbsHListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            this.mTargetPos = Math.max(0, Math.min(AbsHListView.this.getCount() - 1, position));
            this.mOffsetFromLeft = offset += AbsHListView.this.getPaddingLeft();
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.mMode = 5;
            int firstPos = AbsHListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            if (this.mTargetPos < firstPos) {
                viewTravelCount = firstPos - this.mTargetPos;
            } else if (this.mTargetPos > lastPos) {
                viewTravelCount = this.mTargetPos - lastPos;
            } else {
                int targetLeft = AbsHListView.this.getChildAt(this.mTargetPos - firstPos).getLeft();
                AbsHListView.this.smoothScrollBy(targetLeft - offset, duration, false);
                return;
            }
            float screenTravelCount = (float)viewTravelCount / (float)childCount;
            this.mScrollDuration = screenTravelCount < 1.0f ? duration : (int)((float)duration / screenTravelCount);
            this.mLastSeenPos = -1;
            AbsHListView.this.postOnAnimation(this);
        }

        void scrollToVisible(int targetPos, int boundPos, int duration) {
            int firstPos = AbsHListView.this.mFirstPosition;
            int childCount = AbsHListView.this.getChildCount();
            int lastPos = firstPos + childCount - 1;
            int paddedLeft = AbsHListView.this.mListPadding.left;
            int paddedRight = AbsHListView.this.getWidth() - AbsHListView.this.mListPadding.right;
            if (targetPos < firstPos || targetPos > lastPos) {
                Log.w((String)AbsHListView.TAG, (String)("scrollToVisible called with targetPos " + targetPos + " not visible [" + firstPos + ", " + lastPos + "]"));
            }
            if (boundPos < firstPos || boundPos > lastPos) {
                boundPos = -1;
            }
            View targetChild = AbsHListView.this.getChildAt(targetPos - firstPos);
            int targetLeft = targetChild.getLeft();
            int targetRight = targetChild.getRight();
            int scrollBy = 0;
            if (targetRight > paddedRight) {
                scrollBy = targetRight - paddedRight;
            }
            if (targetLeft < paddedLeft) {
                scrollBy = targetLeft - paddedLeft;
            }
            if (scrollBy == 0) {
                return;
            }
            if (boundPos >= 0) {
                View boundChild = AbsHListView.this.getChildAt(boundPos - firstPos);
                int boundLeft = boundChild.getLeft();
                int boundRight = boundChild.getRight();
                int absScroll = Math.abs(scrollBy);
                if (scrollBy < 0 && boundRight + absScroll > paddedRight) {
                    scrollBy = Math.max(0, boundRight - paddedRight);
                } else if (scrollBy > 0 && boundLeft - absScroll < paddedLeft) {
                    scrollBy = Math.min(0, boundLeft - paddedLeft);
                }
            }
            AbsHListView.this.smoothScrollBy(scrollBy, duration);
        }

        public void stop() {
            AbsHListView.this.removeCallbacks(this);
        }

        @Override
        public void run() {
            int listWidth = AbsHListView.this.getWidth();
            int firstPos = AbsHListView.this.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int lastViewIndex = AbsHListView.this.getChildCount() - 1;
                    int lastPos = firstPos + lastViewIndex;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    if (lastPos == this.mLastSeenPos) {
                        AbsHListView.this.postOnAnimation(this);
                        return;
                    }
                    View lastView = AbsHListView.this.getChildAt(lastViewIndex);
                    int lastViewWidth = lastView.getWidth();
                    int lastViewLeft = lastView.getLeft();
                    int lastViewPixelsShowing = listWidth - lastViewLeft;
                    int extraScroll = lastPos < AbsHListView.this.mItemCount - 1 ? Math.max(AbsHListView.this.mListPadding.right, this.mExtraScroll) : AbsHListView.this.mListPadding.right;
                    int scrollBy = lastViewWidth - lastViewPixelsShowing + extraScroll;
                    AbsHListView.this.smoothScrollBy(scrollBy, this.mScrollDuration, true);
                    this.mLastSeenPos = lastPos;
                    if (lastPos >= this.mTargetPos) break;
                    AbsHListView.this.postOnAnimation(this);
                    break;
                }
                case 3: {
                    boolean nextViewIndex = true;
                    int childCount = AbsHListView.this.getChildCount();
                    if (firstPos == this.mBoundPos || childCount <= 1 || firstPos + childCount >= AbsHListView.this.mItemCount) {
                        return;
                    }
                    int nextPos = firstPos + 1;
                    if (nextPos == this.mLastSeenPos) {
                        AbsHListView.this.postOnAnimation(this);
                        return;
                    }
                    View nextView = AbsHListView.this.getChildAt(1);
                    int nextViewWidth = nextView.getWidth();
                    int nextViewLeft = nextView.getLeft();
                    int extraScroll = Math.max(AbsHListView.this.mListPadding.right, this.mExtraScroll);
                    if (nextPos < this.mBoundPos) {
                        AbsHListView.this.smoothScrollBy(Math.max(0, nextViewWidth + nextViewLeft - extraScroll), this.mScrollDuration, true);
                        this.mLastSeenPos = nextPos;
                        AbsHListView.this.postOnAnimation(this);
                        break;
                    }
                    if (nextViewLeft <= extraScroll) break;
                    AbsHListView.this.smoothScrollBy(nextViewLeft - extraScroll, this.mScrollDuration, true);
                    break;
                }
                case 2: {
                    if (firstPos == this.mLastSeenPos) {
                        AbsHListView.this.postOnAnimation(this);
                        return;
                    }
                    View firstView = AbsHListView.this.getChildAt(0);
                    if (firstView == null) {
                        return;
                    }
                    int firstViewLeft = firstView.getLeft();
                    int extraScroll = firstPos > 0 ? Math.max(this.mExtraScroll, AbsHListView.this.mListPadding.left) : AbsHListView.this.mListPadding.left;
                    AbsHListView.this.smoothScrollBy(firstViewLeft - extraScroll, this.mScrollDuration, true);
                    this.mLastSeenPos = firstPos;
                    if (firstPos <= this.mTargetPos) break;
                    AbsHListView.this.postOnAnimation(this);
                    break;
                }
                case 4: {
                    int lastViewIndex = AbsHListView.this.getChildCount() - 2;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    int lastPos = firstPos + lastViewIndex;
                    if (lastPos == this.mLastSeenPos) {
                        AbsHListView.this.postOnAnimation(this);
                        return;
                    }
                    View lastView = AbsHListView.this.getChildAt(lastViewIndex);
                    int lastViewWidth = lastView.getWidth();
                    int lastViewLeft = lastView.getLeft();
                    int lastViewPixelsShowing = listWidth - lastViewLeft;
                    int extraScroll = Math.max(AbsHListView.this.mListPadding.left, this.mExtraScroll);
                    this.mLastSeenPos = lastPos;
                    if (lastPos > this.mBoundPos) {
                        AbsHListView.this.smoothScrollBy(-(lastViewPixelsShowing - extraScroll), this.mScrollDuration, true);
                        AbsHListView.this.postOnAnimation(this);
                        break;
                    }
                    int right = listWidth - extraScroll;
                    int lastViewRight = lastViewLeft + lastViewWidth;
                    if (right <= lastViewRight) break;
                    AbsHListView.this.smoothScrollBy(-(right - lastViewRight), this.mScrollDuration, true);
                    break;
                }
                case 5: {
                    if (this.mLastSeenPos == firstPos) {
                        AbsHListView.this.postOnAnimation(this);
                        return;
                    }
                    this.mLastSeenPos = firstPos;
                    int childCount = AbsHListView.this.getChildCount();
                    int position = this.mTargetPos;
                    int lastPos = firstPos + childCount - 1;
                    int viewTravelCount = 0;
                    if (position < firstPos) {
                        viewTravelCount = firstPos - position + 1;
                    } else if (position > lastPos) {
                        viewTravelCount = position - lastPos;
                    }
                    float screenTravelCount = (float)viewTravelCount / (float)childCount;
                    float modifier = Math.min(Math.abs(screenTravelCount), 1.0f);
                    if (position < firstPos) {
                        int distance = (int)((float)(-AbsHListView.this.getWidth()) * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        AbsHListView.this.smoothScrollBy(distance, duration, true);
                        AbsHListView.this.postOnAnimation(this);
                        break;
                    }
                    if (position > lastPos) {
                        int distance = (int)((float)AbsHListView.this.getWidth() * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        AbsHListView.this.smoothScrollBy(distance, duration, true);
                        AbsHListView.this.postOnAnimation(this);
                        break;
                    }
                    int targetLeft = AbsHListView.this.getChildAt(position - firstPos).getLeft();
                    int distance = targetLeft - this.mOffsetFromLeft;
                    int duration = (int)((float)this.mScrollDuration * ((float)Math.abs(distance) / (float)AbsHListView.this.getWidth()));
                    AbsHListView.this.smoothScrollBy(distance, duration, true);
                    break;
                }
            }
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mLastFlingX;
        private final Runnable mCheckFlywheel = new Runnable(){

            @Override
            public void run() {
                int activeId = AbsHListView.this.mActivePointerId;
                VelocityTracker vt = AbsHListView.this.mVelocityTracker;
                OverScroller scroller = FlingRunnable.this.mScroller;
                if (vt == null || activeId == -1) {
                    return;
                }
                vt.computeCurrentVelocity(1000, (float)AbsHListView.this.mMaximumVelocity);
                float xvel = -vt.getXVelocity(activeId);
                if (Math.abs(xvel) >= (float)AbsHListView.this.mMinimumVelocity && FlingRunnable.this.isScrollingInDirection(scroller, xvel, 0.0f)) {
                    AbsHListView.this.postDelayed(this, 40L);
                } else {
                    FlingRunnable.this.endFling();
                    AbsHListView.this.mTouchMode = 3;
                    AbsHListView.this.reportScrollStateChange(1);
                }
            }
        };
        private static final int FLYWHEEL_TIMEOUT = 40;

        FlingRunnable() {
            this.mScroller = new OverScroller(AbsHListView.this.getContext());
        }

        void start(int initialVelocity) {
            int initialX;
            this.mLastFlingX = initialX = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.setInterpolator(this.mScroller, null);
            this.mScroller.fling(initialX, 0, initialVelocity, 0, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            AbsHListView.this.mTouchMode = 4;
            AbsHListView.this.postOnAnimation(this);
        }

        void startSpringback() {
            if (this.mScroller.springBack(AbsHListView.this.getScrollX(), 0, 0, 0, 0, 0)) {
                AbsHListView.this.mTouchMode = 6;
                AbsHListView.this.invalidate();
                AbsHListView.this.postOnAnimation(this);
            } else {
                AbsHListView.this.mTouchMode = -1;
                AbsHListView.this.reportScrollStateChange(0);
            }
        }

        void startOverfling(int initialVelocity) {
            this.setInterpolator(this.mScroller, null);
            this.mScroller.fling(AbsHListView.this.getScrollX(), 0, initialVelocity, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0, AbsHListView.this.getWidth(), 0);
            AbsHListView.this.mTouchMode = 6;
            AbsHListView.this.invalidate();
            AbsHListView.this.postOnAnimation(this);
        }

        void edgeReached(int delta) {
            this.mScroller.notifyHorizontalEdgeReached(AbsHListView.this.getScrollX(), 0, AbsHListView.this.mOverflingDistance);
            int overscrollMode = AbsHListView.this.getOverScrollMode();
            if (overscrollMode == 0 || overscrollMode == 1 && !AbsHListView.this.contentFits()) {
                AbsHListView.this.mTouchMode = 6;
                int vel = (int)this.mScroller.getCurrVelocity();
                if (delta > 0) {
                    AbsHListView.this.mEdgeGlowTop.onAbsorb(vel);
                } else {
                    AbsHListView.this.mEdgeGlowBottom.onAbsorb(vel);
                }
            } else {
                AbsHListView.this.mTouchMode = -1;
                if (AbsHListView.this.mPositionScroller != null) {
                    AbsHListView.this.mPositionScroller.stop();
                }
            }
            AbsHListView.this.invalidate();
            AbsHListView.this.postOnAnimation(this);
        }

        void startScroll(int distance, int duration, boolean linear) {
            int initialX;
            this.mLastFlingX = initialX = distance < 0 ? Integer.MAX_VALUE : 0;
            this.setInterpolator(this.mScroller, (Interpolator)(linear ? sLinearInterpolator : null));
            this.mScroller.startScroll(initialX, 0, distance, 0, duration);
            AbsHListView.this.mTouchMode = 4;
            AbsHListView.this.postOnAnimation(this);
        }

        void endFling() {
            AbsHListView.this.mTouchMode = -1;
            AbsHListView.this.removeCallbacks(this);
            AbsHListView.this.removeCallbacks(this.mCheckFlywheel);
            AbsHListView.this.reportScrollStateChange(0);
            AbsHListView.this.clearScrollingCache();
            this.mScroller.abortAnimation();
            AbsHListView.this.overScrollBy(0, 0, 0, 0, 0, 0, 0, 0, false);
        }

        void flywheelTouch() {
            AbsHListView.this.postDelayed(this.mCheckFlywheel, 40L);
        }

        @Override
        public void run() {
            switch (AbsHListView.this.mTouchMode) {
                default: {
                    this.endFling();
                    return;
                }
                case 3: {
                    if (this.mScroller.isFinished()) {
                        return;
                    }
                }
                case 4: {
                    boolean atEdge;
                    boolean atEnd;
                    if (AbsHListView.this.mDataChanged) {
                        AbsHListView.this.layoutChildren();
                    }
                    if (AbsHListView.this.mItemCount == 0 || AbsHListView.this.getChildCount() == 0) {
                        this.endFling();
                        return;
                    }
                    OverScroller scroller = this.mScroller;
                    boolean more = scroller.computeScrollOffset();
                    int x = scroller.getCurrX();
                    int delta = this.mLastFlingX - x;
                    if (delta > 0) {
                        AbsHListView.this.mMotionPosition = AbsHListView.this.mFirstPosition;
                        View firstView = AbsHListView.this.getChildAt(0);
                        AbsHListView.this.mMotionViewOriginalLeft = firstView.getLeft();
                        delta = Math.min(AbsHListView.this.getWidth() - AbsHListView.this.getPaddingRight() - AbsHListView.this.getPaddingLeft() - 1, delta);
                    } else {
                        int offsetToLast = AbsHListView.this.getChildCount() - 1;
                        AbsHListView.this.mMotionPosition = AbsHListView.this.mFirstPosition + offsetToLast;
                        View lastView = AbsHListView.this.getChildAt(offsetToLast);
                        AbsHListView.this.mMotionViewOriginalLeft = lastView.getLeft();
                        delta = Math.max(-(AbsHListView.this.getWidth() - AbsHListView.this.getPaddingRight() - AbsHListView.this.getPaddingLeft() - 1), delta);
                    }
                    View motionView = AbsHListView.this.getChildAt(AbsHListView.this.mMotionPosition - AbsHListView.this.mFirstPosition);
                    int oldLeft = 0;
                    if (motionView != null) {
                        oldLeft = motionView.getLeft();
                    }
                    boolean bl = atEnd = (atEdge = AbsHListView.this.trackMotionScroll(delta, delta)) && delta != 0;
                    if (atEnd) {
                        if (motionView != null) {
                            int overshoot = -(delta - (motionView.getLeft() - oldLeft));
                            AbsHListView.this.overScrollBy(overshoot, 0, AbsHListView.this.getScrollX(), 0, 0, 0, AbsHListView.this.mOverflingDistance, 0, false);
                        }
                        if (!more) break;
                        this.edgeReached(delta);
                        break;
                    }
                    if (more && !atEnd) {
                        if (atEdge) {
                            AbsHListView.this.invalidate();
                        }
                        this.mLastFlingX = x;
                        AbsHListView.this.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
                case 6: {
                    OverScroller scroller = this.mScroller;
                    if (scroller.computeScrollOffset()) {
                        int scrollX = AbsHListView.this.getScrollX();
                        int currX = scroller.getCurrX();
                        int deltaX = currX - scrollX;
                        if (AbsHListView.this.overScrollBy(deltaX, 0, scrollX, 0, 0, 0, AbsHListView.this.mOverflingDistance, 0, false)) {
                            boolean crossLeft;
                            boolean crossRight = scrollX <= 0 && currX > 0;
                            boolean bl = crossLeft = scrollX >= 0 && currX < 0;
                            if (crossRight || crossLeft) {
                                int velocity = (int)scroller.getCurrVelocity();
                                if (crossLeft) {
                                    velocity = -velocity;
                                }
                                scroller.abortAnimation();
                                this.start(velocity);
                                break;
                            }
                            this.startSpringback();
                            break;
                        }
                        AbsHListView.this.invalidate();
                        AbsHListView.this.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
            }
        }

        private void setInterpolator(OverScroller overScroller, Interpolator interpolator) {
            if (overScroller == null) {
                return;
            }
            try {
                Method method = OverScroller.class.getDeclaredMethod("setInterpolator", Interpolator.class);
                method.setAccessible(true);
                method.invoke((Object)overScroller, interpolator);
            }
            catch (Throwable throwable) {
                MLog.error((Object)"AbsHListView", (String)("reflect setInterpolator error! " + throwable), (Object[])new Object[0]);
            }
        }

        private boolean isScrollingInDirection(OverScroller overScroller, float xvel, float yvel) {
            if (overScroller == null) {
                return false;
            }
            try {
                Method method = OverScroller.class.getDeclaredMethod("isScrollingInDirection", Float.class, Float.class);
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)overScroller, Float.valueOf(xvel), Float.valueOf(yvel));
            }
            catch (Throwable throwable) {
                MLog.error((Object)"AbsHListView", (String)("reflect isScrollingInDirection error! " + throwable), (Object[])new Object[0]);
                return false;
            }
        }
    }

    final class CheckForTap
    implements Runnable {
        CheckForTap() {
        }

        @Override
        public void run() {
            if (AbsHListView.this.mTouchMode == 0) {
                AbsHListView.this.mTouchMode = 1;
                View child = AbsHListView.this.getChildAt(AbsHListView.this.mMotionPosition - AbsHListView.this.mFirstPosition);
                if (child != null && !child.hasFocusable()) {
                    AbsHListView.this.mLayoutMode = 0;
                    if (!AbsHListView.this.mDataChanged) {
                        Drawable d;
                        child.setPressed(true);
                        AbsHListView.this.setPressed(true);
                        AbsHListView.this.layoutChildren();
                        AbsHListView.this.positionSelector(AbsHListView.this.mMotionPosition, child);
                        AbsHListView.this.refreshDrawableState();
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = AbsHListView.this.isLongClickable();
                        if (AbsHListView.this.mSelector != null && (d = AbsHListView.this.mSelector.getCurrent()) != null && d instanceof TransitionDrawable) {
                            if (longClickable) {
                                ((TransitionDrawable)d).startTransition(longPressTimeout);
                            } else {
                                ((TransitionDrawable)d).resetTransition();
                            }
                        }
                        if (longClickable) {
                            if (AbsHListView.this.mPendingCheckForLongPress == null) {
                                AbsHListView.this.mPendingCheckForLongPress = new CheckForLongPress();
                            }
                            AbsHListView.this.mPendingCheckForLongPress.rememberWindowAttachCount();
                            AbsHListView.this.postDelayed(AbsHListView.this.mPendingCheckForLongPress, longPressTimeout);
                        } else {
                            AbsHListView.this.mTouchMode = 2;
                        }
                    } else {
                        AbsHListView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    private class CheckForKeyLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForKeyLongPress() {
        }

        @Override
        public void run() {
            if (AbsHListView.this.isPressed() && AbsHListView.this.mSelectedPosition >= 0) {
                int index = AbsHListView.this.mSelectedPosition - AbsHListView.this.mFirstPosition;
                View v = AbsHListView.this.getChildAt(index);
                if (!AbsHListView.this.mDataChanged) {
                    boolean handled = false;
                    if (this.sameWindow()) {
                        handled = AbsHListView.this.performLongPress(v, AbsHListView.this.mSelectedPosition, AbsHListView.this.mSelectedColId);
                    }
                    if (handled) {
                        AbsHListView.this.setPressed(false);
                        v.setPressed(false);
                    }
                } else {
                    AbsHListView.this.setPressed(false);
                    if (v != null) {
                        v.setPressed(false);
                    }
                }
            }
        }
    }

    private class CheckForLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            int motionPosition = AbsHListView.this.mMotionPosition;
            View child = AbsHListView.this.getChildAt(motionPosition - AbsHListView.this.mFirstPosition);
            if (child != null) {
                int longPressPosition = AbsHListView.this.mMotionPosition;
                long longPressId = AbsHListView.this.mAdapter.getItemId(AbsHListView.this.mMotionPosition);
                boolean handled = false;
                if (this.sameWindow() && !AbsHListView.this.mDataChanged) {
                    handled = AbsHListView.this.performLongPress(child, longPressPosition, longPressId);
                }
                if (handled) {
                    AbsHListView.this.mTouchMode = -1;
                    AbsHListView.this.setPressed(false);
                    child.setPressed(false);
                } else {
                    AbsHListView.this.mTouchMode = 2;
                }
            }
        }
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable {
        int mClickMotionPosition;

        private PerformClick() {
        }

        @Override
        public void run() {
            View view;
            if (AbsHListView.this.mDataChanged) {
                return;
            }
            ListAdapter adapter = AbsHListView.this.mAdapter;
            int motionPosition = this.mClickMotionPosition;
            if (adapter != null && AbsHListView.this.mItemCount > 0 && motionPosition != -1 && motionPosition < adapter.getCount() && this.sameWindow() && (view = AbsHListView.this.getChildAt(motionPosition - AbsHListView.this.mFirstPosition)) != null) {
                AbsHListView.this.performItemClick(view, motionPosition, adapter.getItemId(motionPosition));
            }
        }
    }

    private class WindowRunnnable {
        private int mOriginalAttachCount;

        private WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = AbsHListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return AbsHListView.this.hasWindowFocus() && AbsHListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }

    @TargetApi(value=14)
    class ListItemAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        ListItemAccessibilityDelegate() {
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            int position = AbsHListView.this.getPositionForView(host);
            ListAdapter adapter = (ListAdapter)AbsHListView.this.getAdapter();
            if (position == -1 || adapter == null) {
                return;
            }
            if (!AbsHListView.this.isEnabled() || !adapter.isEnabled(position)) {
                return;
            }
            if (position == AbsHListView.this.getSelectedItemPosition()) {
                info.setSelected(true);
                info.addAction(8);
            } else {
                info.addAction(4);
            }
            if (AbsHListView.this.isClickable()) {
                info.addAction(16);
                info.setClickable(true);
            }
            if (AbsHListView.this.isLongClickable()) {
                info.addAction(32);
                info.setLongClickable(true);
            }
        }

        public boolean performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            int position = AbsHListView.this.getPositionForView(host);
            ListAdapter adapter = (ListAdapter)AbsHListView.this.getAdapter();
            if (position == -1 || adapter == null) {
                return false;
            }
            if (!AbsHListView.this.isEnabled() || !adapter.isEnabled(position)) {
                return false;
            }
            long id2 = AbsHListView.this.getItemIdAtPosition(position);
            switch (action) {
                case 8: {
                    if (AbsHListView.this.getSelectedItemPosition() == position) {
                        AbsHListView.this.setSelection(-1);
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (AbsHListView.this.getSelectedItemPosition() != position) {
                        AbsHListView.this.setSelection(position);
                        return true;
                    }
                    return false;
                }
                case 16: {
                    if (AbsHListView.this.isClickable()) {
                        return AbsHListView.this.performItemClick(host, position, id2);
                    }
                    return false;
                }
                case 32: {
                    if (AbsHListView.this.isLongClickable()) {
                        return AbsHListView.this.performLongPress(host, position, id2);
                    }
                    return false;
                }
            }
            return false;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        long selectedId;
        long firstId;
        int viewLeft;
        int position;
        int width;
        String filter;
        boolean inActionMode;
        int checkedItemCount;
        SparseArrayCompat<Boolean> checkState;
        LongSparseArray<Integer> checkIdState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.selectedId = in.readLong();
            this.firstId = in.readLong();
            this.viewLeft = in.readInt();
            this.position = in.readInt();
            this.width = in.readInt();
            this.filter = in.readString();
            this.inActionMode = in.readByte() != 0;
            this.checkedItemCount = in.readInt();
            this.checkState = this.readSparseBooleanArray(in);
            this.checkIdState = this.readSparseLongArray(in);
        }

        private LongSparseArray<Integer> readSparseLongArray(Parcel in) {
            int n = in.readInt();
            if (n <= 0) {
                return null;
            }
            LongSparseArray array = new LongSparseArray(n);
            this.readSparseLongArrayInternal((LongSparseArray<Integer>)array, in, n);
            return array;
        }

        private SparseArrayCompat<Boolean> readSparseBooleanArray(Parcel in) {
            int n = in.readInt();
            if (n < 0) {
                return null;
            }
            SparseArrayCompat sa = new SparseArrayCompat(n);
            this.readSparseBooleanArrayInternal((SparseArrayCompat<Boolean>)sa, in, n);
            return sa;
        }

        private void readSparseLongArrayInternal(LongSparseArray<Integer> outVal, Parcel in, int n) {
            while (n > 0) {
                long key = in.readLong();
                int value = in.readInt();
                outVal.put(key, (Object)value);
                --n;
            }
        }

        private void readSparseBooleanArrayInternal(SparseArrayCompat<Boolean> outVal, Parcel in, int n) {
            while (n > 0) {
                int key = in.readInt();
                boolean value = in.readByte() == 1;
                outVal.append(key, (Object)value);
                --n;
            }
        }

        private void writeSparseLongArray(LongSparseArray<Integer> array, Parcel out) {
            int n = array != null ? array.size() : 0;
            out.writeInt(n);
            for (int i = 0; i < n; ++i) {
                out.writeLong(array.keyAt(i));
                out.writeInt(((Integer)array.valueAt(i)).intValue());
            }
        }

        private void writeSparseBooleanArray(SparseArrayCompat<Boolean> val, Parcel out) {
            if (val == null) {
                out.writeInt(-1);
                return;
            }
            int n = val.size();
            out.writeInt(n);
            for (int i = 0; i < n; ++i) {
                out.writeInt(val.keyAt(i));
                out.writeByte((byte)((Boolean)val.valueAt(i) != false ? 1 : 0));
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.selectedId);
            out.writeLong(this.firstId);
            out.writeInt(this.viewLeft);
            out.writeInt(this.position);
            out.writeInt(this.width);
            out.writeString(this.filter);
            out.writeByte((byte)(this.inActionMode ? 1 : 0));
            out.writeInt(this.checkedItemCount);
            this.writeSparseBooleanArray(this.checkState, out);
            this.writeSparseLongArray(this.checkIdState, out);
        }

        public String toString() {
            return "AbsListView.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selectedId=" + this.selectedId + " firstId=" + this.firstId + " viewLeft=" + this.viewLeft + " position=" + this.position + " width=" + this.width + " filter=" + this.filter + " checkState=" + this.checkState + "}";
        }
    }

    public static interface SelectionBoundsAdjuster {
        public void adjustListItemSelectionBounds(Rect var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbsHListView var1, int var2);

        public void onScroll(AbsHListView var1, int var2, int var3, int var4);
    }
}

