/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.guide;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.appbase.ui.widget.guide.IFloatGuideCallback;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public class FloatGuideView
extends YYFrameLayout
implements View.OnClickListener {
    private static final String TAG = "FTHomePage.HomeGameGuideView";
    private static final String SVGA_URL = "home_game_guide_b.svga";
    private SVGAImageView mGuideSvga;
    private IFloatGuideCallback mCallback;
    private RectF mAnimRect;
    private Paint mPaint;
    private Path mCardPath;
    private Path mBgPath;
    private boolean mClipPathExceptionHappened = false;
    private Runnable mShowRunnable;
    private final SafeLiveData<Boolean> isShowing = new SafeLiveData();
    private WeakReference<View> mHighLightViewRef;
    private View.OnAttachStateChangeListener mHighLightViewAttachStateChangeListener;
    private boolean isEndSuccess = false;
    private ObjectAnimator hideAnimator;
    private int fixCount = 0;
    private Runnable fixGuideCallback;
    private Runnable mHideGuide = new Runnable(){

        @Override
        public void run() {
            FloatGuideView.this.hideGuide(true);
        }
    };

    public FloatGuideView(Context context) {
        super(context);
        this.createView(context);
    }

    public FloatGuideView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public FloatGuideView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        ViewGroup.LayoutParams layoutParams;
        if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        if ((layoutParams = this.getLayoutParams()) == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -1);
        }
        layoutParams.height = -1;
        layoutParams.width = -1;
        this.setLayoutParams(layoutParams);
        this.setOnClickListener(this);
    }

    public void setFixGuideCallback(Runnable fixGuideCallback) {
        this.fixGuideCallback = fixGuideCallback;
    }

    public void onClick(View v) {
        if (v == this) {
            this.hideGuide(true);
            if (this.mCallback != null) {
                this.mCallback.setGuide(false);
                this.mCallback.onOutSideClick();
            }
        } else if (v == this.mGuideSvga) {
            this.hideGuide(true);
            if (this.mCallback != null) {
                this.mCallback.setGuide(false);
                this.mCallback.onCardClick();
            }
        }
    }

    public void setCallback(IFloatGuideCallback callback) {
        this.mCallback = callback;
    }

    public void startGuide(final View highLightView) {
        if (this.isCover(highLightView)) {
            MLog.info((Object)TAG, (String)"startGuide highLightView isCover return", (Object[])new Object[0]);
            return;
        }
        this.removeAttachStateListener();
        this.mHighLightViewRef = new WeakReference<View>(highLightView);
        this.mHighLightViewAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                MLog.info((Object)FloatGuideView.TAG, (String)"onViewAttachedToWindow %s,isEndSuccess %s", (Object[])new Object[]{v.hashCode(), FloatGuideView.this.isEndSuccess});
                if (!FloatGuideView.this.isEndSuccess && FloatGuideView.this.fixCount < 4) {
                    FloatGuideView.this.fixCount++;
                    YYTaskExecutor.postToMainThread(() -> {
                        MLog.warn((Object)FloatGuideView.TAG, (String)"onViewAttachedToWindow \u5c1d\u8bd5\u4fee\u590d\u5f15\u5bfc, %s", (Object[])new Object[]{highLightView.hashCode()});
                        if (FloatGuideView.this.fixGuideCallback != null) {
                            FloatGuideView.this.fixGuideCallback.run();
                        }
                    });
                }
            }

            public void onViewDetachedFromWindow(View v) {
                if (v == FloatGuideView.this.mHighLightViewRef.get()) {
                    MLog.info((Object)FloatGuideView.TAG, (String)"onViewDetachedFromWindow %s, isEndSuccess %s", (Object[])new Object[]{v.hashCode(), FloatGuideView.this.isEndSuccess});
                    if (!FloatGuideView.this.isEndSuccess) {
                        FloatGuideView.this.hideGuide(false);
                    }
                }
            }
        };
        highLightView.addOnAttachStateChangeListener(this.mHighLightViewAttachStateChangeListener);
        int space = ResolutionUtils.dip2Px((float)10.0f);
        int[] location = new int[2];
        highLightView.getLocationInWindow(location);
        int[] myLocatin = new int[2];
        this.getLocationInWindow(myLocatin);
        MLog.info((Object)TAG, (String)"startGuide location highLightView: %s, guide view: %s, space: %s", (Object[])new Object[]{Arrays.toString(location), Arrays.toString(myLocatin), space});
        int left = Math.max(0, location[0] - myLocatin[0] - space + highLightView.getPaddingLeft());
        int top = Math.max(0, location[1] - myLocatin[1] - space + highLightView.getPaddingTop());
        int width = highLightView.getWidth() - highLightView.getPaddingLeft() - highLightView.getPaddingRight() + 2 * space;
        int height = highLightView.getHeight() - highLightView.getPaddingTop() - highLightView.getPaddingBottom() + 2 * space;
        RectF tempRect = new RectF((float)left, (float)top, (float)(left + width), (float)(top + height));
        if (tempRect.equals((Object)this.mAnimRect) && this.getVisibility() == 0 && Boolean.TRUE.equals(this.isShowing.getValue())) {
            MLog.info((Object)TAG, (String)"startGuide animRect \u6ca1\u53d8\u5316\uff0c\u4e0d\u5237\u65b0", (Object[])new Object[0]);
            return;
        }
        this.mAnimRect = tempRect;
        MLog.info((Object)TAG, (String)"startGuide animRect: %s, %s", (Object[])new Object[]{highLightView.hashCode(), this.mAnimRect});
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setColor(Color.argb((int)128, (int)0, (int)0, (int)0));
            this.mPaint.setStyle(Paint.Style.FILL);
        }
        if (this.mCardPath == null) {
            this.mCardPath = new Path();
        }
        if (this.mBgPath == null) {
            this.mBgPath = new Path();
        }
        if (this.hideAnimator != null) {
            this.hideAnimator.cancel();
        }
        this.setAlpha(1.0f);
        this.setVisibility(0);
        if (this.mShowRunnable == null) {
            this.mShowRunnable = new Runnable(){

                @Override
                public void run() {
                }
            };
        }
        this.removeCallbacks(this.mShowRunnable);
        this.post(this.mShowRunnable);
        this.checkHide();
        this.isShowing.setValue(true);
    }

    private boolean isCover(View view) {
        try {
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                return rect.width() < view.getMeasuredWidth() || rect.height() < view.getMeasuredHeight();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void checkHide() {
        if (this.getVisibility() == 0) {
            YYTaskExecutor.removeTask((Runnable)this.mHideGuide);
            YYTaskExecutor.postToMainThread((Runnable)this.mHideGuide, (long)10000L);
        }
    }

    public void hideGuide(boolean isEndSuccess) {
        MLog.info((Object)TAG, (String)"hideGuide isEndSuccess %s", (Object[])new Object[]{isEndSuccess});
        YYTaskExecutor.removeTask((Runnable)this.mHideGuide);
        this.isEndSuccess = isEndSuccess;
        if (isEndSuccess) {
            this.removeAttachStateListener();
        }
        if (this.hideAnimator != null) {
            this.hideAnimator.cancel();
        }
        this.hideAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        this.hideAnimator.setDuration(200L);
        this.hideAnimator.start();
        this.hideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (Boolean.FALSE.equals(FloatGuideView.this.isShowing.getValue())) {
                    MLog.info((Object)FloatGuideView.TAG, (String)("hideGuide onAnimationEnd isEndSuccess: " + FloatGuideView.this.isEndSuccess), (Object[])new Object[0]);
                    FloatGuideView.this.setVisibility(8);
                    if (FloatGuideView.this.isEndSuccess) {
                        if (FloatGuideView.this.getParent() instanceof ViewGroup) {
                            ViewGroup parent = (ViewGroup)FloatGuideView.this.getParent();
                            parent.post(() -> parent.removeView((View)FloatGuideView.this));
                        }
                        if (FloatGuideView.this.mCallback != null) {
                            FloatGuideView.this.mCallback.onGuideHide();
                        }
                    }
                } else {
                    FloatGuideView.this.setAlpha(1.0f);
                }
                FloatGuideView.this.hideAnimator = null;
            }
        });
        this.isShowing.setValue(false);
    }

    private void removeAttachStateListener() {
        if (this.mHighLightViewRef != null && this.mHighLightViewRef.get() != null && this.mHighLightViewAttachStateChangeListener != null) {
            ((View)this.mHighLightViewRef.get()).removeOnAttachStateChangeListener(this.mHighLightViewAttachStateChangeListener);
            this.mHighLightViewAttachStateChangeListener = null;
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mPaint != null && this.mAnimRect != null) {
            this.mCardPath.rewind();
            this.mBgPath.rewind();
            this.mBgPath.addRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), Path.Direction.CW);
            this.mCardPath.addRect(this.mAnimRect, Path.Direction.CW);
            if (Build.VERSION.SDK_INT >= 19) {
                this.mCardPath.op(this.mBgPath, Path.Op.REVERSE_DIFFERENCE);
                canvas.drawPath(this.mCardPath, this.mPaint);
            } else if (!this.mClipPathExceptionHappened) {
                try {
                    canvas.save();
                    canvas.clipPath(this.mCardPath, Region.Op.XOR);
                    canvas.drawPaint(this.mPaint);
                    canvas.restore();
                }
                catch (UnsupportedOperationException e) {
                    MLog.error((Object)"HomeGameGuideView", (Throwable)e);
                    this.mClipPathExceptionHappened = true;
                }
            }
        }
        super.dispatchDraw(canvas);
    }
}

