/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.gallery;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Gallery;
import com.yy.base.logger.MLog;
import java.lang.ref.WeakReference;

public class AdGallery
extends Gallery
implements View.OnTouchListener {
    private static final int DEFAULT_INTERVAL = 10000;
    private int mFlipInterval = 10000;
    private boolean mAutoStart = false;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mVisible = false;
    private boolean mUserPresent = true;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(action)) {
                AdGallery.this.mUserPresent = false;
                AdGallery.this.updateRunning();
            } else if ("android.intent.action.USER_PRESENT".equals(action)) {
                AdGallery.this.mUserPresent = true;
                AdGallery.this.updateRunning(false);
            }
        }
    };
    private static final int FLIP_MSG = 1;
    private final Handler mHandler = new GalleryHandler(this);

    public AdGallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public AdGallery(Context context) {
        super(context);
        this.init();
    }

    public AdGallery(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void init() {
        this.setOnTouchListener(this);
        this.setSoundEffectsEnabled(false);
        this.setFocusableInTouchMode(true);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        int kEvent = this.isScrollingLeft(e1, e2) ? 21 : 22;
        this.onKeyDown(kEvent, null);
        return true;
    }

    private boolean isScrollingLeft(MotionEvent e1, MotionEvent e2) {
        return e2.getX() > e1.getX() + 50.0f;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return super.onScroll(e1, e2, distanceX, distanceY);
    }

    public void startAutoScroll() {
        this.startFlipping();
    }

    public void endAutoScroll() {
        this.stopFlipping();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (1 == event.getAction() || 3 == event.getAction()) {
            this.startFlipping();
        } else {
            this.stopFlipping();
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.getContext().registerReceiver(this.mReceiver, filter, null, this.mHandler);
        if (this.mAutoStart) {
            this.startFlipping();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.getContext().unregisterReceiver(this.mReceiver);
        this.updateRunning();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning(false);
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }

    private void updateRunning() {
        this.updateRunning(true);
    }

    private void updateRunning(boolean flipNow) {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted && this.mUserPresent;
        if (running != this.mRunning) {
            if (running) {
                this.setSelection(this.getSelectedItemPosition(), flipNow);
                Message msg = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(msg, (long)this.mFlipInterval);
            } else {
                this.mHandler.removeMessages(1);
            }
            this.mRunning = running;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)((Object)this), (String)("updateRunning() mVisible=" + this.mVisible + ", mStarted=" + this.mStarted + ", mUserPresent=" + this.mUserPresent + ", mRunning=" + this.mRunning), (Object[])new Object[0]);
        }
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    public void setAutoStart(boolean autoStart) {
        this.mAutoStart = autoStart;
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    public void setFlipInterval(int flipInterval) {
        this.mFlipInterval = flipInterval;
    }

    private static class GalleryHandler
    extends Handler {
        WeakReference<AdGallery> mGallery;

        GalleryHandler(AdGallery gallery) {
            this.mGallery = new WeakReference<AdGallery>(gallery);
        }

        public void handleMessage(Message msg) {
            AdGallery gallery = (AdGallery)((Object)this.mGallery.get());
            if (gallery == null) {
                return;
            }
            if (msg.what == 1 && gallery.mRunning) {
                if (gallery.getSelectedItemPosition() >= gallery.getCount() - 1) {
                    gallery.setSelection(0, true);
                    gallery.onKeyDown(21, null);
                } else {
                    gallery.onScroll(null, null, 1.0f, 0.0f);
                    gallery.onKeyDown(22, null);
                }
                msg = this.obtainMessage(1);
                this.sendMessageDelayed(msg, gallery.mFlipInterval);
            }
        }
    }
}

