/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import androidx.annotation.Nullable;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RelativePos {
    public static final int CENTER_HORIZONTAL = 0;
    public static final int TO_LEFT_OF = 1;
    public static final int TO_RIGHT_OF = 2;
    public static final int ALIGN_LEFT = 3;
    public static final int ALIGN_RIGHT = 4;
    public static final int CENTER_VERTICAL = 0;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int ALIGN_TOP = 3;
    public static final int ALIGN_BOTTOM = 4;
    private int mHorizontalRelate = 0;
    private int mVerticalRelate = 0;
    private BubbleStyle.ArrowPosPolicy posPolicyEnforce = null;

    public RelativePos(int mHorizontalRelate, int mVerticalRelate) {
        this.mHorizontalRelate = mHorizontalRelate;
        this.mVerticalRelate = mVerticalRelate;
    }

    public int getHorizontalRelate() {
        return this.mHorizontalRelate;
    }

    public void setHorizontalRelate(int horizontalRelate) {
        this.mHorizontalRelate = horizontalRelate;
    }

    public int getVerticalRelate() {
        return this.mVerticalRelate;
    }

    public void setVerticalRelate(int verticalRelate) {
        this.mVerticalRelate = verticalRelate;
    }

    private boolean isHorizontalToTargetOf() {
        return this.mHorizontalRelate == 1 || this.mHorizontalRelate == 2;
    }

    private boolean isVerticalToTargetOf() {
        return this.mVerticalRelate == 1 || this.mVerticalRelate == 2;
    }

    public BubbleStyle.ArrowDirection getArrowDirection() {
        if (this.isHorizontalToTargetOf() && !this.isVerticalToTargetOf()) {
            if (this.mHorizontalRelate == 2) {
                return BubbleStyle.ArrowDirection.Left;
            }
            if (this.mHorizontalRelate == 1) {
                return BubbleStyle.ArrowDirection.Right;
            }
        }
        if (!this.isHorizontalToTargetOf() && this.isVerticalToTargetOf()) {
            if (this.mVerticalRelate == 2) {
                return BubbleStyle.ArrowDirection.Up;
            }
            if (this.mVerticalRelate == 1) {
                return BubbleStyle.ArrowDirection.Down;
            }
        }
        return BubbleStyle.ArrowDirection.None;
    }

    public void setPosPolicyEnforce(BubbleStyle.ArrowPosPolicy posPolicy) {
        this.posPolicyEnforce = posPolicy;
    }

    @Nullable
    public BubbleStyle.ArrowPosPolicy getArrowPosPolicy() {
        return this.posPolicyEnforce;
    }

    public BubbleStyle.ArrowPosPolicy getHorizPolicy() {
        if (this.posPolicyEnforce != null) {
            return this.posPolicyEnforce;
        }
        switch (this.getHorizontalRelate()) {
            case 0: {
                return BubbleStyle.ArrowPosPolicy.TargetCenter;
            }
            case 3: {
                return BubbleStyle.ArrowPosPolicy.SelfBegin;
            }
            case 4: {
                return BubbleStyle.ArrowPosPolicy.SelfEnd;
            }
        }
        return BubbleStyle.ArrowPosPolicy.TargetCenter;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RelativeV {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RelativeH {
    }
}

