/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.bubble.BubbleCallback;
import com.yy.appbase.ui.widget.bubble.BubbleDrawable;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.base.utils.ResolutionUtils;
import java.lang.ref.WeakReference;

class BubbleImpl
implements BubbleStyle {
    private View mParentView;
    private BubbleCallback mHolderCallback;
    private BubbleDrawable mBubbleDrawable = new BubbleDrawable();
    private BubbleStyle.ArrowDirection mArrowDirection = BubbleStyle.ArrowDirection.Auto;
    private BubbleStyle.ArrowDirection mDrawableArrowDirection = BubbleStyle.ArrowDirection.None;
    private BubbleStyle.ArrowPosPolicy mArrowPosPolicy = BubbleStyle.ArrowPosPolicy.TargetCenter;
    private WeakReference<View> mArrowToViewRef = null;
    private int mArrowToViewId = 0;
    private float mArrowHeight = 0.0f;
    private float mArrowWidth = 0.0f;
    private float mArrowPosDelta = 0.0f;
    private float mCornerTopLeftRadius = 0.0f;
    private float mCornerTopRightRadius = 0.0f;
    private float mCornerBottomLeftRadius = 0.0f;
    private float mCornerBottomRightRadius = 0.0f;
    private int mPaddingLeftOffset = 0;
    private int mPaddingTopOffset = 0;
    private int mPaddingRightOffset = 0;
    private int mPaddingBottomOffset = 0;
    private int mFillColor = -872415232;
    private int mBorderColor = -1;
    private float mBorderWidth = 0.0f;
    private float mFillPadding = 0.0f;
    private boolean isRoomListTag = false;
    private boolean mInterceptDrawable = false;
    private float mShadowRadius = -1.0f;
    private View.OnLayoutChangeListener mOnLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            BubbleImpl.this.requestUpdateBubble();
        }
    };
    private int[] mLocation = new int[2];
    private Rect mRectTo = new Rect();
    private Rect mRectSelf = new Rect();

    BubbleImpl() {
    }

    void init(View view, Context context, AttributeSet attrs) {
        this.mParentView = view;
        this.mHolderCallback = (BubbleCallback)view;
        if (attrs != null) {
            float radius;
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BubbleStyle);
            this.mArrowDirection = BubbleStyle.ArrowDirection.valueOf(ta.getInt(R.styleable.BubbleStyle_bb_arrowDirection, BubbleStyle.ArrowDirection.Auto.getValue()));
            this.mArrowHeight = ta.getDimension(R.styleable.BubbleStyle_bb_arrowHeight, (float)ResolutionUtils.dip2Px((float)6.0f));
            this.mArrowWidth = ta.getDimension(R.styleable.BubbleStyle_bb_arrowWidth, (float)ResolutionUtils.dip2Px((float)10.0f));
            this.mArrowPosPolicy = BubbleStyle.ArrowPosPolicy.valueOf(ta.getInt(R.styleable.BubbleStyle_bb_arrowPosPolicy, BubbleStyle.ArrowPosPolicy.TargetCenter.getValue()));
            this.mArrowPosDelta = ta.getDimension(R.styleable.BubbleStyle_bb_arrowPosDelta, 0.0f);
            this.mArrowToViewId = ta.getResourceId(R.styleable.BubbleStyle_bb_arrowTo, 0);
            this.mCornerBottomLeftRadius = this.mCornerBottomRightRadius = (radius = ta.getDimension(R.styleable.BubbleStyle_bb_cornerRadius, (float)ResolutionUtils.dip2Px((float)4.0f)));
            this.mCornerTopRightRadius = this.mCornerBottomRightRadius;
            this.mCornerTopLeftRadius = this.mCornerBottomRightRadius;
            this.mCornerTopLeftRadius = ta.getDimension(R.styleable.BubbleStyle_bb_cornerTopLeftRadius, this.mCornerTopLeftRadius);
            this.mCornerTopRightRadius = ta.getDimension(R.styleable.BubbleStyle_bb_cornerTopRightRadius, this.mCornerTopLeftRadius);
            this.mCornerBottomLeftRadius = ta.getDimension(R.styleable.BubbleStyle_bb_cornerBottomLeftRadius, this.mCornerTopLeftRadius);
            this.mCornerBottomRightRadius = ta.getDimension(R.styleable.BubbleStyle_bb_cornerBottomRightRadius, this.mCornerTopLeftRadius);
            this.mFillColor = ta.getColor(R.styleable.BubbleStyle_bb_fillColor, -872415232);
            this.mFillPadding = ta.getDimension(R.styleable.BubbleStyle_bb_fillPadding, 0.0f);
            this.mBorderColor = ta.getColor(R.styleable.BubbleStyle_bb_borderColor, -1);
            this.mBorderWidth = ta.getDimension(R.styleable.BubbleStyle_bb_borderWidth, 0.0f);
            this.isRoomListTag = ta.getBoolean(R.styleable.BubbleStyle_bb_isRoomListTag, false);
            this.mShadowRadius = ta.getDimension(R.styleable.BubbleStyle_bb_shadowRadius, this.mShadowRadius);
            this.mBubbleDrawable.setRoomTagUse(this.isRoomListTag);
            ta.recycle();
        }
        if (this.mShadowRadius > 0.0f) {
            this.mParentView.setLayerType(1, null);
        }
        this.updateDrawable(this.mParentView.getWidth(), this.mParentView.getHeight(), false);
    }

    @Override
    public void setArrowDirection(BubbleStyle.ArrowDirection arrowDirection) {
        this.mArrowDirection = arrowDirection;
    }

    @Override
    public BubbleStyle.ArrowDirection getArrowDirection() {
        return this.mArrowDirection;
    }

    @Override
    public void setArrowHeight(float arrowHeight) {
        this.mArrowHeight = arrowHeight;
    }

    @Override
    public float getArrowHeight() {
        return this.mArrowHeight;
    }

    @Override
    public void setArrowWidth(float arrowWidth) {
        this.mArrowWidth = arrowWidth;
    }

    @Override
    public float getArrowWidth() {
        return this.mArrowWidth;
    }

    @Override
    public void setArrowPosPolicy(BubbleStyle.ArrowPosPolicy policy) {
        this.mArrowPosPolicy = policy;
    }

    @Override
    public void setArrowPosDelta(float delta) {
        this.mArrowPosDelta = delta;
    }

    @Override
    public BubbleStyle.ArrowPosPolicy getArrowPosPolicy() {
        return this.mArrowPosPolicy;
    }

    @Override
    public float getArrowPosDelta() {
        return this.mArrowPosDelta;
    }

    @Override
    public void setArrowTo(int targetViewId) {
        this.mArrowToViewId = targetViewId;
        this.setArrowToRef(null);
    }

    @Override
    public void setArrowTo(View targetView) {
        this.mArrowToViewId = targetView != null ? targetView.getId() : 0;
        this.setArrowToRef(targetView);
    }

    @Override
    public View getArrowTo() {
        return this.mArrowToViewRef != null ? (View)this.mArrowToViewRef.get() : null;
    }

    @Override
    public void setFillColor(int fillColor) {
        this.mFillColor = fillColor;
    }

    @Override
    public int getFillColor() {
        return this.mFillColor;
    }

    @Override
    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    @Override
    public int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    @Override
    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public void setFillPadding(float fillPadding) {
        this.mFillPadding = fillPadding;
    }

    @Override
    public float getFillPadding() {
        return this.mFillPadding;
    }

    @Override
    public void setCornerRadius(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.mCornerTopLeftRadius = topLeft;
        this.mCornerTopRightRadius = topRight;
        this.mCornerBottomRightRadius = bottomRight;
        this.mCornerBottomLeftRadius = bottomLeft;
    }

    @Override
    public void setCornerRadius(float radius) {
        this.setCornerRadius(radius, radius, radius, radius);
    }

    @Override
    public float getCornerTopLeftRadius() {
        return this.mCornerTopLeftRadius;
    }

    @Override
    public float getCornerTopRightRadius() {
        return this.mCornerTopRightRadius;
    }

    @Override
    public float getCornerBottomLeftRadius() {
        return this.mCornerBottomLeftRadius;
    }

    @Override
    public float getCornerBottomRightRadius() {
        return this.mCornerBottomRightRadius;
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        if (this.mHolderCallback == null) {
            return;
        }
        if (Build.VERSION.SDK_INT <= 16) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            for (int i = 0; i < 7; ++i) {
                if (!stack[i].getClassName().equals(View.class.getName()) || !stack[i].getMethodName().equals("recomputePadding")) continue;
                Log.w((String)"BubbleImpl", (String)"Called setPadding by View on old Android platform");
                this.mHolderCallback.setSuperPadding(left, top, right, bottom);
                return;
            }
        }
        this.mPaddingBottomOffset = 0;
        this.mPaddingRightOffset = 0;
        this.mPaddingTopOffset = 0;
        this.mPaddingLeftOffset = 0;
        switch (this.mDrawableArrowDirection) {
            case Left: {
                this.mPaddingLeftOffset = (int)((float)this.mPaddingLeftOffset + this.mArrowHeight);
                break;
            }
            case Up: {
                this.mPaddingTopOffset = (int)((float)this.mPaddingTopOffset + this.mArrowHeight);
                break;
            }
            case Right: {
                this.mPaddingRightOffset = (int)((float)this.mPaddingRightOffset + this.mArrowHeight);
                break;
            }
            case Down: {
                this.mPaddingBottomOffset = (int)((float)this.mPaddingBottomOffset + this.mArrowHeight);
                break;
            }
        }
        final int superPaddingLeft = left + this.mPaddingLeftOffset;
        final int superPaddingTop = top + this.mPaddingTopOffset;
        final int superPaddingRight = right + this.mPaddingRightOffset;
        final int superPaddingBottom = bottom + this.mPaddingBottomOffset;
        if (superPaddingLeft != this.mHolderCallback.getSuperPaddingLeft() || superPaddingTop != this.mHolderCallback.getSuperPaddingTop() || superPaddingRight != this.mHolderCallback.getSuperPaddingRight() || superPaddingBottom != this.mHolderCallback.getSuperPaddingBottom()) {
            this.mParentView.post(new Runnable(){

                @Override
                public void run() {
                    BubbleImpl.this.mHolderCallback.setSuperPadding(superPaddingLeft, superPaddingTop, superPaddingRight, superPaddingBottom);
                }
            });
        }
    }

    @Override
    public int getPaddingLeft() {
        return this.mHolderCallback.getSuperPaddingLeft() - this.mPaddingLeftOffset;
    }

    @Override
    public int getPaddingTop() {
        return this.mHolderCallback.getSuperPaddingTop() - this.mPaddingTopOffset;
    }

    @Override
    public int getPaddingRight() {
        return this.mHolderCallback.getSuperPaddingRight() - this.mPaddingRightOffset;
    }

    @Override
    public int getPaddingBottom() {
        return this.mHolderCallback.getSuperPaddingBottom() - this.mPaddingBottomOffset;
    }

    void updateDrawable(int width, int height, boolean drawImmediately) {
        if (this.mInterceptDrawable) {
            return;
        }
        int arrowToOffsetX = 0;
        int arrowToOffsetY = 0;
        View arrowToView = this.getArrowTo();
        if (arrowToView == null && this.mArrowToViewId != 0) {
            arrowToView = this.findGlobalViewById(this.mArrowToViewId);
            this.setArrowToRef(arrowToView);
        }
        this.mDrawableArrowDirection = this.mArrowDirection;
        if (arrowToView != null) {
            arrowToView.getLocationOnScreen(this.mLocation);
            this.mRectTo.set(this.mLocation[0], this.mLocation[1], this.mLocation[0] + arrowToView.getWidth(), this.mLocation[1] + arrowToView.getHeight());
            this.mParentView.getLocationOnScreen(this.mLocation);
            this.mRectSelf.set(this.mLocation[0], this.mLocation[1], this.mLocation[0] + width, this.mLocation[1] + height);
            if (this.mDrawableArrowDirection == BubbleStyle.ArrowDirection.Auto) {
                this.mDrawableArrowDirection = BubbleImpl.getAutoArrowDirection(this.mRectSelf, this.mRectTo);
            }
            arrowToOffsetX = this.mRectTo.centerX() - this.mRectSelf.centerX();
            arrowToOffsetY = this.mRectTo.centerY() - this.mRectSelf.centerY();
        }
        this.setPadding(this.mParentView.getPaddingLeft(), this.mParentView.getPaddingTop(), this.mParentView.getPaddingRight(), this.mParentView.getPaddingBottom());
        if (drawImmediately) {
            this.mBubbleDrawable.resetRect(width, height);
            this.mBubbleDrawable.setCornerRadius(this.mCornerTopLeftRadius, this.mCornerTopRightRadius, this.mCornerBottomRightRadius, this.mCornerBottomLeftRadius);
            this.mBubbleDrawable.setFillColor(this.mFillColor);
            this.mBubbleDrawable.setBorderWidth(this.mBorderWidth);
            this.mBubbleDrawable.setFillPadding(this.mFillPadding);
            this.mBubbleDrawable.setBorderColor(this.mBorderColor);
            this.mBubbleDrawable.setArrowDirection(this.mDrawableArrowDirection);
            this.mBubbleDrawable.setArrowPosPolicy(this.mArrowPosPolicy);
            this.mBubbleDrawable.setArrowTo(arrowToOffsetX, arrowToOffsetY);
            this.mBubbleDrawable.setArrowPosDelta(this.mArrowPosDelta);
            this.mBubbleDrawable.setArrowHeight(this.mArrowHeight);
            this.mBubbleDrawable.setArrowWidth(this.mArrowWidth);
            this.mBubbleDrawable.setShadowRadius(this.mShadowRadius);
            this.mBubbleDrawable.updateShapes();
            if (Build.VERSION.SDK_INT >= 16) {
                this.mParentView.setBackground((Drawable)this.mBubbleDrawable);
            } else {
                this.mParentView.setBackgroundDrawable((Drawable)this.mBubbleDrawable);
            }
        }
    }

    @Override
    public void requestUpdateBubble() {
        this.updateDrawable(this.mParentView.getWidth(), this.mParentView.getHeight(), true);
    }

    @Override
    public void setCustomArrowXY(float x, float y) {
        this.mBubbleDrawable.setCustomArrowXY(x, y);
    }

    private View findGlobalViewById(int viewId) {
        if (viewId == 0) {
            return null;
        }
        View vp = this.mParentView;
        while (vp.getParent() instanceof View) {
            View arrowToView = (vp = (View)vp.getParent()).findViewById(viewId);
            if (arrowToView == null) continue;
            return arrowToView;
        }
        return null;
    }

    private void setArrowToRef(View targetView) {
        View oldTargetView;
        if (this.mArrowToViewRef != null && (oldTargetView = (View)this.mArrowToViewRef.get()) != null) {
            oldTargetView.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        }
        WeakReference<View> weakReference = this.mArrowToViewRef = targetView != null ? new WeakReference<View>(targetView) : null;
        if (targetView != null) {
            targetView.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        }
    }

    private static BubbleStyle.ArrowDirection getAutoArrowDirection(Rect bubble, Rect target) {
        if (!bubble.intersects(target.left, target.top, target.right, target.bottom)) {
            Point offset = new Point(bubble.centerX() - target.centerX(), bubble.centerY() - target.centerY());
            if (Math.abs(offset.x) < bubble.width() / 2 + target.width() / 2) {
                if (offset.y < 0) {
                    return BubbleStyle.ArrowDirection.Down;
                }
                if (offset.y > 0) {
                    return BubbleStyle.ArrowDirection.Up;
                }
            } else if (Math.abs(offset.y) < bubble.height() / 2 + target.height() / 2) {
                if (offset.x < 0) {
                    return BubbleStyle.ArrowDirection.Right;
                }
                if (offset.x > 0) {
                    return BubbleStyle.ArrowDirection.Left;
                }
            }
        }
        return BubbleStyle.ArrowDirection.None;
    }

    public void setInterceptDrawable(boolean setInteceptDrawable) {
        this.mInterceptDrawable = setInteceptDrawable;
    }
}

