/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.auto;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import com.yy.appbase.R;

public class AutoAdjustHelper {
    private String mAutoAdjustTypeStr;
    private int mAutoAdjustType;
    private float mScale = 1.0f;
    public static final int AUTO_ADJUST_NONE = 0;
    public static final int AUTO_ADJUST_WIDTH = 1;
    public static final int AUTO_ADJUST_HEIGHT = 2;
    public static final int AUTO_ADJUST_SCALE_WIDTH = 3;
    public static final int AUTO_ADJUST_SCALE_HEIGHT = 4;
    private static final String STR_AUTO_ADJUST_WIDTH = "auto_adjust_width";
    private static final String STR_AUTO_ADJUST_HEIGHT = "auto_adjust_height";
    private static final String STR_AUTO_ADJUST_SCALE_WIDTH = "auto_adjust_scale_width";
    private static final String STR_AUTO_ADJUST_SCALE_HEIGHT = "auto_adjust_scale_height";
    private int mRelativeWidth;
    private int mRelativeHeight;
    private int mViewWidth;
    private int mViewHeight;
    private int mViewWidthSpec;
    private int mViewHeightSpec;

    public void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray types = context.obtainStyledAttributes(attrs, R.styleable.auto_adjust_imageview);
            this.mAutoAdjustTypeStr = types.getString(R.styleable.auto_adjust_imageview_adjustType);
            this.mAutoAdjustType = STR_AUTO_ADJUST_WIDTH.equals(this.mAutoAdjustTypeStr) ? 1 : (STR_AUTO_ADJUST_HEIGHT.equals(this.mAutoAdjustTypeStr) ? 2 : (STR_AUTO_ADJUST_SCALE_WIDTH.equals(this.mAutoAdjustTypeStr) ? 3 : (STR_AUTO_ADJUST_SCALE_HEIGHT.equals(this.mAutoAdjustTypeStr) ? 4 : 0)));
            this.mScale = types.getFloat(R.styleable.auto_adjust_imageview_scaleRate, 1.0f);
            types.recycle();
        }
    }

    public void setScale(float mScale) {
        this.mScale = mScale;
    }

    public void setAdjustType(int type2) {
        this.mAutoAdjustType = type2;
    }

    public void setRelativeWidth(int relativeWidth) {
        this.mRelativeWidth = relativeWidth;
    }

    public void setRelativeHeight(int relativeHeight) {
        this.mRelativeHeight = relativeHeight;
    }

    public int getWidth() {
        return this.mViewWidth;
    }

    public int getHeight() {
        return this.mViewHeight;
    }

    public int getWidthSpec() {
        return this.mViewWidthSpec;
    }

    public int getHeightSpec() {
        return this.mViewHeightSpec;
    }

    public void onMeasureView(int widthMeasureSpec, int heightMeasureSpec) {
        int viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float customizeScale = 0.0f;
        switch (this.mAutoAdjustType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.mRelativeWidth == 0 || this.mRelativeHeight == 0) break;
                customizeScale = (float)this.mRelativeWidth / (float)this.mRelativeHeight;
                viewWidth = (int)((float)viewHeight * customizeScale);
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)viewWidth, (int)0x40000000);
                break;
            }
            case 2: {
                if (this.mRelativeWidth == 0 || this.mRelativeHeight == 0) break;
                customizeScale = (float)this.mRelativeWidth / (float)this.mRelativeHeight;
                viewHeight = (int)((float)viewWidth / customizeScale);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)viewHeight, (int)0x40000000);
                break;
            }
            case 3: {
                viewWidth = (int)((float)viewHeight * this.mScale);
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)viewWidth, (int)0x40000000);
                break;
            }
            case 4: {
                viewHeight = (int)((float)viewWidth / this.mScale);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)viewHeight, (int)0x40000000);
                break;
            }
        }
        this.mViewWidth = viewWidth;
        this.mViewHeight = viewHeight;
        this.mViewWidthSpec = widthMeasureSpec;
        this.mViewHeightSpec = heightMeasureSpec;
    }
}

