/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYTextView;
import java.lang.reflect.Field;

public class StrokeTextView
extends YYTextView {
    private TextPaint mTextPaint = this.getPaint();
    private int mInnerColor;
    private int mOuterColor;
    private float mStrokeWidth = 1.0f;

    public StrokeTextView(Context context, int outerColor, int innnerColor) {
        super(context);
        this.mInnerColor = innnerColor;
        this.mOuterColor = outerColor;
    }

    public StrokeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StrokeTextView);
        this.mInnerColor = a.getColor(R.styleable.StrokeTextView_innnerColor, 0xFFFFFF);
        this.mOuterColor = a.getColor(R.styleable.StrokeTextView_outerColor, 0xFFFFFF);
        this.mStrokeWidth = a.getDimension(R.styleable.StrokeTextView_stroke_text_width, 1.0f);
    }

    protected void onDraw(Canvas canvas) {
        this.setTextColorUseReflection(this.mOuterColor);
        this.mTextPaint.setStrokeWidth(this.mStrokeWidth);
        this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mTextPaint.setFakeBoldText(true);
        this.mTextPaint.setShadowLayer(1.0f, 0.0f, 0.0f, 0);
        super.onDraw(canvas);
        this.setTextColorUseReflection(this.mInnerColor);
        this.mTextPaint.setStrokeWidth(0.0f);
        this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mTextPaint.setFakeBoldText(false);
        this.mTextPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        super.onDraw(canvas);
    }

    private void setTextColorUseReflection(int color2) {
        try {
            Field textColorField = TextView.class.getDeclaredField("mCurTextColor");
            textColorField.setAccessible(true);
            textColorField.set((Object)this, color2);
            textColorField.setAccessible(false);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.mTextPaint.setColor(color2);
    }

    public void setColor(@ColorInt int innerColor, @ColorInt int outerColor) {
        this.mInnerColor = innerColor;
        this.mOuterColor = outerColor;
        this.invalidate();
    }
}

