/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYFrameLayout;

public class RoundFrameLayout
extends YYFrameLayout {
    private float roundRadius = 0.0f;
    private boolean isDirty = true;
    private ViewOutlineProvider outlineProvider;

    public RoundFrameLayout(Context context) {
        this(context, null);
    }

    public RoundFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundFrameLayout);
            this.roundRadius = a.getDimensionPixelSize(R.styleable.RoundFrameLayout_RoundFrameLayout_radius, 0);
            a.recycle();
        }
    }

    public void setRoundRadius(float radius) {
        this.isDirty = true;
        this.updateRadius(radius);
    }

    public float getRoundRadius() {
        return this.roundRadius;
    }

    private void updateRadius(final float roundRadius) {
        if (!this.isDirty) {
            return;
        }
        if (!this.isBeforeLollipop()) {
            final int width = this.getWidth();
            final int height = this.getHeight();
            if (width == 0 || height == 0 || roundRadius <= 0.0f) {
                if (this.outlineProvider != null) {
                    this.outlineProvider = null;
                    this.setOutlineProvider(null);
                }
                this.setClipToOutline(false);
            } else {
                this.outlineProvider = new ViewOutlineProvider(){

                    public void getOutline(View view, Outline outline) {
                        outline.setRoundRect(0, 0, width, height, roundRadius);
                    }
                };
                this.setClipToOutline(true);
                this.setOutlineProvider(this.outlineProvider);
            }
        }
        this.roundRadius = Math.max(roundRadius, 0.0f);
        this.isDirty = false;
        this.postInvalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.isDirty = true;
        }
        this.updateRadius(this.roundRadius);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.isBeforeLollipop()) {
            Path path = new Path();
            path.addRoundRect(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.roundRadius, this.roundRadius, Path.Direction.CW);
            canvas.clipPath(path, Region.Op.INTERSECT);
        }
        super.dispatchDraw(canvas);
    }

    private boolean isBeforeLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }
}

