/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewStub;
import androidx.annotation.IdRes;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.base.utils.LanguageUtils;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.dyres.inner.DResource;
import org.jetbrains.annotations.NotNull;

public class NewTagSvgaPlayer<T> {
    private static final int DEFAULT_LOOP_COUNT = 3;
    @IdRes
    private int mSvgaAnimStubId;
    private SVGAImageView mSVGAImageView;
    private View mItemView;
    private DResource mSvgaFileName;
    private int mLoopCount = 3;
    private boolean clearsAfterStop = true;
    private SVGAImageView.FillMode mFillMode;
    private int mVisibility = 0;
    private boolean mCanPlayAnim = false;
    private boolean isAutoRtlRotate = true;

    public NewTagSvgaPlayer(View itemView, @IdRes int svgaAnimStub, DResource svgaFileName) {
        this.mItemView = itemView;
        this.mSvgaAnimStubId = svgaAnimStub;
        this.mSvgaFileName = svgaFileName;
    }

    public void setLoopCount(int loopCount) {
        this.mLoopCount = loopCount;
    }

    public void setClearsAfterStop(boolean clearsAfterStop) {
        this.clearsAfterStop = clearsAfterStop;
    }

    public void setFillMode(SVGAImageView.FillMode fillMode) {
        this.mFillMode = fillMode;
    }

    public void updateNewTag(boolean canPlayAnim) {
        if (this.mSvgaFileName == null) {
            return;
        }
        if (canPlayAnim) {
            DyResLoader.INSTANCE.getResFilePath(this.mSvgaFileName, new IDRCallback(){

                public void onFailed(@NotNull String msg) {
                }

                public void onSucceed(@NotNull String filePath) {
                    NewTagSvgaPlayer.this.startAnimation(filePath);
                }
            });
        } else if (this.mSVGAImageView != null) {
            this.mSVGAImageView.stopAnimation();
        }
    }

    private void startAnimation(String svgaFileName) {
        if (TextUtils.isEmpty((CharSequence)svgaFileName)) {
            return;
        }
        if (this.mSVGAImageView == null) {
            this.mSVGAImageView = this.getSvgaView();
            if (this.mSVGAImageView != null) {
                this.mSVGAImageView.setLoops(this.mLoopCount);
                this.mSVGAImageView.setClearsAfterStop(this.clearsAfterStop);
                if (this.mFillMode != null) {
                    this.mSVGAImageView.setFillMode(this.mFillMode);
                }
                SvgaLoader.load((SVGAImageView)this.mSVGAImageView, (String)svgaFileName, (boolean)true);
            }
        } else {
            this.mSVGAImageView.setClearsAfterStop(this.clearsAfterStop);
            this.mSVGAImageView.setLoops(this.mLoopCount);
            if (this.mFillMode != null) {
                this.mSVGAImageView.setFillMode(this.mFillMode);
            }
            SvgaLoader.load((SVGAImageView)this.mSVGAImageView, (String)svgaFileName, (boolean)true);
        }
    }

    protected SVGAImageView getSvgaView() {
        if (this.mSVGAImageView == null) {
            ViewStub stub = (ViewStub)this.mItemView.findViewById(this.mSvgaAnimStubId);
            this.mSVGAImageView = (SVGAImageView)stub.inflate();
            if (this.mSVGAImageView != null && LanguageUtils.isRtl()) {
                this.mSVGAImageView.setRotationY(this.isAutoRtlRotate ? 180.0f : 0.0f);
            }
        }
        this.setVisible(this.mVisibility);
        return this.mSVGAImageView;
    }

    public void setVisible(int visibility) {
        if (this.mSVGAImageView != null) {
            this.mSVGAImageView.setVisibility(visibility);
        }
        this.mVisibility = visibility;
    }

    public void setAutoRtlRotate(boolean autoRtlRotate) {
        this.isAutoRtlRotate = autoRtlRotate;
    }
}

