/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYView;
import java.util.ArrayList;
import java.util.List;

public class LoadingView
extends YYView
implements Runnable {
    private static final String TAG = "LoadingView";
    private static final int DEFAULT_NUMBER = 3;
    private static final int DEFAULT_FLASH_TIME = 250;
    private static final int DEFAULT_RADIUS = LoadingView.dip2px(RuntimeContext.sApplicationContext, 5.0f);
    private static final int DEFAULT_SPACE = LoadingView.dip2px(RuntimeContext.sApplicationContext, 5.0f);
    private static final int DEFAULT_COLOR = -65536;
    private float radius = DEFAULT_RADIUS;
    private float space = DEFAULT_SPACE;
    private int color = -65536;
    private int number = 3;
    private int flashTime = 250;
    private Paint paint;
    private Handler handler = new Handler(Looper.getMainLooper());
    private List<Integer> alphaDrawValues = new ArrayList<Integer>(3);

    public LoadingView(Context context) {
        super(context);
        this.init(context, null);
    }

    public LoadingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public LoadingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
            this.radius = ta.getDimension(R.styleable.LoadingView_lv_radius, (float)DEFAULT_RADIUS);
            this.space = ta.getDimension(R.styleable.LoadingView_lv_space, (float)DEFAULT_SPACE);
            this.color = ta.getColor(R.styleable.LoadingView_lv_color, -65536);
            this.number = ta.getInt(R.styleable.LoadingView_lv_number, 3);
            this.flashTime = ta.getInt(R.styleable.LoadingView_lv_flashTime, 250);
            ta.recycle();
        }
        if (this.number <= 0) {
            this.number = 3;
        }
        if (this.flashTime <= 0) {
            this.flashTime = 500;
        }
        for (int i = 0; i < this.number; ++i) {
            this.alphaDrawValues.add((int)((float)i / (float)this.number * 235.0f) + 20);
        }
        this.paint = new Paint();
        if (this.color > 0) {
            this.paint.setColor(this.color);
        }
        this.paint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = (int)(this.radius * 2.0f * (float)this.number + this.space * (float)(this.number - 1)) + this.getPaddingLeft() + this.getPaddingRight();
        int height = (int)(this.radius * 2.0f + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.number; ++i) {
            this.paint.setColor(Color.argb((int)this.alphaDrawValues.get(i), (int)Color.red((int)this.color), (int)Color.green((int)this.color), (int)Color.blue((int)this.color)));
            canvas.drawCircle((float)this.getPaddingLeft() + this.radius + this.radius * 2.0f * (float)i + this.space * (float)i, (float)(this.getHeight() / 2), this.radius, this.paint);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.handler == null) {
            return;
        }
        if (this.getVisibility() == 0) {
            this.handler.removeCallbacks((Runnable)this);
            this.run();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.handler == null) {
            return;
        }
        super.onDetachedFromWindow();
        this.handler.removeCallbacks((Runnable)this);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.handler == null) {
            return;
        }
        if (visibility == 0) {
            this.handler.removeCallbacks((Runnable)this);
            this.run();
        } else {
            this.handler.removeCallbacks((Runnable)this);
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.handler == null) {
            return;
        }
        if (visibility == 0) {
            this.handler.removeCallbacks((Runnable)this);
            this.run();
        } else {
            this.handler.removeCallbacks((Runnable)this);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.handler == null) {
            return;
        }
        if (hasWindowFocus) {
            this.handler.removeCallbacks((Runnable)this);
            this.run();
        } else {
            this.handler.removeCallbacks((Runnable)this);
        }
    }

    @Override
    public void run() {
        if (!this.alphaDrawValues.isEmpty()) {
            int alphaEnd = this.alphaDrawValues.remove(this.alphaDrawValues.size() - 1);
            this.alphaDrawValues.add(0, alphaEnd);
            this.invalidate();
            if (this.handler != null) {
                this.handler.postDelayed((Runnable)this, (long)this.flashTime);
            }
        }
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidate();
    }

    public void setSpace(float space) {
        this.space = space;
        this.invalidate();
    }

    public void setColor(int color2) {
        this.color = color2;
        this.paint.setColor(color2);
        this.invalidate();
    }

    public void setNumber(int number) {
        if (number <= 0) {
            number = 3;
        }
        this.number = number;
        this.alphaDrawValues.clear();
        for (int i = 0; i < number; ++i) {
            this.alphaDrawValues.add((int)((float)i / (float)number * 235.0f) + 20);
        }
        this.invalidate();
    }

    public void setFlashTime(int flashTime) {
        if (flashTime <= 0) {
            flashTime = 500;
        }
        this.flashTime = flashTime;
    }
}

