/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.google.gson.Gson;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.R;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.BubbleTextView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.SvgaLoader;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class FingerGuideView
extends YYRelativeLayout
implements View.OnClickListener {
    private static final String TAG = "FingerGuideView";
    private static final String SVGA_URL = "home_game_guide_b.svga";
    private static final long SHOW_TIME_LIMIT = 5000L;
    @NonNull
    private final String mSvgaUrl;
    @IntRange(from=0L)
    private final long mShowTime;
    boolean mUseCustomSvgaLocation;
    @Nullable
    private final FingerGuideCallback mCallback;
    private final BoxSize mMarginInfo;
    private final BoxSize mPaddingInfo;
    private View mHighLightView;
    private SVGAImageView mGuideSvga;
    private RectF mAnimRect;
    private Paint mPaint;
    private Path mCardPath;
    private Path mBgPath;
    private boolean mClipPathExceptionHappened = false;
    @Nullable
    private String bubbleText;
    @Nullable
    private BubbleStyle bubbleStyle;
    private int textColor;
    private int mRoundSize = 0;
    @Nullable
    private Offset svgaOffset;
    private int svgaRotation = 0;
    private float svgaRatio = 1.0f;
    private float svgaScale = 1.0f;
    private int svgaSize = 0;
    private View.OnAttachStateChangeListener mHighLightViewAttachStateChangeListener;
    private Runnable mHideGuide = new Runnable(){

        @Override
        public void run() {
            if (FingerGuideView.this.mCallback != null) {
                FingerGuideView.this.mCallback.onTimeoutClose();
            }
            FingerGuideView.this.hideGuide();
        }
    };

    public static Builder of(Context context) {
        return new Builder(context);
    }

    private FingerGuideView(Context context, Builder builder) {
        super(context);
        this.createView(context);
        this.mPaddingInfo = builder.mPaddingInfo;
        this.mMarginInfo = builder.mMarginInfo;
        this.mSvgaUrl = builder.mSvgaUrl;
        this.mShowTime = builder.mShowTime;
        this.mUseCustomSvgaLocation = builder.mUseCustomSvgaLocation;
        this.mCallback = builder.mCallback;
        this.bubbleText = builder.bubbleText;
        this.textColor = builder.textColor;
        this.bubbleStyle = builder.bubbleStyle;
        this.mRoundSize = builder.mRoundSize;
        this.svgaOffset = builder.svgaOffset;
        this.svgaRotation = builder.svgaRotation;
        this.svgaRatio = builder.svgaRatio;
        this.svgaScale = builder.svgaScale;
        this.svgaSize = builder.svgaSize;
        if (!FP.empty((CharSequence)builder.bubbleText) && this.bubbleStyle == null) {
            BubbleTextView bubbleTextView = (BubbleTextView)this.findViewById(R.id.bubbleTextView);
            bubbleTextView.setFillColor(builder.bubbleColor);
            bubbleTextView.setText(this.bubbleText);
            if (this.textColor != 0) {
                bubbleTextView.setTextColor(this.textColor);
            }
            this.bubbleStyle = bubbleTextView;
        }
        if (this.bubbleStyle instanceof View && builder.bubbleMargin != null) {
            BoxSize margin = builder.bubbleMargin;
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)((View)this.bubbleStyle).getLayoutParams();
            LayoutUtil.setMargins((ViewGroup.MarginLayoutParams)params, margin.left, margin.top, margin.right, margin.bottom);
            this.addView((View)this.bubbleStyle, (ViewGroup.LayoutParams)params);
        }
    }

    private void createView(Context context) {
        if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        FingerGuideView.inflate((Context)context, (int)R.layout.common_guide_view, (ViewGroup)this);
        this.mGuideSvga = (SVGAImageView)this.findViewById(R.id.guideSvga);
        this.setOnClickListener(this);
        this.mGuideSvga.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v == this) {
            YYTaskExecutor.removeTask((Runnable)this.mHideGuide);
            this.hideGuide();
            if (this.mCallback != null) {
                this.mCallback.onOutSideClick();
            }
        } else if (v == this.mGuideSvga) {
            YYTaskExecutor.removeTask((Runnable)this.mHideGuide);
            this.hideGuide();
            if (this.mCallback != null) {
                this.mCallback.onCardClick(this.mHighLightView);
            }
        }
    }

    public void startGuide(View highLightView) {
        this.startGuide(highLightView, this.mPaddingInfo.getLeft(), this.mPaddingInfo.getTop(), this.mPaddingInfo.getRight(), this.mPaddingInfo.getBottom());
    }

    public void startGuide(View highLightView, int leftSpace, int topSpace, int rightSpace, int bottomSpace) {
        if (this.isCover(highLightView)) {
            MLog.info((Object)TAG, (String)"startGuide highLightView isCover return", (Object[])new Object[0]);
            return;
        }
        MLog.debug((Object)TAG, (String)"startGuide highLightView %s", (Object[])new Object[]{highLightView});
        if (this.mHighLightView != null && this.mHighLightViewAttachStateChangeListener != null) {
            this.mHighLightView.removeOnAttachStateChangeListener(this.mHighLightViewAttachStateChangeListener);
        }
        this.mHighLightView = highLightView;
        this.mHighLightViewAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                MLog.info((Object)FingerGuideView.TAG, (String)"startGuide onViewDetachedFromWindow v %s, mHighLightView %s", (Object[])new Object[]{v, FingerGuideView.this.mHighLightView});
                YYTaskExecutor.postToMainThread(() -> {
                    if (v == FingerGuideView.this.mHighLightView && FingerGuideView.this.mHighLightView != null && FingerGuideView.this.mHighLightView.getParent() == null && FingerGuideView.this.getParent() != null && 0 == FingerGuideView.this.getVisibility()) {
                        if (FingerGuideView.this.mCallback != null) {
                            FingerGuideView.this.mCallback.onTimeoutClose();
                        }
                        FingerGuideView.this.hideGuide();
                    }
                }, (long)2000L);
            }
        };
        this.mHighLightView.addOnAttachStateChangeListener(this.mHighLightViewAttachStateChangeListener);
        int[] location = new int[2];
        highLightView.getLocationInWindow(location);
        int[] myLocation = new int[2];
        this.getLocationInWindow(myLocation);
        MLog.info((Object)TAG, (String)"startGuide location highLightView: %s, guide view: %s, space: %d,%d,%d,%d", (Object[])new Object[]{Arrays.toString(location), Arrays.toString(myLocation), leftSpace, topSpace, rightSpace, bottomSpace});
        int left = Math.max(0, location[0] - myLocation[0] - leftSpace) + this.mMarginInfo.getLeft() - this.mMarginInfo.getRight();
        int top = Math.max(0, location[1] - myLocation[1] - topSpace) + this.mMarginInfo.getTop() - this.mMarginInfo.getBottom();
        int width = highLightView.getWidth() + leftSpace + rightSpace;
        int height = highLightView.getHeight() + topSpace + bottomSpace;
        RectF tempRect = new RectF((float)left, (float)top, (float)(left + width), (float)(top + height));
        MLog.info((Object)TAG, (String)"startGuide mAnimRect mAnimRect %s, newRect %s", (Object[])new Object[]{this.mAnimRect, tempRect});
        if (tempRect.equals((Object)this.mAnimRect)) {
            MLog.info((Object)TAG, (String)"startGuide animRect \u6ca1\u53d8\u5316\uff0c\u4e0d\u5237\u65b0", (Object[])new Object[0]);
            return;
        }
        this.mAnimRect = tempRect;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(Color.argb((int)128, (int)0, (int)0, (int)0));
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mCardPath = new Path();
        this.mBgPath = new Path();
        this.setAlpha(1.0f);
        this.setVisibility(0);
        this.post(() -> {
            RelativeLayout.LayoutParams params = this.calculateSvgaLocation(this.mUseCustomSvgaLocation, width, (int)((float)height * this.svgaRatio));
            this.mGuideSvga.setLayoutParams((ViewGroup.LayoutParams)params);
            if (!FP.empty((CharSequence)this.mSvgaUrl)) {
                SvgaLoader.load((SVGAImageView)this.mGuideSvga, (String)this.mSvgaUrl, (boolean)true);
            }
            this.showBubble();
        });
        this.checkHide();
    }

    private boolean isCover(View view) {
        try {
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                return rect.width() < view.getMeasuredWidth() || rect.height() < view.getMeasuredHeight();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void showBubble() {
        this.post(() -> {
            if (this.bubbleStyle instanceof View) {
                View bubble = (View)this.bubbleStyle;
                bubble.setVisibility(0);
                bubble.invalidate();
            }
        });
    }

    public BubbleStyle getBubbleStyle() {
        return this.bubbleStyle;
    }

    private RelativeLayout.LayoutParams calculateSvgaLocation(boolean useCustomSvgaLocation, int defaultSvgaWidth, int defaultSvgaHeight) {
        RelativeLayout.LayoutParams svga = (RelativeLayout.LayoutParams)this.mGuideSvga.getLayoutParams();
        if (useCustomSvgaLocation) {
            svga.topMargin = (int)this.mAnimRect.top - this.getTop() - ResolutionUtils.dip2Px((float)46.0f);
            svga.addRule(21);
            svga.rightMargin = ResolutionUtils.dip2Px((float)12.0f);
            svga.width = ResolutionUtils.dip2Px((float)120.0f);
            svga.height = ResolutionUtils.dip2Px((float)140.0f);
        } else {
            svga.topMargin = (int)this.mAnimRect.top - this.getTop() + ResolutionUtils.dip2Px((float)24.0f) + (this.svgaOffset != null ? this.svgaOffset.y : 0);
            svga.setMarginStart((this.svgaOffset != null ? this.svgaOffset.x : 0) + (int)this.mAnimRect.left);
            if (this.svgaSize != 0) {
                svga.width = (int)((float)this.svgaSize * this.svgaScale);
                svga.height = (int)((float)this.svgaSize * this.svgaScale);
            } else {
                svga.width = (int)((float)defaultSvgaWidth * this.svgaScale);
                svga.height = (int)((float)defaultSvgaHeight * this.svgaScale);
            }
            this.mGuideSvga.setRotation((float)this.svgaRotation);
        }
        if (RuntimeContext.isLocalBuild()) {
            MLog.debug((Object)TAG, (String)"calculateSvgaLocation %s", (Object[])new Object[]{svga, new Gson().toJson((Object)svga)});
            MLog.debug((Object)TAG, (String)"calculateSvgaLocation left:%s, toP:%s, right:%s, bottom:%s", (Object[])new Object[]{svga.leftMargin, svga.topMargin, svga.leftMargin, svga.bottomMargin});
        }
        return svga;
    }

    public void checkHide() {
        if (this.getVisibility() == 0) {
            YYTaskExecutor.removeTask((Runnable)this.mHideGuide);
            YYTaskExecutor.postToMainThread((Runnable)this.mHideGuide, (long)this.mShowTime);
        }
    }

    private void hideGuide() {
        MLog.info((Object)TAG, (String)"hideGuide", (Object[])new Object[0]);
        if (this.mHighLightView != null && this.mHighLightViewAttachStateChangeListener != null) {
            this.mHighLightView.removeOnAttachStateChangeListener(this.mHighLightViewAttachStateChangeListener);
            this.mHighLightViewAttachStateChangeListener = null;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        objectAnimator.setDuration(200L);
        objectAnimator.start();
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FingerGuideView.this.mGuideSvga.stopAnimation();
                FingerGuideView.this.setVisibility(8);
                if (FingerGuideView.this.getParent() instanceof ViewGroup) {
                    ViewGroup parent = (ViewGroup)FingerGuideView.this.getParent();
                    parent.removeView((View)FingerGuideView.this);
                }
                if (FingerGuideView.this.mCallback != null) {
                    FingerGuideView.this.mCallback.onGuideHide();
                }
            }
        });
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mPaint != null && this.mAnimRect != null) {
            MLog.debug((Object)TAG, (String)"dispatchDraw AnimRect: %s", (Object[])new Object[]{this.mAnimRect});
            this.mCardPath.rewind();
            this.mBgPath.rewind();
            this.mBgPath.addRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), Path.Direction.CW);
            if (this.mRoundSize > 0) {
                this.mCardPath.addRoundRect(this.mAnimRect, (float)this.mRoundSize, (float)this.mRoundSize, Path.Direction.CW);
            } else {
                this.mCardPath.addRect(this.mAnimRect, Path.Direction.CW);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                this.mCardPath.op(this.mBgPath, Path.Op.REVERSE_DIFFERENCE);
                canvas.drawPath(this.mCardPath, this.mPaint);
            } else if (!this.mClipPathExceptionHappened) {
                try {
                    canvas.save();
                    canvas.clipPath(this.mCardPath, Region.Op.XOR);
                    canvas.drawPaint(this.mPaint);
                    canvas.restore();
                }
                catch (UnsupportedOperationException e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    this.mClipPathExceptionHappened = true;
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    public static class Offset {
        private int x;
        private int y;

        public Offset(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class BoxSize {
        private int left;
        private int top;
        private int right;
        private int bottom;

        public static BoxSize of(int left, int top, int right, int bottom) {
            BoxSize size = new BoxSize();
            size.left = left;
            size.top = top;
            size.right = right;
            size.bottom = bottom;
            return size;
        }

        private void setAll(int all) {
            this.left = all;
            this.top = all;
            this.right = all;
            this.bottom = all;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public void setTop(int top) {
            this.top = top;
        }

        public void setRight(int right) {
            this.right = right;
        }

        public void setBottom(int bottom) {
            this.bottom = bottom;
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getRight() {
            return this.right;
        }

        public int getBottom() {
            return this.bottom;
        }
    }

    public static final class Builder {
        @NonNull
        private String mSvgaUrl = "home_game_guide_b.svga";
        private long mShowTime = 5000L;
        @Nullable
        private FingerGuideCallback mCallback;
        @NonNull
        private final Context mContext;
        private BoxSize mMarginInfo;
        private BoxSize mPaddingInfo;
        private boolean mUseCustomSvgaLocation;
        private String bubbleText;
        private int textColor;
        private BubbleStyle bubbleStyle;
        @ColorInt
        private int bubbleColor = Color.parseColor((String)"#00CB68");
        private BoxSize bubbleMargin;
        private int mRoundSize = 0;
        private Offset svgaOffset = null;
        private int svgaRotation = 0;
        private float svgaRatio = 1.0f;
        private float svgaScale = 1.0f;
        private int svgaSize = 0;

        private Builder(@NotNull Context context) {
            this.mContext = context;
            this.mMarginInfo = new BoxSize();
            this.mPaddingInfo = new BoxSize();
        }

        public Builder svga(String url) {
            this.mSvgaUrl = url;
            return this;
        }

        public Builder showTime(long showTime) {
            this.mShowTime = showTime;
            return this;
        }

        public Builder callback(FingerGuideCallback callback) {
            this.mCallback = callback;
            return this;
        }

        public Builder margin(int margin) {
            this.mMarginInfo.setAll(margin);
            return this;
        }

        public Builder leftMargin(int margin) {
            this.mMarginInfo.setLeft(margin);
            return this;
        }

        public Builder topMargin(int margin) {
            this.mMarginInfo.setTop(margin);
            return this;
        }

        public Builder rightMargin(int margin) {
            this.mMarginInfo.setRight(margin);
            return this;
        }

        public Builder bottomMargin(int margin) {
            this.mMarginInfo.setBottom(margin);
            return this;
        }

        public Builder padding(int padding) {
            this.mPaddingInfo.setAll(padding);
            return this;
        }

        public Builder leftPadding(int padding) {
            this.mPaddingInfo.setLeft(padding);
            return this;
        }

        public Builder bottomPadding(int padding) {
            this.mPaddingInfo.setBottom(padding);
            return this;
        }

        public Builder rightPadding(int padding) {
            this.mPaddingInfo.setRight(padding);
            return this;
        }

        public Builder topPadding(int padding) {
            this.mPaddingInfo.setTop(padding);
            return this;
        }

        public Builder useCustomSvgaLocation(boolean useCustomSvgaLocation) {
            this.mUseCustomSvgaLocation = useCustomSvgaLocation;
            return this;
        }

        public Builder bubbleText(String text) {
            this.bubbleText = text;
            return this;
        }

        public Builder bubbleText(@StringRes int id2) {
            return this.bubbleText(ResourceUtils.getString((int)id2));
        }

        public Builder bubbleColor(@ColorInt int color2) {
            this.bubbleColor = color2;
            return this;
        }

        public Builder textColor(@ColorInt int color2) {
            this.textColor = color2;
            return this;
        }

        public Builder bubbleStyle(BubbleStyle style2) {
            this.bubbleStyle = style2;
            return this;
        }

        public Builder bubbleMargin(BoxSize margin) {
            this.bubbleMargin = margin;
            return this;
        }

        public Builder setRoundSize(int roundSize) {
            this.mRoundSize = roundSize;
            return this;
        }

        public Builder svgaOffset(Offset offset) {
            this.svgaOffset = offset;
            return this;
        }

        public Builder svgaRotation(int rotation) {
            this.svgaRotation = rotation;
            return this;
        }

        public Builder svgaRatio(float ratio) {
            this.svgaRatio = ratio;
            return this;
        }

        public Builder svgaScale(float scale) {
            this.svgaScale = scale;
            return this;
        }

        public Builder svgaSize(int size) {
            this.svgaSize = size;
            return this;
        }

        public FingerGuideView build() {
            return new FingerGuideView(this.mContext, this);
        }
    }

    public static interface FingerGuideCallback {
        default public void onGuideHide() {
        }

        public void onCardClick(View var1);

        default public void onOutSideClick() {
        }

        default public void onTimeoutClose() {
        }
    }
}

