/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYFrameLayout;

public class DoubleLayout
extends YYFrameLayout {
    private ViewAdapter mViewAdapter;

    public DoubleLayout(@NonNull Context context) {
        super(context);
    }

    public DoubleLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DoubleLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setViewAdapter(ViewAdapter viewAdapter) {
        this.mViewAdapter = viewAdapter;
        this.notifyDataSetChange();
    }

    public void notifyDataSetChange() {
        int itemCount;
        if (this.mViewAdapter == null) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount < (itemCount = this.mViewAdapter.getItemCount())) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            for (int i = childCount; i < itemCount; ++i) {
                this.addView(this.mViewAdapter.onCreateView(inflater));
            }
        } else if (childCount > itemCount) {
            for (int i = childCount - 1; i >= itemCount; ++i) {
                this.removeViewAt(i);
            }
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.mViewAdapter.onBindView(i, this.getChildAt(i));
        }
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        if (this.getChildCount() != 0) {
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                v.measure(View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)widthMeasureSpec) / 2), (int)0x40000000), 0);
            }
            int height = this.getChildAt(0).getMeasuredHeight() * (int)Math.ceil((float)this.getChildCount() / 2.0f);
            this.setMeasuredDimension(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildAt(0) == null) {
            return;
        }
        int w = this.getMeasuredWidth();
        int itemW = w / 2;
        int itemH = this.getChildAt(0).getMeasuredHeight();
        int line = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int isLeft = i % 2;
            int l = isLeft * itemW;
            int t = line * itemH;
            if (isLeft == 1) {
                ++line;
            }
            View v = this.getChildAt(i);
            v.layout(l, t, l + itemW, t + itemH);
        }
    }

    public static interface ViewAdapter {
        public int getItemCount();

        public View onCreateView(LayoutInflater var1);

        public void onBindView(int var1, View var2);
    }
}

