/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;

public class BiasPlayerContainer
extends YYFrameLayout {
    private int videoWidth = -1;
    private int videoHeight = -1;
    private float verticalBias = 0.5f;

    public BiasPlayerContainer(@NonNull Context context) {
        this(context, null);
    }

    public BiasPlayerContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        if (this.videoWidth == -1 && this.videoHeight == -1) {
            super.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec);
        } else {
            int childHeight;
            int childWidth;
            int parentHeight;
            int parentWidth = View.MeasureSpec.getSize((int)parentWidthMeasureSpec);
            if (this.videoHeight * parentWidth > (parentHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec)) * this.videoWidth) {
                childWidth = parentWidth - this.getPaddingLeft() - this.getPaddingRight();
                childHeight = this.videoHeight * childWidth / this.videoWidth;
            } else {
                childHeight = parentHeight - this.getPaddingTop() - this.getPaddingBottom();
                childWidth = this.videoWidth * childHeight / this.videoHeight;
            }
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        if (this.videoWidth == -1 && this.videoHeight == -1) {
            super.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec);
        } else {
            int childHeight;
            int childWidth;
            int parentHeight;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int parentWidth = View.MeasureSpec.getSize((int)parentWidthMeasureSpec) - widthUsed - lp.leftMargin - lp.rightMargin;
            if (this.videoHeight * parentWidth > (parentHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec) - heightUsed - lp.topMargin - lp.bottomMargin) * this.videoWidth) {
                childWidth = parentWidth - this.getPaddingLeft() - this.getPaddingRight();
                childHeight = this.videoHeight * childWidth / this.videoWidth;
            } else {
                childHeight = parentHeight - this.getPaddingTop() - this.getPaddingBottom();
                childWidth = this.videoWidth * childHeight / this.videoHeight;
            }
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.getChildCount() > 1 && RuntimeContext.sIsDebuggable) {
            throw new IllegalStateException("BiasPlayerContainer only hold one child!!");
        }
        View player = this.getChildAt(0);
        int playerWidth = player.getMeasuredWidth();
        int playerHeight = player.getMeasuredHeight();
        int parentLeft = this.getPaddingLeft();
        int parentRight = right - left - this.getPaddingRight();
        int parentWidth = parentRight - parentLeft;
        int parentTop = this.getPaddingTop();
        int parentBottom = bottom - top - this.getPaddingBottom();
        int parentHeight = parentBottom - parentTop;
        int overWidth = playerWidth - parentWidth;
        int overHeight = playerHeight - parentHeight;
        int marginHeight = -((int)((float)overHeight * this.verticalBias));
        int childTop = parentTop + marginHeight;
        int childBottom = childTop + playerHeight;
        int marginWidth = -((int)((float)overWidth * 0.5f));
        int childLeft = parentLeft + marginWidth;
        int childRight = childLeft + playerWidth;
        player.layout(childLeft, childTop, childRight, childBottom);
    }

    public void setVerticalBias(@FloatRange(from=0.0, to=1.0) float bias) {
        if (this.verticalBias == bias) {
            return;
        }
        this.verticalBias = bias;
        this.requestLayout();
        this.invalidate();
    }

    public void setVideoSize(int width, int height) {
        if (this.videoWidth == width && this.videoHeight == height) {
            return;
        }
        this.videoWidth = width;
        this.videoHeight = height;
        this.requestLayout();
        this.invalidate();
    }
}

