/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.webview;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import com.yy.appbase.ui.webview.WebViewPage;
import com.yy.framework.core.ui.BasePanel;

public class WebViewPanel
extends BasePanel {
    private WebViewPage webViewPage;

    public WebViewPanel(Context context) {
        super(context);
        this.createView();
        this.setShowAnim(this.createShowAnim());
        this.setHideAnim(this.createHideAnim());
    }

    private void createView() {
        this.webViewPage = new WebViewPage(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(13);
        this.setContent((View)this.webViewPage, lp);
    }

    public void setData(String url) {
        this.setData(url, 0, 0);
    }

    public void setData(String url, int width, int height) {
        if (this.sizeValidate(width, height)) {
            RelativeLayout.LayoutParams webLP = (RelativeLayout.LayoutParams)this.webViewPage.getLayoutParams();
            webLP.width = width;
            webLP.height = height;
        }
        this.webViewPage.setData(null, url);
    }

    private boolean sizeValidate(int width, int height) {
        return width > 0 && height > 0;
    }

    public void setBottomStyle() {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(12);
        this.setContent((View)this.webViewPage, lp);
        this.setShowAnim(this.createBottomShowAnimation());
        this.setHideAnim(this.createBottomHideAnimation());
    }

    public void setFullScreenStyle() {
        this.webViewPage.setBackground(Color.parseColor((String)"#00000000"));
    }

    protected void onShow() {
        super.onShow();
        this.dimBg(true);
    }

    protected void onHide() {
        super.onHide();
        this.dimBg(false);
        if (this.webViewPage != null) {
            this.webViewPage.destroy();
        }
    }

    private void dimBg(boolean isShow) {
        ValueAnimator animator = isShow ? ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.5f}) : ValueAnimator.ofFloat((float[])new float[]{0.5f, 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int alpha = (int)(((Float)animation.getAnimatedValue()).floatValue() * 255.0f);
                WebViewPanel.this.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
            }
        });
        animator.start();
    }

    private Animation createShowAnim() {
        AnimationSet aniSet = new AnimationSet(false);
        ScaleAnimation scaleAnim = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleAnim.setDuration(100L);
        aniSet.addAnimation((Animation)scaleAnim);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    private Animation createHideAnim() {
        AnimationSet aniSet = new AnimationSet(false);
        ScaleAnimation scaleAnim = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        scaleAnim.setDuration(100L);
        aniSet.addAnimation((Animation)scaleAnim);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }
}

