/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.webview;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.web.IWebManager;
import com.yy.appbase.service.web.IWebManagerCallBack;
import com.yy.appbase.service.web.IWebPageCallback;
import com.yy.appbase.service.web.SimpleWebManagerCallBack;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.webservice.webwindow.webview.base.WebViewReuse;
import com.yy.webservice.webwindow.webview.base.YYWebView;

public class WebViewPage
extends CommonStatusLayout {
    protected IWebManager mWebManager;
    private String mUrl = "";
    protected WebView mWebView;
    private IWebManagerCallBack mWebManagerCallBack;
    private IWebPageCallback mGameWebCallback;

    public WebViewPage(Context context) {
        super(context);
        this.createView(null);
    }

    public WebViewPage(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public WebViewPage(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        YYWebView webView = WebViewReuse.obtainWebView();
        if (webView == null) {
            webView = new YYWebView(this.getContext());
        }
        webView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWebView = webView;
        this.addView((View)this.mWebView);
    }

    protected void initWeb() {
        if (this.mWebManager != null) {
            return;
        }
        this.mWebManagerCallBack = new SimpleWebManagerCallBack(){

            @Override
            public void showLoading() {
                super.showLoading();
                WebViewPage.this.showLoading();
            }

            @Override
            public void showNetError(String originUrl, int errorCode, String description, String url) {
                super.showNetError(originUrl, errorCode, description, url);
                WebViewPage.this.showNetworkError();
                if (WebViewPage.this.mGameWebCallback != null) {
                    WebViewPage.this.mGameWebCallback.showNetError(originUrl, errorCode, description, url);
                }
            }

            @Override
            public void hideStatusView() {
                super.hideStatusView();
                WebViewPage.this.hideAllStatus();
            }

            @Override
            public Activity getActivity() {
                Context context = WebViewPage.this.getContext();
                if (context instanceof ContextThemeWrapper) {
                    Context base = ((ContextThemeWrapper)context).getBaseContext();
                    if (base instanceof Activity) {
                        return (Activity)base;
                    }
                    if (context instanceof Activity) {
                        return (Activity)context;
                    }
                }
                return null;
            }

            @Override
            public void onRefreshComplete(String originUrl, String url) {
                super.onRefreshComplete(originUrl, url);
                WebViewPage.this.hideAllStatus();
                if (WebViewPage.this.mGameWebCallback != null) {
                    WebViewPage.this.mGameWebCallback.onRefreshComplete(originUrl, url);
                }
            }

            @Override
            public void handleExitByWeb() {
                super.handleExitByWeb();
                if (WebViewPage.this.mGameWebCallback != null) {
                    WebViewPage.this.mGameWebCallback.exitWebView();
                }
            }
        };
        this.mWebManager = ServiceManagerProxy.getServiceManager().getService(IWebService.class).createWebManager(this.mWebManagerCallBack, this.mWebView);
        this.mWebManager.onResume();
    }

    public void setData(String title, String url) {
        this.showLoading();
        this.mUrl = url;
        this.initWeb();
        this.mWebManager.loadUrl(this.mUrl);
    }

    public String getOriginUrl() {
        return this.mUrl;
    }

    public void setWebPageCallback(IWebPageCallback callback) {
        this.mGameWebCallback = callback;
    }

    public void destroy() {
        if (this.mWebManager != null) {
            this.mWebManager.destroy();
        }
    }

    public void setBackground(int color2) {
        if (this.mWebView != null) {
            this.mWebView.setBackgroundColor(color2);
        }
    }
}

