/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.utils;

import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.view.MotionEvent;
import android.widget.TextView;
import com.yy.base.logger.MLog;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class CrashCatchLinkMovementMethod
extends LinkMovementMethod {
    private static CrashCatchLinkMovementMethod sInstance = new CrashCatchLinkMovementMethod();
    private static final String TAG = "CrashCatchLinkMovementM";

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        try {
            super.onTouchEvent(widget, buffer, event);
        }
        catch (Exception e) {
            try {
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                x += widget.getScrollX();
                y += widget.getScrollY();
                StringBuilder exBuilder = new StringBuilder(e.toString());
                for (StackTraceElement stack : e.getStackTrace()) {
                    exBuilder.append('\n').append(stack.toString());
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", x);
                statContent.put("ifieldtwo", y);
                statContent.put("sfield", exBuilder.toString());
                statContent.put("sfieldtwo", widget.getText().toString());
                statContent.put("perftype", "exception_link_movement_method");
                HiidoStatis.reportContent((StatisContent)statContent);
                MLog.error((Object)TAG, (Throwable)e);
            }
            catch (Exception ignore) {
                MLog.debug((Object)TAG, (String)"something error again", (Object[])new Object[0]);
            }
        }
        return false;
    }

    public static CrashCatchLinkMovementMethod getInstance() {
        return sInstance;
    }
}

