/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.toast;

import androidx.annotation.ColorInt;
import com.yy.appbase.R;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;

public class TopToastUtils {
    private static final long SHORT_DURATION_TIMEOUT = 4000L;
    public static final long LONG_DURATION_TIMEOUT = 7000L;
    public static final int LOW = 0;
    public static final int MIDDLE = 10;
    public static final int HIGH = 20;
    public static final int SUPER_HIGH = 30;

    public static ToastMessage showErrorToast(CharSequence text, int duration) {
        return TopToastUtils.showToast(text, ResourceUtils.getColor((int)R.color.error_toast_bg), duration, 20);
    }

    public static ToastMessage showErrorToast(CharSequence text, int duration, boolean isShowSingLine) {
        long realDuration = duration == 1 ? 7000L : 4000L;
        return TopToastUtils.showToast(text, ResourceUtils.getColor((int)R.color.error_toast_bg), realDuration, 20, 0.0f, isShowSingLine);
    }

    public static ToastMessage showWarnToast(CharSequence text, int duration, boolean isShowSingleLine) {
        return TopToastUtils.showToast(text, duration, ResourceUtils.getColor((int)R.color.warn_toast_bg), isShowSingleLine);
    }

    public static ToastMessage showSucceedToast(CharSequence text, int duration) {
        return TopToastUtils.showSucceedToast(text, duration, false);
    }

    public static ToastMessage showSucceedToast(CharSequence text, int duration, boolean singleLine) {
        long realDuration = duration == 1 ? 7000L : 4000L;
        return TopToastUtils.showToast(text, ResourceUtils.getColor((int)R.color.normal_toast_bg), realDuration, 0, 0.0f, singleLine);
    }

    public static ToastMessage showToast(CharSequence text, int duration, @ColorInt int bgColor, boolean isShowSingleLine) {
        long realDuration = duration == 1 ? 7000L : 4000L;
        return TopToastUtils.showToast(text, bgColor, realDuration, 20, 0.0f, isShowSingleLine);
    }

    public static ToastMessage showToast(CharSequence text, int duration) {
        return TopToastUtils.showToast(text, ResourceUtils.getColor((int)R.color.warn_toast_bg), duration, 10);
    }

    public static ToastMessage showToast(CharSequence text, @ColorInt int bgColor, int duration, int priority) {
        long realDuration = duration == 1 ? 7000L : 4000L;
        return TopToastUtils.showToast(text, bgColor, realDuration, priority, 0.0f, true);
    }

    public static void showToast(CharSequence text, @ColorInt int bgColor, int duration, float marginTop) {
        long realDuration = duration == 1 ? 7000L : 4000L;
        TopToastUtils.showToast(text, bgColor, realDuration, 10, marginTop, true);
    }

    public static ToastMessage showToast(CharSequence text, @ColorInt int bgColor, long duration, int priority, float marginTop, boolean isShowSingleLine) {
        ToastMessage msg = new ToastMessage();
        msg.msg = text;
        msg.color = bgColor;
        msg.duration = duration;
        msg.priority = priority;
        msg.marginTop = marginTop;
        msg.isShowSignleLine = isShowSingleLine;
        TopToastUtils.notifyToast(msg);
        return msg;
    }

    public static void showToast(ToastMessage msg) {
        if (msg != null) {
            TopToastUtils.notifyToast(msg);
        }
    }

    private static void notifyToast(ToastMessage msg) {
        final Notification notification = Notification.obtain((int)NotificationIdDef.GLOBAL_TOP_TOAST, (Object)msg);
        if (YYTaskExecutor.isMainThread()) {
            NotificationCenter.getGlobalInstance().notify(notification);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().notify(notification);
                }
            });
        }
    }

    public static void removeToast(ToastMessage msg) {
        final Notification notification = Notification.obtain((int)NotificationIdDef.GLOBAL_TOP_TOAST_REMOVE, (Object)msg);
        if (YYTaskExecutor.isMainThread()) {
            NotificationCenter.getGlobalInstance().notify(notification);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().notify(notification);
                }
            });
        }
    }
}

