/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.R;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import java.lang.ref.WeakReference;

public class TimeOutProgressDialog
implements DialogInterface.OnDismissListener {
    private static final String TAG = "TimeOutProgressDialog";
    private WeakReference<Context> mContext;
    private String msg;
    private long time;
    private DialogLinkManager dialogManager;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private Handler handler = new Handler(Looper.myLooper());
    private Runnable processProgressTimeoutTask = new Runnable(){

        @Override
        public void run() {
            if (TimeOutProgressDialog.this.dialogManager != null) {
                TimeOutProgressDialog.this.dialogManager.dismissDialog();
            }
            if (TimeOutProgressDialog.this.mContext != null && TimeOutProgressDialog.this.mContext.get() != null) {
                ToastUtils.showToast((Activity)((Activity)TimeOutProgressDialog.this.mContext.get()), (int)R.string.str_network_not_capable, (int)1);
            }
        }
    };

    public TimeOutProgressDialog(Context context, String msg, long time) {
        this.mContext = new WeakReference<Context>(context);
        this.msg = msg;
        this.time = time;
        this.dialogManager = new DialogLinkManager(context);
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener2) {
        this.mOnDismissListener = listener2;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void showProcessProgress() {
        if (this.dialogManager != null && this.mContext != null && this.mContext.get() != null) {
            this.hideProcessProgress();
            this.dialogManager.showDialog((BaseDialog)new ProgressDialog(this.msg, false, true, this));
            this.handler.postDelayed(this.processProgressTimeoutTask, this.time);
        }
    }

    public void hideProcessProgress() {
        this.handler.removeCallbacks(this.processProgressTimeoutTask);
        if (this.dialogManager != null) {
            this.dialogManager.dismissDialog();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        this.handler.removeCallbacks(this.processProgressTimeoutTask);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }
}

