/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;

public class ProgressDialog
implements BaseDialog {
    private String mMsg;
    private boolean mCancelable;
    private boolean mOutSideCancelable;
    private DialogInterface.OnDismissListener mListener;
    private DialogInterface.OnCancelListener mCancelListener;
    private Dialog mDialog;
    private int mProgressMax = 0;
    private String mTip;
    private TextView mTvTip;
    private SVGAImageView mSvgaLoading;
    private ProgressBar loadingProgress;
    private YYLinearLayout loadingContainerBg;
    private long startTime = 0L;
    private Runnable exceptionCheck;
    private boolean checkDeadLoop = true;
    private RuntimeException startTrackStack;
    private float mDimAmount = -10.0f;

    public ProgressDialog() {
        this("", false, false, null, null);
    }

    public ProgressDialog(String msg, boolean cancelable, boolean outSideCancelable, DialogInterface.OnDismissListener listener2) {
        this(msg, cancelable, outSideCancelable, listener2, null);
    }

    public ProgressDialog(String msg, boolean cancelable, boolean outSideCancelable, DialogInterface.OnDismissListener dismissListener, DialogInterface.OnCancelListener cancelListener) {
        this.mMsg = msg;
        this.mCancelable = cancelable;
        this.mOutSideCancelable = outSideCancelable;
        this.mListener = dismissListener;
        this.mCancelListener = cancelListener;
    }

    public void setDimAmount(float dimAmount) {
        this.mDimAmount = dimAmount;
    }

    public void setCheckDeadLoop(boolean check) {
        this.checkDeadLoop = check;
        if (this.exceptionCheck != null) {
            YYTaskExecutor.removeTask((Runnable)this.exceptionCheck);
        }
    }

    public void init(final Dialog mDialog) {
        this.mDialog = mDialog;
        if (this.mDialog instanceof YYDialog) {
            ((YYDialog)this.mDialog).setDialogID(this.getId());
        }
        if (!this.mCancelable && TextUtils.isEmpty((CharSequence)this.mMsg)) {
            if (RuntimeContext.isInGray()) {
                this.startTrackStack = new RuntimeException("Debug\u5305\uff0c\u76d1\u63a7dialog\u4e0d\u80fd\u6d88\u5931\u7684\u60c5\u51b5");
            }
            if (RuntimeContext.isInGray() && this.checkDeadLoop) {
                this.startTime = System.currentTimeMillis();
                if (this.exceptionCheck != null) {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.exceptionCheck);
                }
                this.exceptionCheck = new Runnable(){

                    @Override
                    public void run() {
                        if (mDialog != null && mDialog.isShowing() && ProgressDialog.this.startTrackStack != null) {
                            MLog.error((Object)"ProgressDialog 30\u79d2\u8fd8\u6ca1\u6709\u6d88\u5931", (Throwable)ProgressDialog.this.startTrackStack);
                        }
                        ProgressDialog.this.exceptionCheck = null;
                    }
                };
                YYTaskExecutor.postToMainThread((Runnable)this.exceptionCheck, (long)30000L);
            }
        }
        mDialog.setCancelable(this.mCancelable);
        mDialog.setCanceledOnTouchOutside(this.mOutSideCancelable);
        mDialog.setContentView(R.layout.layout_progress_dialog);
        this.mTvTip = (TextView)mDialog.findViewById(R.id.tv_tip);
        if (this.mDimAmount != -10.0f) {
            mDialog.getWindow().setDimAmount(this.mDimAmount);
        }
        this.loadingProgress = (ProgressBar)mDialog.findViewById(R.id.loading_progress);
        this.loadingContainerBg = (YYLinearLayout)mDialog.findViewById(R.id.loading_container_bg);
        this.mSvgaLoading = (SVGAImageView)mDialog.findViewById(R.id.svga_loading);
        if (!TextUtils.isEmpty((CharSequence)this.mMsg)) {
            this.mSvgaLoading.setVisibility(8);
            this.mTvTip.setVisibility(0);
            this.loadingProgress.setVisibility(0);
            this.loadingContainerBg.setBackgroundResource(R.drawable.bg_loading_have_text);
            this.mTvTip.setText((CharSequence)this.mMsg);
        } else {
            this.mSvgaLoading.setVisibility(0);
            this.mTvTip.setVisibility(8);
            this.loadingProgress.setVisibility(8);
            this.loadingContainerBg.setBackgroundToNull();
            MLog.info((Object)"ProgressDialog", (String)"start load svga!", (Object[])new Object[0]);
            SvgaLoader.load((SVGAImageView)this.mSvgaLoading, (String)"loading.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    if (ProgressDialog.this.mSvgaLoading != null && ProgressDialog.this.mDialog != null && ProgressDialog.this.mDialog.isShowing()) {
                        MLog.info((Object)"ProgressDialog", (String)"start svga!", (Object[])new Object[0]);
                        ProgressDialog.this.mSvgaLoading.startAnimation();
                    } else {
                        MLog.info((Object)"ProgressDialog", (String)"svga is null!", (Object[])new Object[0]);
                    }
                }

                public void onFailed(Exception e) {
                    MLog.error((Object)"ProgressDialog", (String)"load svga fail:", (Throwable)e, (Object[])new Object[0]);
                }
            });
            this.mSvgaLoading.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    MLog.info((Object)"ProgressDialog", (String)"onViewAttachedToWindow!", (Object[])new Object[0]);
                }

                public void onViewDetachedFromWindow(View v) {
                    if (ProgressDialog.this.mSvgaLoading != null) {
                        ProgressDialog.this.mSvgaLoading.stopAnimation();
                        MLog.info((Object)"ProgressDialog", (String)"onViewDetachedFromWindow!", (Object[])new Object[0]);
                    }
                }
            });
        }
        if (RuntimeContext.sIsDebuggable) {
            mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (ProgressDialog.this.exceptionCheck != null) {
                        YYTaskExecutor.removeRunnableFromMainThread((Runnable)ProgressDialog.this.exceptionCheck);
                        ProgressDialog.this.exceptionCheck = null;
                    }
                    if (ProgressDialog.this.mListener != null) {
                        ProgressDialog.this.mListener.onDismiss(dialog);
                    }
                }
            });
        } else if (this.mListener != null) {
            mDialog.setOnDismissListener(this.mListener);
        }
        if (this.mCancelListener != null) {
            mDialog.setOnCancelListener(this.mCancelListener);
        }
    }

    public void setCancelListener(DialogInterface.OnCancelListener listener2) {
        this.mCancelListener = listener2;
        if (this.mDialog != null) {
            this.mDialog.setOnCancelListener(this.mCancelListener);
        }
    }

    public void setText(String text) {
        this.mTip = text;
    }

    public void setMax(int max) {
        this.mProgressMax = max;
    }

    public void setProgress(int progress) {
        if (this.mDialog != null && this.mDialog.isShowing() && this.mProgressMax > 0 && this.mTvTip != null) {
            this.mTvTip.setText((CharSequence)(this.mTip + progress * 100 / this.mProgressMax + "%"));
        }
    }

    public int getId() {
        return DialogId.normalProgressDialog;
    }
}

