/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;

public class ConfirmDialog
implements BaseDialog {
    private CharSequence message;
    private CharSequence confirmLabel;
    private OkDialogListener confirmListener;
    private boolean withCloseBtn;
    private View.OnClickListener closeBtnListener;
    private DialogInterface.OnDismissListener dismissListener;
    private boolean cancelable;
    private boolean canceledOnClickOutside;

    private ConfirmDialog(Builder builder) {
        this.message = builder.message;
        this.confirmLabel = builder.confirmLabel;
        this.confirmListener = builder.confirmListener;
        this.withCloseBtn = builder.withCloseBtn;
        this.closeBtnListener = builder.closeBtnListener;
        this.dismissListener = builder.dismissListener;
        this.cancelable = builder.cancelable;
        this.canceledOnClickOutside = builder.canceledOnClickOutside;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.canceledOnClickOutside);
        dialog.show();
        dialog.setOnDismissListener(this.dismissListener);
        Window window = dialog.getWindow();
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.layout_confirm_dialog);
        TextView tip = (TextView)window.findViewById(R.id.message);
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            tip.setText(this.message);
        }
        tip.setMovementMethod(LinkMovementMethod.getInstance());
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (ConfirmDialog.this.confirmListener != null) {
                    ConfirmDialog.this.confirmListener.onOk();
                }
            }
        });
        if (this.withCloseBtn) {
            RecycleImageView closeBtn = (RecycleImageView)window.findViewById(R.id.close_icon);
            closeBtn.setVisibility(0);
            closeBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                    if (ConfirmDialog.this.closeBtnListener != null) {
                        ConfirmDialog.this.closeBtnListener.onClick(v);
                    }
                }
            });
        }
    }

    public int getId() {
        return DialogId.normalConfirmDialog;
    }

    public static final class Builder {
        private CharSequence message;
        private CharSequence confirmLabel;
        private OkDialogListener confirmListener;
        private boolean withCloseBtn;
        private View.OnClickListener closeBtnListener;
        private DialogInterface.OnDismissListener dismissListener;
        private boolean cancelable = true;
        private boolean canceledOnClickOutside;

        private Builder() {
        }

        public Builder message(CharSequence val) {
            this.message = val;
            return this;
        }

        public Builder confirmLabel(CharSequence val) {
            this.confirmLabel = val;
            return this;
        }

        public Builder confirmListener(OkDialogListener val) {
            this.confirmListener = val;
            return this;
        }

        public Builder withCloseBtn(boolean val) {
            this.withCloseBtn = val;
            return this;
        }

        public Builder closeBtnListener(View.OnClickListener val) {
            this.closeBtnListener = val;
            return this;
        }

        public Builder dismissListener(DialogInterface.OnDismissListener val) {
            this.dismissListener = val;
            return this;
        }

        public Builder cancelable(boolean val) {
            this.cancelable = val;
            return this;
        }

        public Builder canceledOnClickOutside(boolean val) {
            this.canceledOnClickOutside = val;
            return this;
        }

        public ConfirmDialog build() {
            return new ConfirmDialog(this);
        }
    }
}

