/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Keep;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;

public abstract class BaseItemBinder<T, H extends ViewHolder<T>>
extends ItemViewBinder<T, H> {
    protected View createItemView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent, @LayoutRes int id2) {
        return inflater.inflate(id2, parent, false);
    }

    protected void onViewDetachedFromWindow(@NonNull H holder) {
        super.onViewDetachedFromWindow(holder);
        ((ViewHolder)((Object)holder)).onViewDetach();
    }

    protected void onViewAttachedToWindow(@NonNull H holder) {
        super.onViewAttachedToWindow(holder);
        ((ViewHolder)((Object)holder)).onViewAttach();
    }

    @NonNull
    protected abstract H onCreateViewHolder(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    protected void onBindViewHolder(@NonNull H holder, @NonNull T item) {
        ((ViewHolder)((Object)holder)).setData(item);
    }

    protected void onBindViewHolder(@NonNull H holder, @NonNull T item, @NonNull List<Object> payloads) {
        if (FP.empty(payloads)) {
            super.onBindViewHolder(holder, item, payloads);
        } else {
            ((ViewHolder)((Object)holder)).onPartialUpdate(item, payloads);
        }
    }

    public static class ItemClickViewHolder<T>
    extends ViewHolder<T> {
        public ItemClickViewHolder(View itemView) {
            super(itemView);
        }

        public void setItemClickListener(View.OnClickListener l) {
            this.itemView.setOnClickListener(v -> l.onClick(v));
        }
    }

    public static class ViewHolder<T>
    extends RecyclerView.ViewHolder
    implements IRecycleView.IRecycleViewCallback {
        private T itemData;
        private boolean isViewDetach = false;
        private static boolean sEnableLog;
        private boolean isRecycleView;

        @Keep
        public ViewHolder(View itemView) {
            super(itemView);
            if (itemView instanceof IRecycleView) {
                ((IRecycleView)itemView).addListener((IRecycleView.IRecycleViewCallback)this);
                this.isRecycleView = true;
            } else {
                this.isRecycleView = false;
            }
            this.isViewDetach = false;
        }

        public void setData(T data2) {
            this.itemData = data2;
        }

        public T getData() {
            return this.itemData;
        }

        public void onViewDetach() {
            if (this.isRecycleView) {
                return;
            }
            this.isViewDetach = true;
            this.onViewHide();
            if (sEnableLog) {
                MLog.info((Object)"ViewHolder", (String)"onViewDetach holder:%s, view:%s", (Object[])new Object[]{this.toString(), this.itemView.toString()});
            }
        }

        public void onViewAttach() {
            if (this.isRecycleView) {
                return;
            }
            this.isViewDetach = false;
            this.onViewShow();
            if (sEnableLog) {
                MLog.info((Object)"ViewHolder", (String)"onViewAttach holder:%s, view:%s", (Object[])new Object[]{this.toString(), this.itemView.toString()});
            }
        }

        public void onPartialUpdate(T item, List<Object> payloads) {
        }

        public void onViewVisible(IRecycleView view) {
            this.onViewShow();
            if (sEnableLog) {
                MLog.info((Object)"ViewHolder", (String)"onWindowRealVisible holder:%s, view:%s", (Object[])new Object[]{this.toString(), this.itemView.toString()});
            }
        }

        public void onViewInvisible(IRecycleView view) {
            this.onViewHide();
            if (sEnableLog) {
                MLog.info((Object)"ViewHolder", (String)"onWindowInvisible holder:%s, view:%s", (Object[])new Object[]{this.toString(), this.itemView.toString()});
            }
        }

        public void onViewHide() {
        }

        public void onViewShow() {
        }

        public boolean isViewHide() {
            if (this.itemView instanceof IRecycleView) {
                return !this.itemView.isAttachedToWindow() || ((IRecycleView)this.itemView).isWindowInVisible();
            }
            return this.isViewDetach;
        }

        static {
            if (SystemUtils.isShowEnvSetting()) {
                // empty if block
            }
            sEnableLog = false;
        }
    }
}

