/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.service;

import androidx.annotation.Nullable;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ServiceManagerProxy {
    private static Creator creator;
    private static List<IObserveService> mObserveList;

    public static void setCreator(Creator creator) {
        ServiceManagerProxy.creator = creator;
        ServiceManagerProxy.checkObserve();
    }

    @Nullable
    public static IServiceManager getServiceManager() {
        if (creator == null) {
            MLog.error((Object)"ServiceManagerProxy", (String)"can not user serviceManager before init", (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("can not user serviceManager before init");
            }
            return null;
        }
        return creator.getServiceManager();
    }

    public static void observeService(IObserveService observe) {
        if (observe == null) {
            return;
        }
        if (creator != null) {
            observe.onServiceInitFinish(ServiceManagerProxy.getServiceManager());
            return;
        }
        if (mObserveList == null) {
            mObserveList = new CopyOnWriteArrayList<IObserveService>();
        }
        mObserveList.add(observe);
    }

    private static void checkObserve() {
        if (mObserveList == null) {
            return;
        }
        IServiceManager serviceManager = ServiceManagerProxy.getServiceManager();
        for (IObserveService observe : mObserveList) {
            observe.onServiceInitFinish(serviceManager);
        }
        mObserveList.clear();
    }

    public static <T extends IService> T getService(Class<T> klass) {
        IServiceManager manager = ServiceManagerProxy.getServiceManager();
        if (manager != null) {
            return manager.getService(klass);
        }
        return null;
    }

    public static boolean hadInit() {
        return creator != null && creator.getServiceManager() != null;
    }

    public static IServiceManager getInstance() {
        return ServiceManagerProxy.getServiceManager();
    }

    static {
        mObserveList = null;
    }

    public static interface IObserveService {
        public void onServiceInitFinish(IServiceManager var1);
    }

    public static interface Creator {
        public IServiceManager getServiceManager();
    }
}

