/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.resource.file;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.resource.file.IFetchResourceFilePath;
import com.yy.appbase.resource.file.IFetchResourceWithDownload;
import com.yy.appbase.resource.file.LoadStatus;
import com.yy.appbase.resource.file.ResInfo;
import com.yy.appbase.resource.file.ResLoadMetric;
import com.yy.appbase.resource.file.ResourcePersist;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ResPersistUtils {
    private static ResourcePersist mResourcePersist;

    @Deprecated
    public static synchronized void preLoad(Dir dir, Set<String> urls) {
        if (FP.empty(urls)) {
            return;
        }
        long speed = 0L;
        HashSet<ResInfo> infos = new HashSet<ResInfo>(urls.size());
        for (String url : urls) {
            infos.add(new ResInfo(url, "", null, speed));
        }
        ResPersistUtils.preLoadRes(dir, infos);
    }

    public static synchronized void preLoadRes(Dir dir, Set<ResInfo> infos) {
        ResPersistUtils.getResourcePersist().preLoad(dir, infos);
    }

    public static void fetchFilePath(Dir dir, String url, IFetchResourceFilePath callback) {
        ResPersistUtils.getResourcePersist().fetchFilePath(dir, url, callback);
    }

    public static void fetchFilePath(Dir dir, ResInfo resInfo, IFetchResourceWithDownload callback) {
        ResPersistUtils.getResourcePersist().fetchFilePathWithDownload(dir, resInfo, callback);
    }

    public static String fetchFilePath(Dir dir, String url) {
        return ResPersistUtils.getResourcePersist().fetchFilePath(dir, url);
    }

    public static String getResDirPath(Dir dir) {
        return ResPersistUtils.getResourcePersist().getResDirPath(dir);
    }

    public static void loadSvga(final SVGAImageView svgaImageView, final Dir dir, final ResInfo resInfo, final ISvgaLoadCallback callback, final boolean withoutAudio) {
        final long start = System.currentTimeMillis();
        ResPersistUtils.fetchFilePath(dir, resInfo, new IFetchResourceWithDownload(){

            @Override
            public void onError() {
                ResPersistUtils.loadSvgaWithPath("", resInfo.getUrl(), dir, svgaImageView, callback, start, withoutAudio);
            }

            @Override
            public void onFetch(@Nullable String path) {
                ResPersistUtils.loadSvgaWithPath(path, resInfo.getUrl(), dir, svgaImageView, callback, start, withoutAudio);
            }
        });
    }

    public static void loadSvga(SVGAImageView svgaImageView, Dir dir, ResInfo resInfo, ISvgaLoadCallback callback) {
        ResPersistUtils.loadSvga(svgaImageView, dir, resInfo, callback, false);
    }

    private static void loadSvgaWithPath(String path, final String url, final Dir dir, SVGAImageView svgaImageView, final ISvgaLoadCallback callback, final long start, boolean withoutAudio) {
        final LoadStatus loadStatus = TextUtils.isEmpty((CharSequence)path) ? LoadStatus.NO_CACHE : LoadStatus.HAVE_CACHE;
        path = TextUtils.isEmpty((CharSequence)path) ? url : path;
        ISvgaLoadCallback svgaLoadCallback = new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (callback != null) {
                    callback.onFinished(svgaVideoEntity);
                }
                ResPersistUtils.reportMetric(url, start, loadStatus);
            }

            public void onFailed(Exception e) {
                ResPersistUtils.getResourcePersist().delete(dir, url);
                if (callback != null) {
                    callback.onFailed(e);
                }
            }
        };
        if (withoutAudio) {
            SvgaLoader.loadWithoutAudio((SVGAImageView)svgaImageView, (String)path, (ISvgaLoadCallback)svgaLoadCallback);
        } else {
            SvgaLoader.load((SVGAImageView)svgaImageView, (String)path, (ISvgaLoadCallback)svgaLoadCallback);
        }
    }

    private static void reportMetric(String url, long start, LoadStatus loadStatus) {
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("url", url);
        ResLoadMetric.report("svga", System.currentTimeMillis() - start, loadStatus, extraInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourcePersist getResourcePersist() {
        if (mResourcePersist != null) return mResourcePersist;
        Class<ResPersistUtils> clazz = ResPersistUtils.class;
        synchronized (ResPersistUtils.class) {
            if (mResourcePersist != null) return mResourcePersist;
            mResourcePersist = new ResourcePersist();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mResourcePersist;
        }
    }

    public static enum Dir {
        GIFT_SVGA("gift_res_svga"),
        HOME_AD("home_ad_res"),
        SPLASH("plash_res"),
        AR_GIFT("ar_gift"),
        GIFT_VOICE("gift_voice"),
        GIFT_VIDEO("gift_video"),
        CHAT_THEME_VIDEO("chat_theme_video");

        String dir;

        private Dir(String dir) {
            this.dir = dir;
        }
    }
}

