/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push.tips;

import android.app.Dialog;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.Window;
import com.yy.appbase.R;
import com.yy.appbase.span.ChainSpan;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;

public class PushPermissionTipDialog
implements BaseDialog {
    private IPushTipListener mPushTipListener;
    private String tips;
    private YYTextView tipTv;
    private YYTextView noAskAgain;

    public PushPermissionTipDialog(IPushTipListener listener2) {
        this.mPushTipListener = listener2;
    }

    public PushPermissionTipDialog(String tips, IPushTipListener listener2) {
        this.mPushTipListener = listener2;
        this.tips = tips;
    }

    public void init(Dialog dialog) {
        Window window = dialog.getWindow();
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.layout_push_tip_dialog);
        dialog.setCanceledOnTouchOutside(false);
        window.setBackgroundDrawableResource(R.color.transparent);
        this.createView(window);
        window.setWindowAnimations(R.style.DialogAnimation);
    }

    private void createView(Window view) {
        view.findViewById(R.id.tv_permission_agree).setOnClickListener(v -> {
            if (this.mPushTipListener != null) {
                this.mPushTipListener.onAgreed();
            }
        });
        view.findViewById(R.id.iv_push_tip_close).setOnClickListener(v -> {
            if (this.mPushTipListener != null) {
                this.mPushTipListener.onCanceled();
            }
        });
        this.tipTv = (YYTextView)view.findViewById(R.id.tv_tip);
        if (!TextUtils.isEmpty((CharSequence)this.tips)) {
            this.tipTv.setText((CharSequence)this.tips);
        }
        this.noAskAgain = (YYTextView)view.findViewById(R.id.tv_no_ask_again);
        this.noAskAgain.setMovementMethod(LinkMovementMethod.getInstance());
        ChainSpan.of().beginBlock().append(ResourceUtils.getString((int)R.string.title_permisson_no_ask_again)).onBlockClick(() -> {
            if (this.mPushTipListener != null) {
                this.mPushTipListener.onCanceled();
            }
        }, true, ColorUtils.parseColor((String)"#CCFFFFFF")).endBlock().onFinish(data2 -> {
            if (this.noAskAgain != null && data2 != null) {
                this.noAskAgain.setText((CharSequence)data2);
            }
        }).build();
    }

    public int getId() {
        return DialogId.PushTipDialog;
    }

    public static interface IPushTipListener {
        public void onAgreed();

        public void onCanceled();
    }
}

