/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import android.os.Build;
import androidx.annotation.NonNull;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.push.PushControlConfig;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.pushhiido.ISimpleCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.PushControlBossConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import ikxd.msg.PushSourceType;
import java.util.Locale;

public class PushConfigManager {
    private static final String TAG = "PushConfigManager";
    private PushControlConfig mControlConfig;
    private static final int CONFIG_UNINITIALIZED = -1;
    private static final int CONFIG_FROM_FILE = 0;
    private static final int CONFIG_FROM_BOSS = 1;
    private int mReadFrom = -1;

    public static PushConfigManager getInstance() {
        return SingleHolder.mInstance;
    }

    private PushConfigManager() {
    }

    private void onCallBackOngoing(final boolean ongoing, final @NonNull ISimpleCallback<Boolean> simpleCallback) {
        if (YYTaskExecutor.isMainThread()) {
            simpleCallback.onSuccess(ongoing);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    simpleCallback.onSuccess(ongoing);
                }
            });
        }
    }

    public void getPushOngoingValue(PushNotificationData pushNotificationData, @NonNull ISimpleCallback<Boolean> simpleCallback) {
        MLog.info((Object)TAG, (String)"getPushOngoingValue pushSource: %s", (Object[])new Object[]{pushNotificationData.getPushSource()});
        if (pushNotificationData.getPushSource() == PushSourceType.kPushSourceChannel || PushSourceType.kPushSourceFloatPush == pushNotificationData.getPushSource()) {
            this.onCallBackOngoing(false, simpleCallback);
            return;
        }
        this.getPushControlConfig(config -> {
            MLog.info((Object)TAG, (String)"getPushClearConfig AB: %s config: %s", (Object[])new Object[]{NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest(), config});
            PushControlConfig.NotifyClearConfig clearConfig = this.getClearConfigByABTest(config);
            if (clearConfig == null) {
                MLog.info((Object)TAG, (String)"getPushClearConfig clearConfig is null", (Object[])new Object[0]);
                this.onCallBackOngoing(true, simpleCallback);
            } else {
                boolean ongoingValue = this.judgeOngoingValue(clearConfig, pushNotificationData);
                MLog.info((Object)TAG, (String)"getPushClearConfig ongoingValue: %s", (Object[])new Object[]{ongoingValue});
                this.onCallBackOngoing(ongoingValue, simpleCallback);
            }
        });
    }

    public synchronized boolean isGroupBlackList() {
        AConfigData data2;
        PushControlConfig config = null;
        if (this.mReadFrom == 0 && (data2 = UnifyConfig.INSTANCE.getConfigData(BssCode.PUSH_CLEAR_CONFIG)) instanceof PushControlBossConfig) {
            this.mControlConfig = ((PushControlBossConfig)data2).getPushControlConfig();
            this.mReadFrom = 1;
        }
        if (this.mReadFrom == -1) {
            this.readFromFile(new IGetPushControlConfigCallback(){

                @Override
                public void completed(PushControlConfig config) {
                }
            });
        }
        if ((config = this.mControlConfig) != null) {
            String find;
            final String manufacturer = Build.MANUFACTURER;
            String model = Build.MODEL;
            final String modelLowerCase = model.toLowerCase(Locale.getDefault());
            MLog.info((Object)TAG, (String)"push check control config, manufacturer: %s, model: %s", (Object[])new Object[]{manufacturer, model});
            if (StringUtils.isNotEmpty((String)manufacturer) && (find = (String)FP.find((FP.Pred)new FP.Pred<String>(){

                public boolean pred(String item) {
                    return StringUtils.equalsIgnoreCase((String)manufacturer, (String)item);
                }
            }, config.manufacturerGroupBlackList)) != null) {
                MLog.info((Object)TAG, (String)"isGroupBlacklist, manufacturer: %s, find: %s", (Object[])new Object[]{manufacturer, find});
                return true;
            }
            if (StringUtils.isNotEmpty((String)model) && (find = (String)FP.find((FP.Pred)new FP.Pred<String>(){

                public boolean pred(String item) {
                    if (item != null) {
                        return modelLowerCase.contains(item.toLowerCase(Locale.getDefault()));
                    }
                    return false;
                }
            }, config.modelGroupBlackList)) != null) {
                MLog.info((Object)TAG, (String)"isGroupBlacklist, model: %s, find: %s", (Object[])new Object[]{model, find});
                return true;
            }
        }
        return false;
    }

    private synchronized void getPushControlConfig(@NonNull IGetPushControlConfigCallback callback) {
        if (this.mReadFrom == 1) {
            callback.completed(this.mControlConfig);
            return;
        }
        AConfigData data2 = UnifyConfig.INSTANCE.getConfigData(BssCode.PUSH_CLEAR_CONFIG);
        if (data2 instanceof PushControlBossConfig) {
            this.mControlConfig = ((PushControlBossConfig)data2).getPushControlConfig();
            this.mReadFrom = 1;
            callback.completed(this.mControlConfig);
            return;
        }
        if (this.mReadFrom == 0) {
            callback.completed(this.mControlConfig);
            return;
        }
        this.readFromFile(callback);
    }

    private void readFromFile(@NonNull IGetPushControlConfigCallback callback) {
        YYTaskExecutor.execute(() -> {
            try {
                PushControlConfig controlConfig = null;
                PushConfigManager pushConfigManager = this;
                synchronized (pushConfigManager) {
                    if (this.mReadFrom == -1) {
                        String json = FileStorageUtils.getInstance().getStrFromFile(true, "PushClearBossConfig");
                        this.mControlConfig = (PushControlConfig)JsonParser.parseJsonObject((String)json, PushControlConfig.class);
                        this.mReadFrom = 0;
                    }
                    controlConfig = this.mControlConfig;
                }
                PushControlConfig finalConfig = controlConfig;
                YYTaskExecutor.postToMainThread(() -> callback.completed(finalConfig));
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"read from file error", (Throwable)e, (Object[])new Object[0]);
            }
        });
    }

    private boolean judgeOngoingValue(PushControlConfig.NotifyClearConfig clearConfig, PushNotificationData pushNotificationData) {
        if (pushNotificationData == null) {
            return false;
        }
        int pushSourceType = pushNotificationData.getPushSource().getValue();
        if (!FP.empty(clearConfig.notCanClearPushSource) && clearConfig.notCanClearPushSource.contains(pushSourceType)) {
            MLog.info((Object)TAG, (String)"judgeOngoingValue config notCanClearPushSource : %s", (Object[])new Object[]{pushSourceType});
            return true;
        }
        if (!FP.empty(clearConfig.canClearPushSource) && clearConfig.canClearPushSource.contains(pushSourceType)) {
            MLog.info((Object)TAG, (String)"judgeOngoingValue config canClearPushSource : %s", (Object[])new Object[]{pushSourceType});
            return false;
        }
        if (FP.empty(clearConfig.canClearChannel)) {
            return true;
        }
        int channelId = pushNotificationData.getGroup().getId();
        MLog.info((Object)TAG, (String)"judgeOngoingValue get channelId: %s", (Object[])new Object[]{channelId});
        for (int i = 0; i < clearConfig.canClearChannel.size(); ++i) {
            PushControlConfig.ClearChannelConfig channel = clearConfig.canClearChannel.get(i);
            if (channel == null || channel.channelId != channelId) continue;
            MLog.info((Object)TAG, (String)"judgeOngoingValue needOpen: %s  openTimes: %s", (Object[])new Object[]{channel.needOpenApp, RuntimeContext.getTodayOpenTimes()});
            return channel.needOpenApp && RuntimeContext.getTodayOpenTimes() < 1;
        }
        return true;
    }

    private PushControlConfig.NotifyClearConfig getClearConfigByABTest(PushControlConfig config) {
        String plan = this.getUserPlan();
        MLog.info((Object)TAG, (String)"getClearConfigByABTest plan: %s", (Object[])new Object[]{plan});
        if (FP.empty((CharSequence)plan)) {
            return null;
        }
        if (config == null || FP.empty(config.notifyClearConfigList)) {
            return null;
        }
        for (int i = 0; i < config.notifyClearConfigList.size(); ++i) {
            PushControlConfig.NotifyClearConfig clearConfig = config.notifyClearConfigList.get(i);
            if (clearConfig == null || !StringUtils.equalsIgnoreCase((String)plan, (String)clearConfig.testPlan)) continue;
            return clearConfig;
        }
        return null;
    }

    private String getUserPlan() {
        if (NAB.A.equals(NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest())) {
            return "A";
        }
        if (NAB.B.equals(NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest())) {
            return "B";
        }
        if (NAB.C.equals(NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest())) {
            return "C";
        }
        return "";
    }

    public static interface IGetPushControlConfigCallback {
        public void completed(PushControlConfig var1);
    }

    private static class SingleHolder {
        public static PushConfigManager mInstance = new PushConfigManager();

        private SingleHolder() {
        }
    }
}

