/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.helper;

import android.app.Activity;
import androidx.annotation.NonNull;
import com.yy.appbase.permission.AndPermission;
import com.yy.appbase.permission.Permission;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelperController;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.util.HashMap;
import java.util.List;

public class PermissionHelperUtil {
    private static final String TAG = "PermissionHelperUtil";
    private static HashMap<String, IPermissionListener> listenerMap = new HashMap();

    public static IPermissionListener getPermissionListener(String key) {
        return listenerMap.remove(key);
    }

    public static void requestPermission(@NonNull Activity activity, String illustateTip, String remindTip, String alwaysDenyiedTip, @NonNull String[] permissions, @NonNull IPermissionListener listener2) {
        PermissionHelperUtil.requestPermission(activity, illustateTip, remindTip, alwaysDenyiedTip, permissions, false, listener2);
    }

    public static void requestPermission(final @NonNull Activity activity, final String illustateTip, final String remindTip, final String alwaysDenyiedTip, final @NonNull String[] permissions, final boolean fromHasPermission, @NonNull IPermissionListener listener2) {
        if (listener2 == null) {
            listener2 = new IPermissionListener(){

                @Override
                public void onPermissionGranted(@NonNull String[] permission) {
                }

                @Override
                public void onPermissionDenied(@NonNull String[] permission) {
                }
            };
        }
        final IPermissionListener listener1 = listener2;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String key = String.valueOf(System.currentTimeMillis());
                listenerMap.put(key, listener1);
                PermissionHelperController permissionHelperController = new PermissionHelperController(activity);
                permissionHelperController.actionToCheckPermission(illustateTip, remindTip, alwaysDenyiedTip, key, permissions, fromHasPermission);
            }
        });
    }

    public static boolean hasPermission(@NonNull Activity activity, String ... permissions) {
        List<String> denied = AndPermission.hasPermissionDenied(activity, permissions);
        return denied == null || denied.size() <= 0;
    }

    public static boolean hasPermissioWithDoubleCheck(@NonNull Activity activity, String ... permissions) {
        List<String> denied = AndPermission.hasPermissionDeniedWithDoubleCheck(activity, permissions);
        return denied == null || denied.size() <= 0;
    }

    public static boolean permissionContact(String[] permissions) {
        return Permission.Group.CONTACTS_READ.equals(permissions);
    }

    public static boolean permissionLocation(String[] permissions) {
        return Permission.Group.LOCATION.equals(permissions);
    }

    public static boolean permissionRecordAudio(String[] permissions) {
        return Permission.Group.RECORD_AUDIO.equals(permissions);
    }

    public static boolean permissionCamera(String[] permissions) {
        return Permission.Group.CAMERA.equals(permissions);
    }

    public static boolean permissionStorage(String[] permissions) {
        return Permission.Group.STORAGE.equals(permissions);
    }
}

