/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.yy.appbase.permission.Action;
import com.yy.appbase.permission.Rationale;
import com.yy.appbase.permission.Request;
import com.yy.appbase.permission.RequestExecutor;
import com.yy.appbase.permission.checker.DoubleChecker;
import com.yy.appbase.permission.checker.PermissionChecker;
import com.yy.appbase.permission.checker.StandardChecker;
import com.yy.appbase.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=23)
class MRequest
implements Request,
RequestExecutor,
Source.PermissionListener {
    private static final PermissionChecker CHECKER = new StandardChecker();
    private static final PermissionChecker DOUBLE_CHECKER = new DoubleChecker();
    private Source mSource;
    private String[] mPermissions;
    private Rationale mRationaleListener;
    private Action mGranted;
    private Action mDenied;
    private String[] mDeniedPermissions;

    MRequest(Source source) {
        this.mSource = source;
    }

    @Override
    @NonNull
    public Request permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    @Override
    @NonNull
    public Request permission(String[] ... groups) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group2 : groups) {
            permissionList.addAll(Arrays.asList(group2));
        }
        this.mPermissions = permissionList.toArray(new String[permissionList.size()]);
        return this;
    }

    @Override
    @NonNull
    public Request rationale(Rationale listener2) {
        this.mRationaleListener = listener2;
        return this;
    }

    @Override
    @NonNull
    public Request onGranted(Action granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    @NonNull
    public Request onDenied(Action denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public List<String> hasPermissionDenied() {
        return MRequest.getDeniedPermissions(CHECKER, this.mSource, this.mPermissions);
    }

    @Override
    public List<String> hasPermissionDeniedWithDoubleCheck() {
        return MRequest.getDeniedPermissions(DOUBLE_CHECKER, this.mSource, this.mPermissions);
    }

    @Override
    public void start() {
        List<String> deniedList = MRequest.getDeniedPermissions(CHECKER, this.mSource, this.mPermissions);
        this.mDeniedPermissions = deniedList.toArray(new String[deniedList.size()]);
        if (this.mDeniedPermissions.length > 0) {
            List<String> rationaleList = MRequest.getRationalePermissions(this.mSource, this.mDeniedPermissions);
            if (rationaleList.size() > 0 && this.mRationaleListener != null) {
                this.mRationaleListener.showRationale(this.mSource.getContext(), rationaleList, this);
            } else {
                this.execute();
            }
        } else {
            this.callbackSucceed();
        }
    }

    @Override
    @RequiresApi(api=23)
    public void execute() {
        try {
            this.mSource.requestPermission(this.mDeniedPermissions, this);
        }
        catch (Exception e) {
            this.callbackFailed(Arrays.asList(this.mPermissions));
        }
    }

    @Override
    public void cancel() {
        this.onRequestPermissionsResult(this.mDeniedPermissions);
    }

    @Override
    public void onRequestPermissionsResult(@NonNull String[] permissions) {
        List<String> deniedList = MRequest.getDeniedPermissions(CHECKER, this.mSource, permissions);
        if (deniedList.isEmpty()) {
            this.callbackSucceed();
        } else {
            this.callbackFailed(deniedList);
        }
    }

    private void callbackSucceed() {
        block3: {
            if (this.mGranted != null) {
                List<String> permissionList = Arrays.asList(this.mPermissions);
                try {
                    this.mGranted.onAction(permissionList);
                }
                catch (Exception e) {
                    if (this.mDenied == null) break block3;
                    this.mDenied.onAction(permissionList);
                }
            }
        }
    }

    private void callbackFailed(@NonNull List<String> deniedList) {
        if (this.mDenied != null) {
            this.mDenied.onAction(deniedList);
        }
    }

    private static List<String> getDeniedPermissions(PermissionChecker checker, @NonNull Source source, String ... permissions) {
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (checker.hasPermission(source.getContext(), permission)) continue;
            deniedList.add(permission);
        }
        return deniedList;
    }

    private static List<String> getRationalePermissions(@NonNull Source source, String ... permissions) {
        ArrayList<String> rationaleList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (!source.isShowRationalePermission(permission)) continue;
            rationaleList.add(permission);
        }
        return rationaleList;
    }
}

