/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.inputfilter;

import com.yy.base.utils.FP;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoticeUtils {
    public static final int MAX_NOTICE_LENGTH = 500;

    public static CharSequence cutInputStr(CharSequence curText, CharSequence inputStr) {
        int curCount = NoticeUtils.calculationNoticeSize(curText);
        if (curCount >= 500) {
            return "";
        }
        int inputCount = NoticeUtils.calculationNoticeSize(inputStr);
        if (curCount + inputCount <= 500) {
            return inputStr;
        }
        inputStr = inputStr.subSequence(0, 500 - curCount);
        return inputStr;
    }

    public static int calculationNoticeSize(CharSequence notice) {
        if (FP.empty((CharSequence)notice)) {
            return 0;
        }
        int totalSize = notice.length();
        Pattern p = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\u2100-\u32ff]|[0-\u007f][\u20d0-\u20ff]|[\u0080-\u00ff]");
        Matcher m = p.matcher(notice);
        while (m.find()) {
            String group2 = m.group();
            int size = FP.size((CharSequence)group2);
            if (size <= 1) continue;
            totalSize -= size - 1;
        }
        return totalSize;
    }
}

